/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.dav;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.DavProtocol;
import com.zimbra.cs.dav.resource.DavResource;
import com.zimbra.cs.dav.resource.UrlNamespace;
import com.zimbra.cs.dav.service.DavResponse;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.FileUploadServlet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DavContext {
    private static HashSet<Extension> sExtensions;
    private HttpServletRequest mReq;
    private HttpServletResponse mResp;
    private OperationContext mOpCtxt;
    private Account mAuthAccount;
    private String mUri;
    private String mUser;
    private String mPath;
    private int mStatus;
    private Document mRequestMsg;
    private FileUploadServlet.Upload mUpload;
    private DavResponse mResponse;
    private boolean mResponseSent;
    private DavResource mRequestedResource;
    private RequestType mRequestType;
    private String mCollectionPath;
    private RequestProp mResponseProp;
    private String mDavCompliance;
    private String mPathInfo;
    protected static RequestProp sEmptyProp;
    private static final String EVOLUTION = "Evolution";
    private static final String ICAL = "iCal/";
    private static final String IPHONE = "iPhone/";
    private static final String ADDRESSBOOK = "Address";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExtension(Extension ex) {
        HashSet<Extension> hashSet = sExtensions;
        synchronized (hashSet) {
            sExtensions.add(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeExtension(Extension ex) {
        HashSet<Extension> hashSet = sExtensions;
        synchronized (hashSet) {
            sExtensions.remove(ex);
        }
    }

    public RequestProp getRequestProp() throws DavException {
        if (this.hasRequestMessage()) {
            Document req = this.getRequestMessage();
            return new RequestProp(req.getRootElement());
        }
        return sEmptyProp;
    }

    public RequestProp getResponseProp() {
        return this.mResponseProp;
    }

    public void setResponseProp(RequestProp props) {
        this.mResponseProp = props;
    }

    public DavContext(HttpServletRequest req, HttpServletResponse resp, Account authUser) {
        int index;
        this.mReq = req;
        this.mResp = resp;
        this.mUri = req.getPathInfo();
        if (this.mUri != null && this.mUri.length() > 1 && (index = this.mUri.indexOf(47, 1)) > 0) {
            String reqType = this.mUri.substring(1, index);
            this.mRequestType = reqType.equals("home") ? RequestType.RESOURCE : RequestType.PRINCIPAL;
            int start = index + 1;
            if ((index = this.mUri.indexOf(47, index + 1)) != -1) {
                this.mUser = this.mUri.substring(start, index);
                this.mPath = this.mUri.substring(index);
            } else {
                this.mUser = this.mUri.substring(start);
                this.mPath = "/";
            }
        }
        this.mStatus = 200;
        this.mAuthAccount = authUser;
        this.mOpCtxt = new OperationContext(authUser);
        this.mOpCtxt.setUserAgent(req.getHeader("User-Agent"));
        this.mDavCompliance = DavProtocol.getDefaultComplianceString();
    }

    public HttpServletRequest getRequest() {
        return this.mReq;
    }

    public HttpServletResponse getResponse() {
        return this.mResp;
    }

    public OperationContext getOperationContext() {
        return this.mOpCtxt;
    }

    public Account getAuthAccount() {
        return this.mAuthAccount;
    }

    public String getUri() {
        return this.mUri;
    }

    public String getUser() {
        return this.mUser;
    }

    public String getPath() {
        return this.mPath;
    }

    public String getItem() {
        if (this.mPath != null) {
            if (this.mPath.equals("/")) {
                return this.mPath;
            }
            if (this.mPath.endsWith("/")) {
                int length = this.mPath.length();
                int index = this.mPath.lastIndexOf(47, length - 2);
                if (index != -1) {
                    return this.mPath.substring(index + 1, length - 1);
                }
            } else {
                int index = this.mPath.lastIndexOf(47);
                if (index != -1) {
                    return this.mPath.substring(index + 1);
                }
            }
        }
        return null;
    }

    public String getPathInfo() {
        return this.mPathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this.mPathInfo = pathInfo;
    }

    public String getCollectionPath() {
        return this.mCollectionPath;
    }

    public void setCollectionPath(String collPath) {
        this.mCollectionPath = collPath;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public void setStatus(int s) {
        this.mStatus = s;
    }

    public void responseSent() {
        this.mResponseSent = true;
    }

    public boolean isResponseSent() {
        return this.mResponseSent;
    }

    public Depth getDepth() {
        String hdr = this.mReq.getHeader("Depth");
        if (hdr == null) {
            return Depth.zero;
        }
        if (hdr.equals("0")) {
            return Depth.zero;
        }
        if (hdr.equals("1")) {
            return Depth.one;
        }
        if (hdr.equalsIgnoreCase("infinity")) {
            return Depth.infinity;
        }
        ZimbraLog.dav.info("invalid depth: " + hdr);
        return Depth.zero;
    }

    public boolean hasRequestMessage() {
        try {
            String ct = this.getUpload().getContentType();
            return this.getUpload().getSize() > 0L && ct != null && (ct.startsWith("text/xml") || ct.startsWith("application/xml"));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public FileUploadServlet.Upload getUpload() throws DavException, IOException {
        if (this.mUpload == null) {
            String name = null;
            String ctype = this.getRequest().getContentType();
            if (ctype == null) {
                name = this.getItem();
            }
            try {
                this.mUpload = FileUploadServlet.saveUpload((InputStream)this.mReq.getInputStream(), name, ctype, this.mAuthAccount.getId());
                ZimbraLog.dav.debug("Request: requested content-type: %s, actual content-type: %s", ctype, this.mUpload.getContentType());
            }
            catch (ServiceException se) {
                throw new DavException("can't save upload", se);
            }
        }
        return this.mUpload;
    }

    public void cleanup() {
        if (sExtensions.size() > 0) {
            for (Extension ex : sExtensions) {
                ex.callback(this);
            }
        }
        if (this.mUpload != null) {
            FileUploadServlet.deleteUpload(this.mUpload);
        }
        this.mUpload = null;
    }

    public Document getRequestMessage() throws DavException {
        if (this.mRequestMsg != null) {
            return this.mRequestMsg;
        }
        try {
            if (this.hasRequestMessage()) {
                this.mRequestMsg = com.zimbra.common.soap.Element.getSAXReader().read(this.getUpload().getInputStream());
                return this.mRequestMsg;
            }
        }
        catch (DocumentException e) {
            throw new DavException("unable to parse request message", 400, e);
        }
        catch (IOException e) {
            throw new DavException("can't read uploaded file", 500, e);
        }
        throw new DavException("no request msg", 400, null);
    }

    public boolean hasResponseMessage() {
        return this.mResponse != null;
    }

    public DavResponse getDavResponse() {
        if (this.mResponse == null) {
            this.mResponse = new DavResponse();
        }
        return this.mResponse;
    }

    public DavResource getRequestedResource() throws DavException, ServiceException {
        if (this.mRequestedResource == null) {
            this.mRequestedResource = this.mRequestType == RequestType.RESOURCE ? UrlNamespace.getResourceAt(this, this.mUser, this.mPath) : UrlNamespace.getPrincipalAtUrl(this, this.mUri);
            if (this.mRequestedResource != null) {
                ZimbraLog.addToContext("name", this.mRequestedResource.getOwner());
            }
        }
        if (this.mRequestedResource == null) {
            throw new DavException("no DAV resource at " + this.mUri, 404, null);
        }
        return this.mRequestedResource;
    }

    public Collection<DavResource> getAllRequestedResources() throws DavException, ServiceException {
        ArrayList<DavResource> rss = new ArrayList<DavResource>();
        if (this.mRequestType == RequestType.RESOURCE) {
            return UrlNamespace.getResources(this, this.mUser, this.mPath, this.getDepth() == Depth.one);
        }
        DavResource rs = UrlNamespace.getPrincipalAtUrl(this, this.mUri);
        if (rs != null) {
            ZimbraLog.addToContext("name", rs.getOwner());
            rss.add(rs);
            if (this.getDepth() == Depth.one) {
                rss.addAll(rs.getChildren(this));
            }
        }
        return rss;
    }

    public Mailbox getTargetMailbox() throws ServiceException {
        Account acct = Provisioning.getInstance().getAccountByName(this.mUser);
        if (acct == null) {
            return null;
        }
        return MailboxManager.getInstance().getMailboxByAccount(acct);
    }

    private boolean userAgentHeaderContains(String str) {
        String userAgent = this.mReq.getHeader("User-Agent");
        if (userAgent == null) {
            return false;
        }
        return userAgent.indexOf(str) >= 0;
    }

    public boolean isAddressbookClient() {
        return this.userAgentHeaderContains(ADDRESSBOOK);
    }

    public boolean isIcalClient() {
        return this.userAgentHeaderContains(ICAL);
    }

    public KnownUserAgent getKnownUserAgent() {
        String userAgent = this.mReq.getHeader("User-Agent");
        return KnownUserAgent.lookup(userAgent);
    }

    public boolean isSchedulingEnabled() {
        try {
            return !Provisioning.getInstance().getConfig().getBooleanAttr("zimbraCalendarCalDavDisableScheduling", false);
        }
        catch (ServiceException se) {
            return false;
        }
    }

    public boolean isFreebusyEnabled() {
        try {
            return !Provisioning.getInstance().getConfig().getBooleanAttr("zimbraCalendarCalDavDisableFreebusy", false);
        }
        catch (ServiceException se) {
            return false;
        }
    }

    public boolean isGzipAccepted() {
        Enumeration acceptEncHdrs = this.mReq.getHeaders("Accept-Encoding");
        while (acceptEncHdrs.hasMoreElements()) {
            String acceptEnc = (String)acceptEncHdrs.nextElement();
            if (acceptEnc == null || !acceptEnc.toLowerCase().contains("gzip")) continue;
            return true;
        }
        return false;
    }

    public void setDavCompliance(String comp) {
        this.mDavCompliance = comp;
    }

    public String getDavCompliance() {
        return this.mDavCompliance;
    }

    public boolean useIcalDelegation() {
        if (this.mAuthAccount != null) {
            return this.mAuthAccount.isPrefAppleIcalDelegationEnabled();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<DavContext> clazz = DavContext.class;
        synchronized (DavContext.class) {
            if (sExtensions == null) {
                sExtensions = new HashSet();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            sEmptyProp = new RequestProp(false);
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KnownUserAgent {
        iCal,
        iPhone,
        Evolution;


        static KnownUserAgent lookup(String userAgent) {
            if (userAgent != null) {
                if (userAgent.indexOf(DavContext.IPHONE) >= 0) {
                    return iPhone;
                }
                if (userAgent.indexOf(DavContext.ICAL) >= 0) {
                    return iCal;
                }
                if (userAgent.indexOf(DavContext.EVOLUTION) >= 0) {
                    return Evolution;
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Depth {
        zero,
        one,
        infinity;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RequestProp {
        boolean nameOnly;
        boolean allProp;
        HashMap<QName, Element> props = new HashMap();
        HashMap<QName, DavException> errProps = new HashMap();

        public RequestProp(boolean no) {
            this.nameOnly = no;
            this.allProp = true;
        }

        public RequestProp(Element top) {
            this(false);
            this.allProp = false;
            for (Object obj : top.elements()) {
                if (!(obj instanceof Element)) continue;
                Element e = (Element)obj;
                String name = e.getName();
                if (name.equals("allprop")) {
                    this.allProp = true;
                    continue;
                }
                if (name.equals("propname")) {
                    this.nameOnly = true;
                    continue;
                }
                if (!name.equals("prop")) continue;
                List propElems = e.elements();
                for (Element prop : propElems) {
                    this.props.put(prop.getQName(), prop);
                }
            }
        }

        public RequestProp(Collection<Element> set, Collection<QName> remove) {
            this(false);
            this.allProp = false;
            for (Element e : set) {
                this.props.put(e.getQName(), e);
            }
            for (QName q : remove) {
                this.props.put(q, DocumentHelper.createElement(q));
            }
        }

        public boolean isNameOnly() {
            return this.nameOnly;
        }

        public boolean isAllProp() {
            return this.allProp;
        }

        public void addProp(Element p) {
            this.allProp = false;
            this.props.put(p.getQName(), p);
        }

        public Collection<QName> getProps() {
            return this.props.keySet();
        }

        public Element getProp(QName p) {
            return this.props.get(p);
        }

        public void addPropError(QName prop, DavException ex) {
            this.allProp = false;
            if (!this.props.containsKey(prop)) {
                this.props.put(prop, DocumentHelper.createElement(prop));
            }
            this.errProps.put(prop, ex);
        }

        public Map<QName, DavException> getErrProps() {
            return this.errProps;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RequestType {
        PRINCIPAL,
        RESOURCE;

    }

    public static interface Extension {
        public void callback(DavContext var1);
    }
}

