/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource.imap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.SSLSocketFactoryManager;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.datasource.LogOutputStream;
import com.zimbra.cs.datasource.MailItemImport;
import com.zimbra.cs.mailclient.imap.ImapConfig;
import com.zimbra.cs.mailclient.imap.ImapConnection;
import java.io.PrintStream;

public abstract class ImapImport
extends MailItemImport {
    private final ImapConnection connection;

    public ImapImport(DataSource ds) throws ServiceException {
        super(ds);
        this.connection = new ImapConnection(ImapImport.getImapConfig(ds));
    }

    public static ImapConfig getImapConfig(DataSource ds) {
        ImapConfig config = new ImapConfig();
        config.setHost(ds.getHost());
        config.setPort(ds.getPort());
        config.setAuthenticationId(ds.getUsername());
        config.setSecurity(ImapImport.getSecurity(ds.getConnectionType()));
        config.setUseLiteralPlus(false);
        if (ds.isDebugTraceEnabled()) {
            config.setDebug(true);
            config.setTrace(true);
            config.setMaxLiteralTraceSize(ds.getIntAttr("zimbraDataSourceMaxTraceSize", 0));
            config.setTraceStream(new PrintStream(new LogOutputStream(ZimbraLog.imap), true));
        }
        config.setSSLSocketFactory(SSLSocketFactoryManager.getDefaultSSLSocketFactory());
        return config;
    }
}

