/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource.imap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.datasource.ImapFolder;
import com.zimbra.cs.datasource.imap.ImapImport;
import com.zimbra.cs.db.DbImapFolder;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import java.util.ArrayList;
import java.util.List;

public class FolderChanges {
    private final ImapImport imapImport;
    private final int lastSync;
    private List<Change> changes;

    public FolderChanges(ImapImport imapImport, int lastSync) {
        this.imapImport = imapImport;
        this.lastSync = lastSync;
        this.changes = new ArrayList<Change>();
    }

    private void loadChanges() throws ServiceException {
        Mailbox mb = this.imapImport.getMailbox();
        for (Folder folder : mb.getModifiedFolders(this.lastSync)) {
            Change change = new Change(folder, this.getImapFolder(folder.getId()));
            if (!change.isChanged()) continue;
            this.changes.add(change);
        }
        List<Integer> deletedIds = mb.getTombstones(this.lastSync).getIds((byte)1);
        if (deletedIds != null) {
            for (int id : deletedIds) {
                Change change = new Change(null, this.getImapFolder(id));
                if (!change.isChanged()) continue;
                this.changes.add(change);
            }
        }
    }

    private ImapFolder getImapFolder(int id) throws ServiceException {
        return DbImapFolder.getImapFolder(this.imapImport.getMailbox(), this.imapImport.getDataSource(), id);
    }

    private class Change {
        final Folder folder;
        final ImapFolder imapFolder;

        Change(Folder folder, ImapFolder imapFolder) {
            this.folder = folder;
            this.imapFolder = imapFolder;
        }

        public boolean isChanged() {
            return this.isCreated() || this.isDeleted() || this.isRenamed();
        }

        public boolean isCreated() {
            return this.folder != null && this.imapFolder == null;
        }

        public boolean isDeleted() {
            return this.folder == null && this.imapFolder != null;
        }

        public boolean isRenamed() {
            return this.folder != null && this.imapFolder != null && !this.folder.getPath().equals(this.imapFolder.getLocalPath());
        }
    }
}

