/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.common.util.SSLSocketFactoryManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class TlsSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory factory = SSLSocketFactoryManager.getDefaultSSLSocketFactory();
    private static final TlsSocketFactory THE_ONE = new TlsSocketFactory();

    protected TlsSocketFactory() {
    }

    public static SocketFactory getDefault() {
        return THE_ONE;
    }

    public Socket createSocket() throws IOException {
        return new Socket();
    }

    public Socket createSocket(InetAddress address, int port) throws IOException {
        return new Socket(address, port);
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return new Socket(address, port, localAddress, localPort);
    }

    public Socket createSocket(String host, int port) throws IOException {
        return new Socket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        return new Socket(host, port, localAddress, localPort);
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.factory.createSocket(s, host, port, autoClose);
    }

    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }
}

