/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailclient.imap.CAtom;
import com.zimbra.cs.mailclient.imap.Flags;
import java.util.Date;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

final class SyncUtil {
    private static final Flags EMPTY_FLAGS = new Flags();
    private static int ZFLAGS_MASK = Flag.BITMASK_REPLIED | Flag.BITMASK_DELETED | Flag.BITMASK_DRAFT | Flag.BITMASK_FLAGGED | Flag.BITMASK_UNREAD;

    SyncUtil() {
    }

    public static int imapToZimbraFlags(Flags flags) {
        int zflags = 0;
        if (flags.isAnswered()) {
            zflags |= Flag.BITMASK_REPLIED;
        }
        if (flags.isDeleted()) {
            zflags |= Flag.BITMASK_DELETED;
        }
        if (flags.isDraft()) {
            zflags |= Flag.BITMASK_DRAFT;
        }
        if (flags.isFlagged()) {
            zflags |= Flag.BITMASK_FLAGGED;
        }
        if (!flags.isSeen()) {
            zflags |= Flag.BITMASK_UNREAD;
        }
        return zflags;
    }

    public static Flags zimbraToImapFlags(int zflags) {
        return SyncUtil.getFlagsToAdd(EMPTY_FLAGS, zflags);
    }

    public static int imapFlagsOnly(int zflags) {
        return zflags & ZFLAGS_MASK;
    }

    public static Flags getFlagsToAdd(Flags flags, int zflags) {
        Flags toAdd = new Flags();
        if (!flags.isAnswered() && (zflags & Flag.BITMASK_REPLIED) != 0) {
            toAdd.set(CAtom.F_ANSWERED.atom());
        }
        if (!flags.isDeleted() && (zflags & Flag.BITMASK_DELETED) != 0) {
            toAdd.set(CAtom.F_DELETED.atom());
        }
        if (!flags.isDraft() && (zflags & Flag.BITMASK_DRAFT) != 0) {
            toAdd.set(CAtom.F_DRAFT.atom());
        }
        if (!flags.isFlagged() && (zflags & Flag.BITMASK_FLAGGED) != 0) {
            toAdd.set(CAtom.F_FLAGGED.atom());
        }
        if (!flags.isSeen() && (zflags & Flag.BITMASK_UNREAD) == 0) {
            toAdd.set(CAtom.F_SEEN.atom());
        }
        return toAdd;
    }

    public static Flags getFlagsToRemove(Flags flags, int zflags) {
        Flags toRemove = new Flags();
        if (flags.isAnswered() && (zflags & Flag.BITMASK_REPLIED) == 0) {
            toRemove.set(CAtom.F_ANSWERED.atom());
        }
        if (flags.isDeleted() && (zflags & Flag.BITMASK_DELETED) == 0) {
            toRemove.set(CAtom.F_DELETED.atom());
        }
        if (flags.isDraft() && (zflags & Flag.BITMASK_DRAFT) == 0) {
            toRemove.set(CAtom.F_DRAFT.atom());
        }
        if (flags.isFlagged() && (zflags & Flag.BITMASK_FLAGGED) == 0) {
            toRemove.set(CAtom.F_FLAGGED.atom());
        }
        if (flags.isSeen() && (zflags & Flag.BITMASK_UNREAD) != 0) {
            toRemove.set(CAtom.F_SEEN.atom());
        }
        return toRemove;
    }

    public static Date getInternalDate(Message msg, MimeMessage mm) {
        Date date = null;
        try {
            date = mm.getReceivedDate();
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return date != null ? date : new Date(msg.getDate());
    }

    public static void setSyncEnabled(Mailbox mbox, int folderId, boolean enabled) throws ServiceException {
        mbox.alterTag(new OperationContext(mbox), folderId, (byte)1, -26, enabled);
    }
}

