/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.cs.account.DataSource;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public final class SyncErrorManager {
    private static final int MAX_ENTRIES = 64000;
    private static final Map<String, AtomicInteger> ERRORS = new LinkedHashMap<String, AtomicInteger>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry e) {
            return this.size() > 64000;
        }
    };

    private static String key(DataSource ds, ItemType type, Object id) {
        return String.format("%s:%s:%s", new Object[]{ds.getId(), type, id});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearErrors(DataSource ds) {
        String prefix = ds.getId() + ":";
        Map<String, AtomicInteger> map = ERRORS;
        synchronized (map) {
            Iterator<String> it = ERRORS.keySet().iterator();
            while (it.hasNext()) {
                if (!it.next().startsWith(prefix)) continue;
                it.remove();
            }
        }
    }

    public static int incrementErrorCount(DataSource ds, int itemId) {
        return SyncErrorManager.incrementErrorCount(ds, ItemType.ITEM_ID, itemId);
    }

    public static int incrementErrorCount(DataSource ds, String remoteId) {
        return SyncErrorManager.incrementErrorCount(ds, ItemType.REMOTE_ID, remoteId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int incrementErrorCount(DataSource ds, ItemType type, Object id) {
        String key = SyncErrorManager.key(ds, type, id);
        Map<String, AtomicInteger> map = ERRORS;
        synchronized (map) {
            AtomicInteger count = ERRORS.get(key);
            if (count == null) {
                count = new AtomicInteger();
                ERRORS.put(key, count);
            }
            return count.incrementAndGet();
        }
    }

    public static void clearError(DataSource ds, int itemId) {
        SyncErrorManager.clearError(ds, ItemType.ITEM_ID, itemId);
    }

    public static void clearError(DataSource ds, String remoteId) {
        SyncErrorManager.clearError(ds, ItemType.REMOTE_ID, remoteId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearError(DataSource ds, ItemType type, Object id) {
        Map<String, AtomicInteger> map = ERRORS;
        synchronized (map) {
            ERRORS.remove(SyncErrorManager.key(ds, type, id));
        }
    }

    public static int getErrorCount(DataSource ds, int itemId) {
        return SyncErrorManager.getErrorCount(ds, ItemType.ITEM_ID, itemId);
    }

    public static int getErrorCount(DataSource ds, String remoteId) {
        return SyncErrorManager.getErrorCount(ds, ItemType.REMOTE_ID, remoteId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getErrorCount(DataSource ds, ItemType type, Object id) {
        Map<String, AtomicInteger> map = ERRORS;
        synchronized (map) {
            AtomicInteger count = ERRORS.get(SyncErrorManager.key(ds, type, id));
            return count != null ? count.get() : 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ItemType {
        ITEM_ID,
        REMOTE_ID,
        REMOTE_PATH;

    }
}

