/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.datasource.DataSourceManager;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RssImport
implements DataSource.DataImport {
    private DataSource mDataSource;

    public RssImport(DataSource ds) {
        this.mDataSource = ds;
    }

    @Override
    public void importData(List<Integer> folderIds, boolean fullSync) throws ServiceException {
        Mailbox mbox = DataSourceManager.getInstance().getMailbox(this.mDataSource);
        int folderId = this.mDataSource.getFolderId();
        try {
            mbox.getFolderById(null, folderId);
            mbox.synchronizeFolder(null, folderId);
        }
        catch (MailServiceException.NoSuchItemException e) {
            ZimbraLog.datasource.info("Folder %d was deleted.  Deleting data source %s.", folderId, this.mDataSource.getName());
            mbox.getAccount().deleteDataSource(this.mDataSource.getId());
        }
    }

    @Override
    public void test() throws ServiceException {
        int folderId;
        Mailbox mbox = DataSourceManager.getInstance().getMailbox(this.mDataSource);
        Folder folder = mbox.getFolderById(null, folderId = this.mDataSource.getFolderId());
        String urlString = folder.getUrl();
        if (StringUtil.isNullOrEmpty(urlString)) {
            throw ServiceException.FAILURE("URL not specified for folder " + folder.getPath(), null);
        }
        InputStream in = null;
        try {
            try {
                URL url = new URL(urlString);
                URLConnection conn = url.openConnection();
                in = conn.getInputStream();
                in.read();
            }
            catch (Exception e) {
                throw ServiceException.FAILURE("Data source test failed.", e);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            ByteUtil.closeStream(in);
            throw throwable;
        }
        ByteUtil.closeStream(in);
    }
}

