/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.common.util.Log;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailclient.CommandFailedException;
import com.zimbra.cs.mailclient.MailException;
import com.zimbra.cs.mailclient.imap.AppendResult;
import com.zimbra.cs.mailclient.imap.CAtom;
import com.zimbra.cs.mailclient.imap.CopyResult;
import com.zimbra.cs.mailclient.imap.FetchResponseHandler;
import com.zimbra.cs.mailclient.imap.Flags;
import com.zimbra.cs.mailclient.imap.ImapConfig;
import com.zimbra.cs.mailclient.imap.ImapConnection;
import com.zimbra.cs.mailclient.imap.ImapData;
import com.zimbra.cs.mailclient.imap.ImapRequest;
import com.zimbra.cs.mailclient.imap.Literal;
import com.zimbra.cs.mailclient.imap.Mailbox;
import com.zimbra.cs.mailclient.imap.MailboxName;
import com.zimbra.cs.mailclient.imap.MessageData;
import com.zimbra.cs.mailclient.imap.ResponseText;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteFolder {
    private final ImapConnection connection;
    private final String path;
    private int deleted;
    private static final Log LOG = ZimbraLog.datasource;

    RemoteFolder(ImapConnection connection, String path) {
        this.connection = connection;
        this.path = path;
    }

    public void create() throws IOException {
        block2: {
            this.info("creating folder", new Object[0]);
            try {
                this.connection.create(this.path);
            }
            catch (CommandFailedException e) {
                if (this.exists()) break block2;
                throw e;
            }
        }
    }

    public void delete() throws IOException {
        block2: {
            this.info("deleting folder", new Object[0]);
            try {
                this.connection.delete(this.path);
            }
            catch (CommandFailedException e) {
                if (!this.exists()) break block2;
                throw e;
            }
        }
    }

    public RemoteFolder renameTo(String newName) throws IOException {
        this.info("renaming folder to '%s'", newName);
        this.connection.rename(this.path, newName);
        return new RemoteFolder(this.connection, newName);
    }

    public long appendMessage(MimeMessage msg, Flags flags, Date date) throws IOException {
        long l;
        File tmp;
        block6: {
            this.ensureSelected();
            ImapConfig config = this.connection.getImapConfig();
            tmp = null;
            OutputStream os = null;
            try {
                tmp = File.createTempFile("lit", null, config.getLiteralDataDir());
                os = new FileOutputStream(tmp);
                msg.writeTo(os);
                os.close();
                AppendResult res = this.connection.append(this.path, flags, date, new Literal(tmp));
                l = res != null ? res.getUid() : -1L;
                Object var11_10 = null;
                if (os == null) break block6;
            }
            catch (MessagingException e) {
                try {
                    throw new MailException("Error appending message", e);
                }
                catch (Throwable throwable) {
                    block7: {
                        Object var11_11 = null;
                        if (os != null) {
                            os.close();
                        }
                        if (tmp == null) break block7;
                        tmp.delete();
                    }
                    throw throwable;
                }
            }
            os.close();
        }
        if (tmp != null) {
            tmp.delete();
        }
        return l;
    }

    public CopyResult copyMessage(long uid, String mbox) throws IOException {
        CopyResult cr;
        this.ensureSelected();
        String seq = String.valueOf(uid);
        ImapRequest req = this.connection.newUidRequest(CAtom.COPY, seq, new MailboxName(mbox));
        ResponseText rt = req.sendCheckStatus().getResponseText();
        if (rt.getCCode() == CAtom.COPYUID && (cr = (CopyResult)rt.getData()) != null && cr.getToUids()[0] != 0L) {
            return cr;
        }
        return null;
    }

    public void deleteMessages(List<Long> uids) throws IOException {
        this.ensureSelected();
        int size = uids.size();
        this.debug("deleting %d messages(s) from folder", size);
        for (int i = 0; i < size; i += 16) {
            String seq = ImapData.asSequenceSet(uids.subList(i, i + Math.min(size - i, 16)));
            this.connection.uidStore(seq, "+FLAGS.SILENT", "(\\Deleted)");
            if (!this.connection.hasUidPlus()) continue;
            this.connection.uidExpunge(seq);
        }
        this.deleted += size;
    }

    public void deleteMessage(long uid) throws IOException {
        this.ensureSelected();
        this.debug("deleting message with uid %d", uid);
        String seq = String.valueOf(uid);
        this.connection.uidStore(seq, "+FLAGS.SILENT", "(\\Deleted)");
        if (this.connection.hasUidPlus()) {
            this.connection.uidExpunge(seq);
        }
        ++this.deleted;
    }

    public void close() throws IOException {
        if (this.deleted > 0 && !this.connection.hasUidPlus()) {
            this.connection.mclose();
        }
    }

    public List<Long> getUids(long startUid, long endUid) throws IOException {
        this.ensureSelected();
        String end = endUid > 0L ? String.valueOf(endUid) : "*";
        List<Long> uids = this.connection.getUids(startUid + ":" + end);
        if (endUid <= 0L && uids.size() == 1 && uids.get(0) < startUid) {
            return Collections.emptyList();
        }
        Collections.sort(uids, Collections.reverseOrder());
        return uids;
    }

    public List<MessageData> getFlags(long startUid, long endUid) throws IOException {
        final ArrayList<MessageData> mds = new ArrayList<MessageData>();
        String end = endUid > 0L ? String.valueOf(endUid) : "*";
        this.connection.uidFetch(startUid + ":" + end, "FLAGS", new FetchResponseHandler(){

            public void handleFetchResponse(MessageData md) {
                Flags flags = md.getFlags();
                if (flags != null && !flags.isDeleted()) {
                    mds.add(md);
                }
            }
        });
        if (endUid <= 0L && mds.size() == 1 && ((MessageData)mds.get(0)).getUid() < startUid) {
            return Collections.emptyList();
        }
        return mds;
    }

    public boolean exists() throws IOException {
        return !this.connection.list("", this.path).isEmpty();
    }

    public void ensureSelected() throws IOException {
        if (!this.isSelected()) {
            this.select();
        }
    }

    public Mailbox select() throws IOException {
        return this.connection.select(this.path);
    }

    public boolean isSelected() {
        Mailbox mb = this.connection.getMailbox();
        return mb != null && mb.getName().equals(this.path);
    }

    public String getPath() {
        return this.path;
    }

    public void debug(String fmt, Object ... args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.errmsg(String.format(fmt, args)));
        }
    }

    public void info(String fmt, Object ... args) {
        LOG.info(this.errmsg(String.format(fmt, args)));
    }

    public void warn(String msg, Throwable e) {
        LOG.error((Object)this.errmsg(msg), e);
    }

    public void error(String msg, Throwable e) {
        LOG.error((Object)this.errmsg(msg), e);
    }

    private String errmsg(String s) {
        return String.format("Remote folder '%s': %s", this.getPath(), s);
    }
}

