/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.datasource.DataSourceManager;
import com.zimbra.cs.datasource.DataSourceMapping;
import com.zimbra.cs.db.DbDataSource;
import com.zimbra.cs.db.DbPop3Message;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PopMessage
extends DataSourceMapping {
    public PopMessage(DataSource ds, DbDataSource.DataSourceItem dsi) throws ServiceException {
        super(ds, dsi);
    }

    public PopMessage(DataSource ds, int itemId) throws ServiceException {
        super(ds, itemId);
    }

    public PopMessage(DataSource ds, String uid) throws ServiceException {
        super(ds, uid);
    }

    public PopMessage(DataSource ds, int itemId, String uid) throws ServiceException {
        super(ds, ds.getFolderId(), itemId, uid);
    }

    public static Set<PopMessage> getMappings(DataSource ds, String[] remoteIds) throws ServiceException {
        Collection<DbDataSource.DataSourceItem> mappings = DbDataSource.getReverseMappings(ds, Arrays.asList(remoteIds));
        HashSet<PopMessage> matchingMsgs = new HashSet<PopMessage>();
        if (mappings.isEmpty()) {
            Map<Integer, String> oldMappings = DbPop3Message.getMappings(DataSourceManager.getInstance().getMailbox(ds), ds.getId());
            for (Integer itemId : oldMappings.keySet()) {
                String uid = oldMappings.get(itemId);
                PopMessage mapping = new PopMessage(ds, itemId, uid);
                mapping.add();
                for (String remoteId : remoteIds) {
                    if (!remoteId.equals(uid)) continue;
                    matchingMsgs.add(mapping);
                }
            }
            if (!oldMappings.isEmpty()) {
                DbPop3Message.deleteUids(DataSourceManager.getInstance().getMailbox(ds), ds.getName());
            }
        } else {
            for (DbDataSource.DataSourceItem mapping : mappings) {
                matchingMsgs.add(new PopMessage(ds, mapping));
            }
        }
        return matchingMsgs;
    }

    public static Set<String> getMatchingUids(DataSource ds, String[] remoteIds) throws ServiceException {
        Set<PopMessage> matchingMsgs = PopMessage.getMappings(ds, remoteIds);
        HashSet<String> matchingUids = new HashSet<String>(matchingMsgs.size());
        for (PopMessage msg : matchingMsgs) {
            matchingUids.add(msg.getRemoteId());
        }
        return matchingUids;
    }
}

