/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.RemoteServiceException;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.SSLSocketFactoryManager;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.datasource.LogOutputStream;
import com.zimbra.cs.datasource.MailItemImport;
import com.zimbra.cs.datasource.MessageContent;
import com.zimbra.cs.datasource.PopMessage;
import com.zimbra.cs.filter.RuleManager;
import com.zimbra.cs.mailbox.DeliveryContext;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailclient.CommandFailedException;
import com.zimbra.cs.mailclient.pop3.ContentInputStream;
import com.zimbra.cs.mailclient.pop3.Pop3Config;
import com.zimbra.cs.mailclient.pop3.Pop3Connection;
import com.zimbra.cs.mime.ParsedMessage;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.login.LoginException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pop3Sync
extends MailItemImport {
    private final Pop3Connection connection;
    private final boolean indexAttachments;
    private static final Log LOG = ZimbraLog.datasource;
    private static final Pattern PATTERN_ZIMBRA_UID = Pattern.compile("(\\d+)\\.([^\\.]+)");

    public Pop3Sync(DataSource ds) throws ServiceException {
        super(ds);
        this.connection = new Pop3Connection(this.getPop3Config(ds));
        this.indexAttachments = this.mbox.attachmentsIndexingEnabled();
    }

    private Pop3Config getPop3Config(DataSource ds) {
        Pop3Config config = new Pop3Config();
        config.setHost(ds.getHost());
        config.setPort(ds.getPort());
        config.setAuthenticationId(ds.getUsername());
        config.setSecurity(Pop3Sync.getSecurity(ds.getConnectionType()));
        if (ds.isDebugTraceEnabled()) {
            config.setDebug(true);
            this.enableTrace(config);
        }
        config.setSSLSocketFactory(SSLSocketFactoryManager.getDefaultSSLSocketFactory());
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void test() throws ServiceException {
        this.validateDataSource();
        this.setTimeout(LC.javamail_pop3_test_timeout.intValue());
        this.enableTrace(this.connection.getPop3Config());
        try {
            this.connect();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.connection.close();
            throw throwable;
        }
        this.connection.close();
    }

    private void setTimeout(int timeout) {
        Pop3Config config = this.connection.getPop3Config();
        config.setReadTimeout(timeout);
        config.setConnectTimeout(timeout);
    }

    private void enableTrace(Pop3Config config) {
        config.setTrace(true);
        if (this.dataSource.isOffline()) {
            config.setTraceStream(new PrintStream(new LogOutputStream(ZimbraLog.pop), true));
        } else {
            config.setTraceStream(System.out);
        }
    }

    @Override
    public synchronized void importData(List<Integer> folderIds, boolean fullSync) throws ServiceException {
        this.validateDataSource();
        this.setTimeout(LC.javamail_pop3_timeout.intValue());
        this.connect();
        try {
            try {
                if (this.dataSource.leaveOnServer()) {
                    this.fetchAndRetainMessages();
                } else {
                    this.fetchAndDeleteMessages();
                }
                this.connection.quit();
            }
            catch (ServiceException e) {
                throw e;
            }
            catch (Exception e) {
                throw ServiceException.FAILURE("Synchronization of POP3 folder failed", e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.connection.close();
            throw throwable;
        }
        this.connection.close();
    }

    private void connect() throws ServiceException {
        if (!this.connection.isClosed()) {
            return;
        }
        try {
            this.connection.connect();
            try {
                this.connection.login(this.dataSource.getDecryptedPassword());
            }
            catch (CommandFailedException e) {
                throw new LoginException(e.getError());
            }
        }
        catch (Exception e) {
            this.connection.close();
            throw ServiceException.FAILURE("Unable to connect to POP3 server: " + this.dataSource, e);
        }
        if (this.dataSource.leaveOnServer()) {
            this.checkHasUIDL();
        }
    }

    private void checkHasUIDL() throws ServiceException {
        if (!this.connection.hasCapability("UIDL")) {
            throw RemoteServiceException.POP3_UIDL_REQUIRED();
        }
    }

    private void fetchAndDeleteMessages() throws ServiceException, IOException {
        Integer[] sizes = this.connection.getMessageSizes();
        LOG.info("Found %d new message(s) on remote server", sizes.length);
        for (int msgno = sizes.length; msgno > 0; --msgno) {
            LOG.debug("Fetching message number %d", msgno);
            this.fetchAndAddMessage(msgno, sizes[msgno - 1], null, true);
            this.connection.deleteMessage(msgno);
        }
    }

    private void fetchAndRetainMessages() throws ServiceException, IOException {
        String[] uids = this.connection.getMessageUids();
        Set<String> existingUids = PopMessage.getMatchingUids(this.dataSource, uids);
        int count = uids.length - existingUids.size();
        LOG.info("Found %d new message(s) on remote server", count);
        if (count == 0) {
            return;
        }
        if (this.poppingSelf(uids[0])) {
            throw ServiceException.INVALID_REQUEST("User attempted to import messages from his own mailbox", null);
        }
        for (int msgno = uids.length; msgno > 0; --msgno) {
            String uid = uids[msgno - 1];
            if (existingUids.contains(uid)) continue;
            LOG.debug("Fetching message with uid %s", uid);
            this.fetchAndAddMessage(msgno, this.connection.getMessageSize(msgno), uid, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fetchAndAddMessage(int msgno, int size, String uid, boolean allowFilterToMountpoint) throws ServiceException, IOException {
        MessageContent mc;
        block11: {
            ContentInputStream cis = null;
            mc = null;
            try {
                try {
                    cis = this.connection.getMessage(msgno);
                    mc = MessageContent.read(cis, size);
                    ParsedMessage pm = mc.getParsedMessage(null, this.indexAttachments);
                    Message msg = null;
                    DeliveryContext dc = mc.getDeliveryContext();
                    if (this.isOffline()) {
                        msg = this.addMessage(null, pm, this.dataSource.getFolderId(), Flag.BITMASK_UNREAD, dc);
                    } else {
                        Integer localId = this.getFirstLocalId(RuleManager.applyRulesToIncomingMessage(this.mbox, pm, this.dataSource.getEmailAddress(), dc, this.dataSource.getFolderId(), allowFilterToMountpoint));
                        if (localId != null) {
                            msg = this.mbox.getMessageById(null, localId);
                        }
                    }
                    if (msg != null && uid != null) {
                        PopMessage msgTracker = new PopMessage(this.dataSource, msg.getId(), uid);
                        msgTracker.add();
                    }
                }
                catch (CommandFailedException e) {
                    LOG.warn("Error fetching message number %d: %s", msgno, e.getMessage());
                    Object var12_13 = null;
                    if (cis != null) {
                        cis.close();
                    }
                    if (mc == null) return;
                    mc.cleanup();
                    return;
                }
                Object var12_12 = null;
                if (cis == null) break block11;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (cis != null) {
                    cis.close();
                }
                if (mc == null) throw throwable;
                mc.cleanup();
                throw throwable;
            }
            cis.close();
        }
        if (mc == null) return;
        mc.cleanup();
    }

    private boolean poppingSelf(String uid) throws ServiceException {
        Message msg;
        int itemId;
        Matcher matcher = PATTERN_ZIMBRA_UID.matcher(uid);
        if (!matcher.matches()) {
            return false;
        }
        try {
            itemId = Integer.parseInt(matcher.group(1));
        }
        catch (NumberFormatException e) {
            return false;
        }
        String digest = matcher.group(2);
        try {
            msg = this.mbox.getMessageById(null, itemId);
        }
        catch (MailServiceException.NoSuchItemException e) {
            return false;
        }
        return digest.equals(msg.getDigest());
    }
}

