/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.BufferStream;
import com.zimbra.cs.mailbox.DeliveryContext;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.store.Blob;
import com.zimbra.cs.store.StorageCallback;
import com.zimbra.cs.store.StoreManager;
import java.io.IOException;
import java.io.InputStream;

public class MessageContent {
    private Blob blob;
    private byte[] data;

    public static MessageContent read(InputStream is, int size) throws IOException, ServiceException {
        MessageContent mb = new MessageContent();
        mb.readContent(is, size);
        return mb;
    }

    private MessageContent() {
    }

    private void readContent(InputStream is, int sizeHint) throws IOException, ServiceException {
        if (sizeHint < StorageCallback.getDiskStreamingThreshold()) {
            BufferStream bs = new BufferStream(sizeHint);
            if (bs.readFrom(is) != (long)sizeHint) {
                // empty if block
            }
            this.data = bs.toByteArray();
            bs.close();
        } else {
            this.blob = StoreManager.getInstance().storeIncoming(is, sizeHint, null);
        }
    }

    public ParsedMessage getParsedMessage(Long receivedDate, boolean indexAttachments) throws IOException, ServiceException {
        if (this.data != null) {
            return new ParsedMessage(this.data, receivedDate, indexAttachments);
        }
        return new ParsedMessage(this.blob.getFile(), receivedDate, indexAttachments);
    }

    public DeliveryContext getDeliveryContext() {
        DeliveryContext dc = new DeliveryContext();
        if (this.blob != null) {
            dc.setIncomingBlob(this.blob);
        }
        return dc;
    }

    public void cleanup() throws IOException {
        if (this.blob != null) {
            StoreManager.getInstance().delete(this.blob);
            this.blob = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.cleanup();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }
}

