/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.datasource.DataSourceManager;
import com.zimbra.cs.filter.RuleManager;
import com.zimbra.cs.mailbox.DeliveryContext;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailclient.MailConfig;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.service.util.ItemId;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MailItemImport
implements DataSource.DataImport {
    protected final DataSource dataSource;
    protected final Mailbox mbox;

    protected MailItemImport(DataSource ds) throws ServiceException {
        this.dataSource = ds;
        this.mbox = DataSourceManager.getInstance().getMailbox(ds);
    }

    protected void validateDataSource() throws ServiceException {
        DataSource ds = this.getDataSource();
        if (ds.getHost() == null) {
            throw ServiceException.FAILURE(ds + ": host not set", null);
        }
        if (ds.getPort() == null) {
            throw ServiceException.FAILURE(ds + ": port not set", null);
        }
        if (ds.getConnectionType() == null) {
            throw ServiceException.FAILURE(ds + ": connectionType not set", null);
        }
        if (ds.getUsername() == null) {
            throw ServiceException.FAILURE(ds + ": username not set", null);
        }
    }

    protected boolean isOffline() {
        return this.getDataSource().isOffline();
    }

    protected Message addMessage(OperationContext octxt, ParsedMessage pm, int folderId, int flags) throws ServiceException, IOException {
        return this.addMessage(octxt, pm, folderId, flags, new DeliveryContext());
    }

    protected Message addMessage(OperationContext octxt, ParsedMessage pm, int folderId, int flags, DeliveryContext dc) throws ServiceException, IOException {
        Message msg = null;
        switch (folderId) {
            case 2: {
                try {
                    List<ItemId> addedMessageIds = RuleManager.applyRulesToIncomingMessage(this.mbox, pm, this.dataSource.getEmailAddress(), dc, 2);
                    Integer newMessageId = this.getFirstLocalId(addedMessageIds);
                    if (newMessageId == null) {
                        return null;
                    }
                    msg = this.mbox.getMessageById(null, newMessageId);
                    if (flags == Flag.BITMASK_UNREAD) break;
                    this.mbox.setTags(octxt, newMessageId, (byte)5, flags &= ~Flag.BITMASK_DRAFT, 0x80000000L);
                }
                catch (Exception e) {
                    ZimbraLog.datasource.warn((Object)"Error applying filter rules", e);
                }
                break;
            }
            case 5: 
            case 6: {
                flags |= Flag.BITMASK_FROM_ME;
            }
        }
        if (msg == null) {
            msg = this.mbox.addMessage(octxt, pm, folderId, false, flags, null);
        }
        return msg;
    }

    protected static MailConfig.Security getSecurity(DataSource.ConnectionType type) {
        if (type != null) {
            switch (type) {
                case cleartext: {
                    return MailConfig.Security.NONE;
                }
                case ssl: {
                    return MailConfig.Security.SSL;
                }
                case tls: {
                    return MailConfig.Security.TLS;
                }
                case tls_if_available: {
                    return MailConfig.Security.TLS_IF_AVAILABLE;
                }
            }
        }
        return MailConfig.Security.NONE;
    }

    public boolean isSslEnabled() {
        return this.dataSource.getConnectionType() == DataSource.ConnectionType.ssl;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Mailbox getMailbox() {
        return this.mbox;
    }

    protected Integer getFirstLocalId(List<ItemId> idList) {
        if (idList == null) {
            return null;
        }
        for (ItemId id : idList) {
            if (!id.belongsTo(this.mbox)) continue;
            return id.getId();
        }
        return null;
    }
}

