/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.common.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LogOutputStream
extends OutputStream {
    private final Log log;
    private final ByteArrayOutputStream baos;
    private boolean closed;

    public LogOutputStream(Log log) {
        this.log = log;
        this.baos = new ByteArrayOutputStream(256);
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        if (b == 10) {
            this.flushLine();
        } else {
            this.baos.write(b);
        }
    }

    public void close() {
        if (!this.closed) {
            if (this.baos.size() > 0) {
                this.flushLine();
            }
            this.closed = true;
        }
    }

    private void flushLine() {
        String line = this.baos.toString();
        if (line.endsWith("\r")) {
            line = line.substring(0, line.length() - 1);
        }
        this.log.debug(line);
        this.baos.reset();
    }
}

