/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailclient.imap.Flags;
import com.zimbra.cs.mailclient.imap.ListData;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocalFolder {
    private final Mailbox mbox;
    private final String path;
    private Folder folder;
    private static final Log LOG = ZimbraLog.datasource;

    public static LocalFolder fromId(Mailbox mbox, int id) throws ServiceException {
        try {
            return new LocalFolder(mbox, mbox.getFolderById(null, id));
        }
        catch (MailServiceException.NoSuchItemException e) {
            return null;
        }
    }

    LocalFolder(Mailbox mbox, String path) throws ServiceException {
        this.mbox = mbox;
        this.path = path;
    }

    LocalFolder(Mailbox mbox, Folder folder) throws ServiceException {
        this.mbox = mbox;
        this.path = folder.getPath();
        this.folder = folder;
    }

    public void delete() throws ServiceException {
        this.debug("deleting folder", new Object[0]);
        try {
            this.getFolder();
        }
        catch (MailServiceException.NoSuchItemException e) {
            return;
        }
        this.mbox.delete(null, this.folder.getId(), this.folder.getType());
    }

    public void create() throws ServiceException {
        this.debug("creating folder", new Object[0]);
        this.folder = this.mbox.createFolder(null, this.path, (byte)0, (byte)5);
    }

    public void checkFlags(ListData ld) throws ServiceException {
        boolean sync;
        this.getFolder();
        if (this.folder.getId() < 256) {
            return;
        }
        Flags flags = ld.getFlags();
        boolean noinferiors = flags.isNoinferiors() || ld.getDelimiter() == '\u0000';
        int bits = this.folder.getFlagBitmask();
        if ((bits & Flag.BITMASK_NO_INFERIORS) != 0 != noinferiors) {
            this.debug("Setting NO_INFERIORS flag to " + noinferiors, new Object[0]);
            this.alterTag(-27, noinferiors);
        }
        if ((bits & Flag.BITMASK_SYNCFOLDER) != 0 != (sync = !flags.isNoselect())) {
            this.debug("Setting sync flag to " + sync, new Object[0]);
            this.alterTag(-25, sync);
            this.alterTag(-26, sync);
        }
        if (this.folder.getDefaultView() != 5) {
            this.debug("Setting default view to TYPE_MESSAGE", new Object[0]);
            this.mbox.setFolderDefaultView(null, this.folder.getId(), (byte)5);
        }
    }

    public void alterTag(int flagId, boolean value) throws ServiceException {
        this.mbox.alterTag(null, this.getFolder().getId(), (byte)1, flagId, value);
    }

    public void setMessageFlags(int id, int flagMask) throws ServiceException {
        this.mbox.setTags(null, id, (byte)5, flagMask, 0x80000000L);
    }

    public boolean exists() throws ServiceException {
        try {
            this.getFolder();
        }
        catch (MailServiceException.NoSuchItemException e) {
            return false;
        }
        return true;
    }

    public Message getMessage(int id) throws ServiceException {
        try {
            Message msg = this.mbox.getMessageById(null, id);
            if (msg.getFolderId() == this.getFolder().getId()) {
                return msg;
            }
        }
        catch (MailServiceException.NoSuchItemException noSuchItemException) {
            // empty catch block
        }
        return null;
    }

    public void deleteMessage(int id) throws ServiceException {
        this.debug("deleting message with id %d", id);
        try {
            this.mbox.delete(null, id, (byte)-1);
        }
        catch (MailServiceException.NoSuchItemException e) {
            this.debug("message with id %d not found", id);
        }
    }

    public void emptyFolder() throws ServiceException {
        this.mbox.emptyFolder(null, this.getId(), false);
    }

    public Set<Integer> getMessageIds() throws ServiceException {
        return new HashSet<Integer>(this.mbox.listItemIds(null, (byte)5, this.folder.getId()));
    }

    public Folder getFolder() throws ServiceException {
        if (this.folder == null) {
            this.folder = this.mbox.getFolderByPath(null, this.path);
        }
        return this.folder;
    }

    public int getId() throws ServiceException {
        return this.getFolder().getId();
    }

    public String getPath() {
        return this.folder != null ? this.folder.getPath() : this.path;
    }

    public void debug(String fmt, Object ... args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.errmsg(String.format(fmt, args)));
        }
    }

    public void info(String fmt, Object ... args) {
        LOG.info(this.errmsg(String.format(fmt, args)));
    }

    public void warn(String msg, Throwable e) {
        LOG.error((Object)this.errmsg(msg), e);
    }

    public void error(String msg, Throwable e) {
        LOG.error((Object)this.errmsg(msg), e);
    }

    private String errmsg(String s) {
        return String.format("Local folder '%s': %s", this.getPath(), s);
    }
}

