/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.cs.mailclient.imap.ImapConnection;
import com.zimbra.cs.mailclient.imap.ListData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImapUtil {
    private static final String INBOX = "INBOX";
    private static final int INBOX_LEN = "INBOX".length();
    private static final Comparator<ListData> COMPARATOR = new Comparator<ListData>(){

        @Override
        public int compare(ListData ld1, ListData ld2) {
            return ld2.getMailbox().compareToIgnoreCase(ld1.getMailbox());
        }
    };

    public static List<ListData> listFolders(ImapConnection ic, String name) throws IOException {
        return ImapUtil.sortFolders(ic.list("", name));
    }

    public static List<ListData> sortFolders(List<ListData> folders) {
        ListData inbox = null;
        ArrayList<ListData> inboxInferiors = new ArrayList<ListData>();
        ArrayList<ListData> otherFolders = new ArrayList<ListData>();
        for (ListData ld : folders) {
            String name = ld.getMailbox();
            if (name.equalsIgnoreCase(INBOX)) {
                if (inbox != null) continue;
                inbox = ld;
                continue;
            }
            if (ImapUtil.isInboxInferior(ld)) {
                inboxInferiors.add(ld);
                continue;
            }
            otherFolders.add(ld);
        }
        ArrayList<ListData> sorted = new ArrayList<ListData>(folders.size());
        if (inbox == null) {
            inbox = ImapUtil.getDefaultInbox(sorted);
        }
        if (inbox != null) {
            sorted.add(inbox);
        }
        Collections.sort(inboxInferiors, COMPARATOR);
        sorted.addAll(inboxInferiors);
        Collections.sort(otherFolders, COMPARATOR);
        sorted.addAll(otherFolders);
        ImapUtil.removeDuplicates(sorted);
        return sorted;
    }

    private static void removeDuplicates(List<ListData> sorted) {
        Iterator<ListData> it = sorted.iterator();
        if (it.hasNext()) {
            ListData ld = it.next();
            while (it.hasNext()) {
                ListData next = it.next();
                if (ld.getMailbox().equalsIgnoreCase(next.getMailbox())) {
                    it.remove();
                    continue;
                }
                ld = next;
            }
        }
    }

    private static ListData getDefaultInbox(List<ListData> sorted) {
        for (ListData ld : sorted) {
            if (!ImapUtil.isInboxInferior(ld)) continue;
            return new ListData(INBOX, ld.getDelimiter());
        }
        return null;
    }

    private static boolean isInboxInferior(ListData ld) {
        String name = ld.getMailbox();
        return name.length() > INBOX_LEN && name.substring(0, INBOX_LEN).equalsIgnoreCase(INBOX) && name.charAt(INBOX_LEN) == ld.getDelimiter();
    }

    public static boolean isYahoo(ImapConnection ic) {
        return ic.hasCapability("AUTH=XYMCOOKIEB64");
    }
}

