/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.common.datasource.SyncState;
import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.RemoteServiceException;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.SSLSocketFactoryManager;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.datasource.ImapFolder;
import com.zimbra.cs.datasource.ImapFolderCollection;
import com.zimbra.cs.datasource.ImapFolderSync;
import com.zimbra.cs.datasource.ImapUtil;
import com.zimbra.cs.datasource.LocalFolder;
import com.zimbra.cs.datasource.LogOutputStream;
import com.zimbra.cs.datasource.MailItemImport;
import com.zimbra.cs.datasource.MessageContent;
import com.zimbra.cs.datasource.SyncUtil;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailclient.CommandFailedException;
import com.zimbra.cs.mailclient.auth.Authenticator;
import com.zimbra.cs.mailclient.imap.DataHandler;
import com.zimbra.cs.mailclient.imap.IDInfo;
import com.zimbra.cs.mailclient.imap.ImapConfig;
import com.zimbra.cs.mailclient.imap.ImapConnection;
import com.zimbra.cs.mailclient.imap.ImapData;
import com.zimbra.cs.mailclient.imap.ListData;
import com.zimbra.cs.util.Zimbra;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.security.auth.login.LoginException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapSync
extends MailItemImport {
    private final ImapConnection connection;
    private Folder localRootFolder;
    private char delimiter;
    private ImapFolderCollection trackedFolders;
    private Map<Integer, ImapFolderSync> syncedFolders;
    private Authenticator authenticator;
    private Pattern ILLEGAL_FOLDER_CHARS = Pattern.compile("[\\:\\*\\?\\\"\\<\\>\\|]");
    private static final Log LOG = ZimbraLog.datasource;

    public ImapSync(DataSource ds) throws ServiceException {
        super(ds);
        this.connection = new ImapConnection(ImapSync.getImapConfig(ds));
    }

    public ImapConnection getConnection() {
        return this.connection;
    }

    public void setAuthenticator(Authenticator auth) {
        this.authenticator = auth;
    }

    public ImapFolderCollection getTrackedFolders() {
        return this.trackedFolders;
    }

    public ImapFolder createFolderTracker(int itemId, String localPath, String remotePath, long uidValidity) throws ServiceException {
        ImapFolder tracker = new ImapFolder(this.dataSource, itemId, remotePath, localPath, uidValidity);
        tracker.add();
        this.trackedFolders.add(tracker);
        return tracker;
    }

    public void deleteFolderTracker(ImapFolder tracker) throws ServiceException {
        tracker.delete();
        this.trackedFolders.remove(tracker);
    }

    public ImapFolderSync getSyncedFolder(int folderId) {
        return this.syncedFolders.get(folderId);
    }

    public static ImapConfig getImapConfig(DataSource ds) {
        ImapConfig config = new ImapConfig();
        config.setHost(ds.getHost());
        config.setPort(ds.getPort());
        config.setAuthenticationId(ds.getUsername());
        config.setSecurity(ImapSync.getSecurity(ds.getConnectionType()));
        config.setUseLiteralPlus(false);
        if (ds.isDebugTraceEnabled()) {
            config.setDebug(true);
            ImapSync.enableTrace(config, ds);
        }
        config.setSSLSocketFactory(SSLSocketFactoryManager.getDefaultSSLSocketFactory());
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void test() throws ServiceException {
        this.validateDataSource();
        this.setTimeout(LC.javamail_imap_test_timeout.intValue());
        ImapSync.enableTrace(this.connection.getImapConfig(), this.dataSource);
        try {
            this.connect();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.connection.close();
            throw throwable;
        }
        this.connection.close();
    }

    private void setTimeout(int timeout) {
        ImapConfig config = this.connection.getImapConfig();
        config.setReadTimeout(timeout);
        config.setConnectTimeout(timeout);
    }

    private static void enableTrace(ImapConfig config, DataSource ds) {
        config.setTrace(true);
        config.setMaxLiteralTraceSize(ds.getIntAttr("zimbraDataSourceMaxTraceSize", 64));
        if (ds.isOffline()) {
            config.setTraceStream(new PrintStream(new LogOutputStream(ZimbraLog.imap), true));
        } else {
            config.setTraceStream(System.out);
        }
    }

    @Override
    public synchronized void importData(List<Integer> folderIds, boolean fullSync) throws ServiceException {
        this.validateDataSource();
        this.setTimeout(LC.javamail_imap_timeout.intValue());
        this.connect();
        int folderId = this.dataSource.getFolderId();
        this.localRootFolder = this.getMailbox().getFolderById(null, folderId);
        this.connection.setDataHandler(new FetchDataHandler());
        try {
            try {
                this.syncFolders(folderIds, fullSync);
                this.connection.logout();
            }
            catch (IOException e) {
                throw ServiceException.FAILURE("Folder sync failed", e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.connection.close();
            throw throwable;
        }
        this.connection.close();
    }

    protected void connect() throws ServiceException {
        if (!this.connection.isClosed()) {
            return;
        }
        try {
            this.connection.connect();
            try {
                if (this.authenticator != null) {
                    this.connection.authenticate(this.authenticator);
                } else {
                    this.connection.login(this.dataSource.getDecryptedPassword());
                }
            }
            catch (CommandFailedException e) {
                throw new LoginException(e.getError());
            }
            this.checkImportingSelf();
            this.delimiter = this.connection.getDelimiter();
        }
        catch (ServiceException e) {
            this.connection.close();
            throw e;
        }
        catch (Exception e) {
            this.connection.close();
            throw ServiceException.FAILURE("Unable to connect to IMAP server: " + this.dataSource, e);
        }
    }

    private void checkImportingSelf() throws IOException, ServiceException {
        if (this.dataSource.isOffline()) {
            return;
        }
        try {
            String user;
            IDInfo id = this.connection.id();
            if ("Zimbra".equalsIgnoreCase(id.getName()) && (user = (String)id.get("user")) != null && user.equals(this.dataSource.getAccount().getName())) {
                throw ServiceException.INVALID_REQUEST("User attempted to import messages from his/her own mailbox", null);
            }
        }
        catch (CommandFailedException commandFailedException) {
            // empty catch block
        }
    }

    public void checkIsEnabled() throws ServiceException {
        if (!this.getDataSource().isManaged()) {
            throw ServiceException.FAILURE("Import aborted because data source has been deleted or disabled", null);
        }
    }

    private void syncFolders(List<Integer> folderIds, boolean fullSync) throws ServiceException, IOException {
        if (this.dataSource.isOffline()) {
            this.getMailbox().beginTrackingSync();
        }
        if (this.dataSource.isOffline() && fullSync) {
            SyncUtil.setSyncEnabled(this.mbox, 2, true);
        }
        this.trackedFolders = ImapFolder.getFolders(this.dataSource);
        this.syncedFolders = new LinkedHashMap<Integer, ImapFolderSync>();
        this.syncRemoteFolders(ImapUtil.listFolders(this.connection, "*"));
        this.syncLocalFolders(this.getLocalFolders());
        this.syncMessages(folderIds, fullSync);
        this.finishSync();
    }

    private List<Folder> getLocalFolders() {
        List<Folder> folders = this.localRootFolder.getSubfolderHierarchy();
        ArrayList<Folder> mailFolders = new ArrayList<Folder>(folders.size());
        for (Folder f : folders) {
            if (f.getDefaultView() != 5) continue;
            mailFolders.add(f);
        }
        Collections.reverse(mailFolders);
        return mailFolders;
    }

    private void syncRemoteFolders(List<ListData> folders) throws ServiceException {
        for (ListData ld : folders) {
            this.checkIsEnabled();
            try {
                ImapFolderSync ifs = new ImapFolderSync(this);
                ImapFolder tracker = ifs.syncFolder(ld);
                if (tracker == null) continue;
                this.syncedFolders.put(tracker.getItemId(), ifs);
            }
            catch (Exception e) {
                this.syncFailed(ld.getMailbox(), e);
            }
        }
    }

    private void syncLocalFolders(List<Folder> folders) throws ServiceException {
        for (Folder folder : folders) {
            this.checkIsEnabled();
            int id = folder.getId();
            if (id == this.localRootFolder.getId() || this.syncedFolders.containsKey(id)) continue;
            try {
                ImapFolderSync ifs;
                ImapFolder tracker;
                folder = this.getFolder(id);
                if (folder == null || (tracker = (ifs = new ImapFolderSync(this)).syncFolder(folder)) == null) continue;
                this.syncedFolders.put(tracker.getItemId(), ifs);
            }
            catch (Exception e) {
                this.syncFailed(folder.getPath(), e);
            }
        }
    }

    private void syncMessages(List<Integer> folderIds, boolean fullSync) throws ServiceException {
        int lastModSeq = this.getMailbox().getLastChangeID();
        for (ImapFolderSync ifs : this.syncedFolders.values()) {
            this.checkIsEnabled();
            LocalFolder folder = ifs.getLocalFolder();
            int folderId = folder.getId();
            try {
                if (folderIds != null && !folderIds.contains(folderId) && !this.hasLocalChanges(folderId, lastModSeq)) continue;
                ifs.syncMessages(fullSync);
            }
            catch (Exception e) {
                this.syncFailed(folder.getPath(), e);
            }
        }
    }

    private boolean hasLocalChanges(int folderId, int lastModSeq) {
        SyncState ss = this.dataSource.getSyncState(folderId);
        return ss == null || ss.getLastModSeq() < lastModSeq;
    }

    private void finishSync() throws ServiceException {
        for (ImapFolderSync ifs : this.syncedFolders.values()) {
            try {
                ifs.finishSync();
            }
            catch (Exception e) {
                LocalFolder folder = ifs.getLocalFolder();
                this.syncFailed(folder.getPath(), e);
            }
        }
    }

    public Folder getFolder(int id) throws ServiceException {
        try {
            return this.localRootFolder.getMailbox().getFolderById(null, id);
        }
        catch (MailServiceException.NoSuchItemException e) {
            return null;
        }
    }

    private void syncFailed(String path, Exception e) throws ServiceException {
        String error = String.format("Synchronization of folder '%s' failed", path);
        LOG.error((Object)error, e);
        if (!this.canContinue(e)) {
            throw ServiceException.FAILURE(error, e);
        }
    }

    private boolean canContinue(Throwable e) {
        if (!this.dataSource.isOffline()) {
            return false;
        }
        if (e instanceof RemoteServiceException) {
            return false;
        }
        if (e instanceof ServiceException) {
            Throwable cause = e.getCause();
            return cause == null || this.canContinue(cause);
        }
        return e instanceof CommandFailedException;
    }

    String getLocalPath(ListData ld) {
        String remotePath = ld.getMailbox();
        char localDelimiter = ld.getDelimiter();
        String relativePath = ld.getMailbox();
        if (localDelimiter != '/' && (remotePath.indexOf(localDelimiter) >= 0 || remotePath.indexOf(47) >= 0)) {
            Object[] parts = remotePath.split("\\" + localDelimiter);
            for (int i = 0; i < parts.length; ++i) {
                parts[i] = ((String)parts[i]).replace('/', localDelimiter);
            }
            relativePath = StringUtil.join("/", parts);
        }
        if (this.dataSource.ignoreRemotePath(relativePath = this.ILLEGAL_FOLDER_CHARS.matcher(relativePath).replaceAll("_"))) {
            return null;
        }
        String zimbraPath = this.dataSource.mapRemoteToLocalPath(relativePath);
        if (zimbraPath == null) {
            while (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            zimbraPath = this.localRootFolder.getId() == 1 ? "/" + relativePath : this.localRootFolder.getPath() + "/" + relativePath;
        }
        return zimbraPath;
    }

    String getRemotePath(Folder folder) throws ServiceException {
        if (!this.localRootFolder.isDescendant(folder)) {
            return null;
        }
        String imapPath = this.dataSource.mapLocalToRemotePath(folder.getPath());
        if (imapPath == null) {
            if (folder.getId() < 256) {
                return null;
            }
            imapPath = folder.getPath();
            String rootPath = this.localRootFolder.getPath();
            if (!rootPath.endsWith("/")) {
                rootPath = rootPath + "/";
            }
            if (!imapPath.startsWith(rootPath)) {
                return null;
            }
            imapPath = imapPath.substring(rootPath.length());
        }
        if (this.delimiter != '\u0000' && this.delimiter != '/') {
            Object[] parts = imapPath.split("/");
            for (int i = 0; i < parts.length; ++i) {
                parts[i] = parts[i].replace(this.delimiter, '/');
            }
            imapPath = StringUtil.join(String.valueOf(this.delimiter), parts);
        }
        return imapPath;
    }

    private static class FetchDataHandler
    implements DataHandler {
        private FetchDataHandler() {
        }

        public Object handleData(ImapData data) throws Exception {
            try {
                return MessageContent.read(data.getInputStream(), data.getSize());
            }
            catch (OutOfMemoryError e) {
                Zimbra.halt("Out of memory");
                return null;
            }
        }
    }
}

