/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.cs.datasource.ImapMessage;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapMessageCollection
implements Iterable<ImapMessage> {
    private Map<Integer, ImapMessage> mByItemId = new HashMap<Integer, ImapMessage>();
    private Map<Long, ImapMessage> mByUid = new HashMap<Long, ImapMessage>();
    private Map<Integer, ImapMessage> mNoUid = new HashMap<Integer, ImapMessage>();

    public void add(ImapMessage msg) {
        this.mByItemId.put(msg.getItemId(), msg);
        long uid = msg.getUid();
        if (uid > 0L) {
            this.mByUid.put(msg.getUid(), msg);
        } else {
            this.mNoUid.put(msg.getItemId(), msg);
        }
    }

    public ImapMessage getByItemId(int itemId) {
        return this.mByItemId.get(itemId);
    }

    public ImapMessage getByUid(long uid) {
        return this.mByUid.get(uid);
    }

    public Collection<ImapMessage> getNoUid() {
        return this.mNoUid.values();
    }

    public boolean containsItemId(int itemId) {
        return this.mByItemId.containsKey(itemId);
    }

    public boolean containsUid(long uid) {
        return this.mByUid.containsKey(uid);
    }

    public int size() {
        return this.mByItemId.size();
    }

    @Override
    public Iterator<ImapMessage> iterator() {
        return this.mByItemId.values().iterator();
    }

    public Set<Long> getUids() {
        return this.mByUid.keySet();
    }

    public Set<Integer> getItemIds() {
        return this.mByItemId.keySet();
    }

    public long getLastUid() {
        long maxUid = 0L;
        for (long uid : this.mByUid.keySet()) {
            if (uid <= maxUid) continue;
            maxUid = uid;
        }
        return maxUid;
    }
}

