/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.datasource.DataSourceMapping;
import com.zimbra.cs.db.DbDataSource;

public class ImapMessage
extends DataSourceMapping {
    private int flags;
    private long uid;
    private static final String METADATA_KEY_FLAGS = "f";
    private static final String METADATA_KEY_UID = "u";

    public ImapMessage(DataSource ds, DbDataSource.DataSourceItem dsi) throws ServiceException {
        super(ds, dsi);
    }

    public ImapMessage(DataSource ds, int itemId) throws ServiceException {
        super(ds, itemId);
    }

    public ImapMessage(DataSource ds, int folderId, long uid) throws ServiceException {
        super(ds, ImapMessage.remoteId(folderId, uid));
    }

    public ImapMessage(DataSource ds, int folderId, int itemId, int flags, long uid) throws ServiceException {
        super(ds, folderId, itemId, ImapMessage.remoteId(folderId, uid));
        this.setFlags(flags);
        this.setUid(uid);
    }

    public ImapMessage(DataSource ds, int folderId, int itemId, int flags, long uid, int itemFlags) throws ServiceException {
        this(ds, folderId, itemId, flags, uid);
        this.setItemFlags(itemFlags);
    }

    public int getFlags() {
        return this.flags;
    }

    public long getUid() {
        return this.uid;
    }

    public void setFlags(int flags) {
        this.flags = flags;
        this.dsi.md.put(METADATA_KEY_FLAGS, this.flags);
    }

    public void setUid(long uid) {
        this.uid = uid;
        this.dsi.md.put(METADATA_KEY_UID, this.uid);
        this.setRemoteId(ImapMessage.remoteId(this.dsi.folderId, uid));
    }

    protected void parseMetaData() throws ServiceException {
        this.flags = (int)this.dsi.md.getLong(METADATA_KEY_FLAGS, 0L);
        this.uid = this.dsi.md.getLong(METADATA_KEY_UID, 0L);
    }

    private static String remoteId(int folderId, long uid) {
        return Integer.toString(folderId) + "_" + Long.toString(uid);
    }
}

