/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.common.datasource.SyncState;
import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.RemoteServiceException;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.datasource.DataSourceManager;
import com.zimbra.cs.datasource.ImapAppender;
import com.zimbra.cs.datasource.ImapFolder;
import com.zimbra.cs.datasource.ImapFolderCollection;
import com.zimbra.cs.datasource.ImapMessage;
import com.zimbra.cs.datasource.ImapMessageCollection;
import com.zimbra.cs.datasource.ImapSync;
import com.zimbra.cs.datasource.ImapUtil;
import com.zimbra.cs.datasource.LocalFolder;
import com.zimbra.cs.datasource.MessageContent;
import com.zimbra.cs.datasource.RemoteFolder;
import com.zimbra.cs.datasource.SyncErrorManager;
import com.zimbra.cs.datasource.SyncUtil;
import com.zimbra.cs.db.Db;
import com.zimbra.cs.db.DbDataSource;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailclient.CommandFailedException;
import com.zimbra.cs.mailclient.MailException;
import com.zimbra.cs.mailclient.imap.Body;
import com.zimbra.cs.mailclient.imap.CopyResult;
import com.zimbra.cs.mailclient.imap.FetchResponseHandler;
import com.zimbra.cs.mailclient.imap.Flags;
import com.zimbra.cs.mailclient.imap.ImapConnection;
import com.zimbra.cs.mailclient.imap.ListData;
import com.zimbra.cs.mailclient.imap.MessageData;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.util.Zimbra;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImapFolderSync {
    private final ImapSync imapSync;
    private final ImapConnection connection;
    private final DataSource ds;
    private final Mailbox mailbox;
    private final Statistics stats = new Statistics();
    private ImapFolder tracker;
    private LocalFolder localFolder;
    private RemoteFolder remoteFolder;
    private SyncState syncState;
    private ImapMessageCollection trackedMsgs;
    private Set<Integer> localMsgIds;
    private List<Integer> newMsgIds;
    private List<Long> addedUids;
    private long maxUid;
    private boolean completed;
    private int totalErrors;
    private static final Log LOG = ZimbraLog.datasource;
    private static final int FETCH_SIZE = LC.data_source_fetch_size.intValue();
    private static final int MAX_ITEM_ERRORS = 3;
    private static final int MAX_TOTAL_ERRORS = 10;

    public ImapFolderSync(ImapSync imapSync) throws ServiceException {
        this.imapSync = imapSync;
        this.connection = imapSync.getConnection();
        this.ds = imapSync.getDataSource();
        this.mailbox = imapSync.getMailbox();
    }

    public ImapFolder syncFolder(ListData ld) throws ServiceException, IOException {
        String path = ld.getMailbox();
        if (this.ds.isSyncInboxOnly() && !path.equalsIgnoreCase("Inbox")) {
            return null;
        }
        this.remoteFolder = new RemoteFolder(this.connection, path);
        this.tracker = this.imapSync.getTrackedFolders().getByRemotePath(path);
        if (this.tracker != null) {
            this.checkTrackedFolder(ld);
        } else {
            this.createLocalFolder(ld);
        }
        if (this.tracker != null) {
            this.localFolder.checkFlags(ld);
        }
        return this.tracker;
    }

    public ImapFolder syncFolder(Folder folder) throws ServiceException, IOException {
        DataSourceManager dsm = DataSourceManager.getInstance();
        if (!dsm.isSyncEnabled(this.ds, folder)) {
            return null;
        }
        this.localFolder = new LocalFolder(this.mailbox, folder);
        this.tracker = this.imapSync.getTrackedFolders().getByItemId(folder.getId());
        if (this.tracker != null) {
            this.remoteFolder = new RemoteFolder(this.connection, this.tracker.getRemoteId());
            if (!this.remoteFolder.exists()) {
                this.remoteFolder.info("folder was deleted", new Object[0]);
                if (dsm.isSyncEnabled(this.ds, folder)) {
                    this.localFolder.delete();
                }
                this.imapSync.deleteFolderTracker(this.tracker);
                this.tracker = null;
            } else if (!dsm.isSyncCapable(this.ds, folder) && !this.localFolder.getPath().equals(this.tracker.getLocalPath()) && this.deleteRemoteFolder(this.remoteFolder, this.tracker.getItemId())) {
                this.imapSync.deleteFolderTracker(this.tracker);
            }
        } else if (dsm.isSyncEnabled(this.ds, folder)) {
            this.remoteFolder = this.createRemoteFolder(folder);
            if (this.remoteFolder == null) {
                return null;
            }
            try {
                this.remoteFolder.select();
            }
            catch (CommandFailedException e) {
                this.syncFolderFailed(folder.getId(), this.remoteFolder.getPath(), "Unable to select remote folder", e);
                return null;
            }
            this.tracker = this.imapSync.createFolderTracker(folder.getId(), folder.getPath(), this.remoteFolder.getPath(), this.getUidValidity());
        }
        return this.tracker;
    }

    private RemoteFolder createRemoteFolder(Folder folder) throws ServiceException, IOException {
        String remotePath = this.imapSync.getRemotePath(folder);
        if (remotePath == null) {
            return null;
        }
        RemoteFolder newFolder = new RemoteFolder(this.connection, remotePath);
        try {
            newFolder.create();
        }
        catch (CommandFailedException e) {
            this.syncFolderFailed(folder.getId(), remotePath, "Unable to create remote folder", e);
            return null;
        }
        return newFolder;
    }

    public void syncMessages(boolean fullSync) throws ServiceException, IOException {
        if (this.tracker == null) {
            return;
        }
        DataSourceManager dsm = DataSourceManager.getInstance();
        if (this.tracker.getUidValidity() == 0L || !dsm.isSyncEnabled(this.ds, this.localFolder.getFolder())) {
            this.localFolder.debug("Synchronization disabled for this folder", new Object[0]);
            this.tracker = null;
            return;
        }
        com.zimbra.cs.mailclient.imap.Mailbox mb = this.checkUidValidity();
        this.syncState = this.getSyncState(fullSync);
        this.localFolder.debug("SyncState = " + this.syncState, new Object[0]);
        long uidNext = mb.getUidNext();
        if (uidNext > 0L && uidNext <= this.syncState.getLastUid()) {
            String msg = String.format("Inconsistent UIDNEXT value from server (got %d but last known uid %d)", uidNext, this.syncState.getLastUid());
            if (this.isYahoo()) {
                throw RemoteServiceException.YMAIL_INCONSISTENT_STATE();
            }
            ServiceException e = ServiceException.FAILURE(msg, null);
            this.syncFolderFailed(this.tracker.getItemId(), this.tracker.getLocalPath(), msg, e);
            throw e;
        }
        this.newMsgIds = new ArrayList<Integer>();
        this.addedUids = new ArrayList<Long>();
        long lastUid = this.syncState.getLastUid();
        int lastModSeq = this.syncState.getLastModSeq();
        if (fullSync) {
            if (this.hasCopyUid()) {
                this.moveMessages();
            }
            this.syncFlags(lastUid);
        } else if (lastModSeq > 0) {
            this.syncState.setLastModSeq(this.pushChanges(lastModSeq));
        }
        ArrayList<Long> uidsToDelete = new ArrayList<Long>();
        long l = this.maxUid = uidNext > 0L ? uidNext - 1L : 0L;
        if (this.maxUid <= 0L || lastUid < this.maxUid) {
            this.fetchMessages(lastUid + 1L, uidsToDelete);
        }
        if (!this.addedUids.isEmpty()) {
            Collections.sort(this.addedUids, Collections.reverseOrder());
            this.fetchMessages(this.addedUids, uidsToDelete);
        }
        this.deleteMessages(uidsToDelete);
        this.remoteFolder.close();
        this.syncState.setExists(mb.getExists());
        this.syncState.setUnseen(mb.getUnseen());
        this.trackedMsgs = null;
        this.localMsgIds = null;
        this.completed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyncState getSyncState(boolean fullSync) throws ServiceException {
        this.syncState = this.ds.removeSyncState(this.localFolder.getId());
        if (this.syncState == null || fullSync) {
            int lastModSeq = 0;
            Mailbox mailbox = this.mailbox;
            synchronized (mailbox) {
                this.trackedMsgs = this.tracker.getMessages();
                if (fullSync) {
                    this.localMsgIds = this.localFolder.getMessageIds();
                    lastModSeq = this.mailbox.getLastChangeID();
                }
            }
            if (this.syncState == null) {
                this.syncState = new SyncState();
                this.syncState.setLastUid(this.trackedMsgs.getLastUid());
                if (!fullSync) {
                    this.trackedMsgs = null;
                }
            }
            if (lastModSeq > 0) {
                this.syncState.setLastModSeq(lastModSeq);
            }
        }
        return this.syncState;
    }

    private void syncFlags(long lastUid) throws ServiceException, IOException {
        if (lastUid > 0L) {
            this.fetchFlags(lastUid, this.localMsgIds);
        }
        for (int id : this.localMsgIds) {
            ImapMessage trackedMsg = this.trackedMsgs.getByItemId(id);
            if (trackedMsg != null) {
                this.localFolder.deleteMessage(id);
                trackedMsg.delete();
                ++this.stats.msgsDeletedLocally;
                continue;
            }
            this.newMsgIds.add(id);
            ++this.stats.msgsAddedRemotely;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pushChanges(int lastModSeq) throws ServiceException, IOException {
        List<Integer> modifiedIds;
        List<Integer> deletedIds;
        int newModSeq;
        this.localFolder.debug("pushChanges: lastModSeq = %d", lastModSeq);
        Mailbox mailbox = this.mailbox;
        synchronized (mailbox) {
            newModSeq = this.mailbox.getLastChangeID();
            if (newModSeq <= lastModSeq) {
                return lastModSeq;
            }
            deletedIds = this.mailbox.getTombstones(lastModSeq).getIds((byte)5);
            modifiedIds = this.mailbox.getModifiedItems(null, lastModSeq, (byte)5).getFirst();
        }
        if (deletedIds == null) {
            deletedIds = new ArrayList<Integer>();
        }
        if (modifiedIds != null) {
            for (int id : modifiedIds) {
                this.clearError(id);
                Message msg = this.localFolder.getMessage(id);
                if (msg == null) continue;
                try {
                    this.pushModification(msg, deletedIds);
                }
                catch (Exception e) {
                    this.pushFailed(id, "Push modification failed", e);
                }
            }
        }
        if (!deletedIds.isEmpty()) {
            this.pushDeletes(deletedIds);
        }
        return newModSeq;
    }

    private void pushDeletes(List<Integer> deletedIds) throws ServiceException, IOException {
        int folderId = this.localFolder.getId();
        for (int id : deletedIds) {
            this.clearError(id);
            ImapMessage msgTracker = this.getMsgTracker(id);
            if (msgTracker == null || msgTracker.getFolderId() != folderId) continue;
            this.deleteMessage(msgTracker.getUid());
        }
    }

    private void pushModification(Message msg, List<Integer> deletedIds) throws ServiceException, IOException {
        int folderId = this.localFolder.getId();
        int msgId = msg.getId();
        int msgFolderId = msg.getFolderId();
        ImapMessage msgTracker = this.getMsgTracker(msgId);
        if (msgTracker != null) {
            int trackedFolderId = this.tracker.getFolderId();
            if (msgFolderId == trackedFolderId) {
                if (trackedFolderId == folderId) {
                    int flags = msgTracker.getFlags();
                    this.updateFlags(msgTracker, SyncUtil.zimbraToImapFlags(flags));
                }
            } else if (trackedFolderId == folderId && !this.moveMessage(msgTracker)) {
                deletedIds.add(msgId);
            }
        } else if (msgFolderId == folderId) {
            this.newMsgIds.add(msgId);
        }
    }

    public void finishSync() throws ServiceException, IOException {
        if (!this.completed) {
            return;
        }
        if (this.newMsgIds != null && !this.newMsgIds.isEmpty()) {
            this.appendMsgs(this.newMsgIds);
        }
        if (this.syncState != null) {
            this.ds.putSyncState(this.localFolder.getId(), this.syncState);
        }
        if (LOG.isDebugEnabled()) {
            if (this.stats.flagsUpdatedLocally > 0) {
                this.localFolder.debug("Updated %d flags", this.stats.flagsUpdatedLocally);
            }
            if (this.stats.flagsUpdatedRemotely > 0) {
                this.remoteFolder.debug("Updated %d flags", this.stats.flagsUpdatedRemotely);
            }
            if (this.stats.msgsAddedLocally > 0) {
                this.localFolder.debug("Added %d new messages", this.stats.msgsAddedLocally);
            }
            if (this.stats.msgsAddedRemotely > 0) {
                this.remoteFolder.debug("Added %d new messages", this.stats.msgsAddedRemotely);
            }
            if (this.stats.msgsDeletedLocally > 0) {
                this.localFolder.debug("Deleted %d messages", this.stats.msgsDeletedLocally);
            }
            if (this.stats.msgsDeletedRemotely > 0) {
                this.remoteFolder.debug("Deleted %d messages", this.stats.msgsDeletedRemotely);
            }
            if (this.stats.msgsCopiedRemotely > 0) {
                this.remoteFolder.debug("Copied %d messages", this.stats.msgsCopiedRemotely);
            }
        }
    }

    public LocalFolder getLocalFolder() {
        return this.localFolder;
    }

    private void checkTrackedFolder(ListData ld) throws ServiceException, IOException {
        this.localFolder = LocalFolder.fromId(this.mailbox, this.tracker.getItemId());
        DataSourceManager dsm = DataSourceManager.getInstance();
        if (this.localFolder == null || !dsm.isSyncCapable(this.ds, this.localFolder.getFolder()) && !this.localFolder.getPath().equals(this.tracker.getLocalPath())) {
            LOG.debug("Local folder '%s' was deleted", this.tracker.getLocalPath());
            if (this.deleteRemoteFolder(this.remoteFolder, this.tracker.getItemId())) {
                this.imapSync.deleteFolderTracker(this.tracker);
            }
            this.tracker = null;
            return;
        }
        if (!this.localFolder.getPath().equals(this.tracker.getLocalPath())) {
            this.renameFolder(ld, this.localFolder.getId());
        }
    }

    private boolean deleteRemoteFolder(RemoteFolder folder, int itemId) throws ServiceException, IOException {
        try {
            folder.delete();
        }
        catch (CommandFailedException e) {
            this.syncFolderFailed(itemId, folder.getPath(), "Unable to delete remote folder", e);
            return false;
        }
        return true;
    }

    private boolean renameFolder(ListData ld, int itemId) throws ServiceException, IOException {
        String localPath = this.localFolder.getPath();
        String newRemotePath = this.imapSync.getRemotePath(this.localFolder.getFolder());
        this.localFolder.info("folder was renamed (originally '%s')", this.tracker.getLocalPath());
        if (newRemotePath != null) {
            try {
                if (!newRemotePath.equals(this.remoteFolder.getPath())) {
                    this.remoteFolder = this.remoteFolder.renameTo(newRemotePath);
                }
            }
            catch (CommandFailedException e) {
                this.syncFolderFailed(itemId, localPath, "Unable to rename remote folder to " + newRemotePath, e);
                return false;
            }
            this.tracker.setLocalPath(localPath);
            this.tracker.setRemoteId(newRemotePath);
            this.tracker.update();
            this.ds.clearSyncState(this.tracker.getFolderId());
        } else {
            this.localFolder.info("folder was moved outside data source root", new Object[0]);
            this.imapSync.deleteFolderTracker(this.tracker);
            this.createLocalFolder(ld);
        }
        return true;
    }

    private void createLocalFolder(ListData ld) throws ServiceException, IOException {
        String remotePath = ld.getMailbox();
        String localPath = this.imapSync.getLocalPath(ld);
        if (localPath == null) {
            this.tracker = null;
            return;
        }
        Flags flags = ld.getFlags();
        long uidValidity = 0L;
        if (!flags.isNoselect()) {
            this.remoteFolder.select();
            uidValidity = this.getUidValidity();
        }
        this.localFolder = new LocalFolder(this.mailbox, localPath);
        if (!this.localFolder.exists()) {
            this.localFolder.create();
        }
        localPath = this.localFolder.getPath();
        this.tracker = this.imapSync.createFolderTracker(this.localFolder.getId(), localPath, remotePath, uidValidity);
    }

    private void appendMsgs(List<Integer> itemIds) throws ServiceException, IOException {
        this.remoteFolder.info("Appending %d message(s) to remote IMAP folder", itemIds.size());
        ImapAppender appender = new ImapAppender(this.connection, this.remoteFolder.getPath());
        for (int id : itemIds) {
            if (this.skipItem(id)) {
                LOG.warn("Skipping append of item %d due to previous errors", id);
                continue;
            }
            Message msg = this.localFolder.getMessage(id);
            if (msg == null) {
                this.clearError(id);
                continue;
            }
            this.remoteFolder.debug("Appending new message with item id %d", id);
            ImapMessage msgTracker = this.getMsgTracker(id);
            if (msgTracker != null) {
                msgTracker.delete();
            }
            try {
                long uid = appender.appendMessage(msg);
                try {
                    msgTracker = this.tracker.getMessage(uid);
                    if (msgTracker.getItemId() == id) continue;
                    this.localFolder.deleteMessage(id);
                }
                catch (MailServiceException.NoSuchItemException e) {
                    this.storeImapMessage(uid, id, msg.getFlagBitmask());
                }
            }
            catch (Exception e) {
                this.syncMessageFailed(id, "Append message failed", e);
            }
        }
    }

    private ImapMessage getMsgTracker(int itemId) throws ServiceException {
        try {
            return this.tracker.getMessage(itemId);
        }
        catch (MailServiceException.NoSuchItemException e) {
            return null;
        }
    }

    private void storeImapMessage(long uid, int msgId, int flags) throws ServiceException {
        ImapMessage msgTracker = new ImapMessage(this.ds, this.localFolder.getId(), msgId, flags, uid);
        msgTracker.add();
        if (uid > this.syncState.getLastUid()) {
            this.syncState.setLastUid(uid);
        }
    }

    private com.zimbra.cs.mailclient.imap.Mailbox checkUidValidity() throws ServiceException, IOException {
        com.zimbra.cs.mailclient.imap.Mailbox mb = this.remoteFolder.select();
        long uidValidity = this.getUidValidity();
        if (uidValidity == this.tracker.getUidValidity()) {
            return mb;
        }
        this.remoteFolder.info("Resynchronizing folder because UIDVALIDITY has changed from %d to %d", this.tracker.getUidValidity(), uidValidity);
        List<Integer> newLocalIds = this.tracker.getNewMessageIds();
        if (newLocalIds.size() > 0) {
            this.remoteFolder.info("Copying %d messages to remote folder", newLocalIds.size());
            ImapAppender appender = new ImapAppender(this.connection, this.remoteFolder.getPath());
            for (int id : newLocalIds) {
                this.clearError(id);
                Message msg = this.localFolder.getMessage(id);
                if (msg == null) continue;
                try {
                    appender.appendMessage(msg);
                }
                catch (Exception e) {
                    this.syncMessageFailed(id, "Append message failed", e);
                }
            }
        }
        int folderId = this.localFolder.getId();
        this.mailbox.emptyFolder(null, this.tracker.getItemId(), false);
        this.localFolder.emptyFolder();
        this.tracker.deleteMappings();
        this.tracker.setUidValidity(uidValidity);
        this.tracker.update();
        this.ds.clearSyncState(folderId);
        return this.remoteFolder.select();
    }

    private void fetchFlags(long lastUid, Set<Integer> msgIds) throws ServiceException, IOException {
        String seq = "1:" + lastUid;
        this.remoteFolder.debug("Fetching flags for UID sequence %s", seq);
        List<Long> uidsToDelete = this.fetchFlags(seq, msgIds);
        this.deleteMessages(uidsToDelete);
    }

    private List<Long> fetchFlags(String seq, Set<Integer> existingMsgIds) throws ServiceException, IOException {
        Map<Long, MessageData> mds = this.connection.uidFetch(seq, (Object)"FLAGS");
        this.removeDeleted(mds);
        ArrayList<Long> uidsToDelete = new ArrayList<Long>();
        for (MessageData md : mds.values()) {
            long uid = md.getUid();
            ImapMessage trackedMsg = this.trackedMsgs.getByUid(uid);
            if (trackedMsg != null) {
                int msgId = trackedMsg.getItemId();
                if (existingMsgIds.contains(msgId)) {
                    existingMsgIds.remove(msgId);
                    try {
                        this.updateFlags(trackedMsg, md.getFlags());
                        this.clearError(msgId);
                    }
                    catch (MailServiceException.NoSuchItemException e) {
                        uidsToDelete.add(uid);
                        this.clearError(msgId);
                    }
                    catch (Exception e) {
                        this.syncMessageFailed(msgId, "Unable to update message flags", e);
                    }
                    continue;
                }
                uidsToDelete.add(uid);
                this.clearError(msgId);
                continue;
            }
            this.remoteFolder.debug("Adding new message with UID %d detected while syncing flags", uid);
            this.addedUids.add(uid);
        }
        return uidsToDelete;
    }

    private void updateFlags(ImapMessage msg, Flags flags) throws ServiceException, IOException {
        int id = msg.getItemId();
        int localFlags = msg.getItemFlags();
        int trackedFlags = msg.getFlags();
        int remoteFlags = SyncUtil.imapToZimbraFlags(flags);
        int newLocalFlags = ImapFolderSync.mergeFlags(localFlags, trackedFlags, remoteFlags);
        int newRemoteFlags = SyncUtil.imapFlagsOnly(newLocalFlags);
        if (LOG.isDebugEnabled() && (newLocalFlags != localFlags || newRemoteFlags != remoteFlags || newRemoteFlags != trackedFlags)) {
            this.localFolder.debug("Updating flags for message with item id %d: local=%s, tracked=%s, remote=%s, new_local=%s, new_remote=%s", id, Flag.bitmaskToFlags(localFlags), Flag.bitmaskToFlags(trackedFlags), Flag.bitmaskToFlags(remoteFlags), Flag.bitmaskToFlags(newLocalFlags), Flag.bitmaskToFlags(newRemoteFlags));
        }
        if (newLocalFlags != localFlags) {
            this.localFolder.setMessageFlags(id, newLocalFlags);
            ++this.stats.flagsUpdatedLocally;
        }
        if (newRemoteFlags != remoteFlags) {
            String uids = String.valueOf(msg.getUid());
            Flags toAdd = SyncUtil.getFlagsToAdd(flags, newRemoteFlags);
            Flags toRemove = SyncUtil.getFlagsToRemove(flags, newRemoteFlags);
            if (!toAdd.isEmpty()) {
                this.connection.uidStore(uids, "+FLAGS.SILENT", toAdd);
            }
            if (!toRemove.isEmpty()) {
                this.connection.uidStore(uids, "-FLAGS.SILENT", toRemove);
            }
            ++this.stats.flagsUpdatedRemotely;
        }
        if (newRemoteFlags != trackedFlags) {
            msg.setFlags(newRemoteFlags);
            msg.update();
            ++this.stats.flagsUpdatedLocally;
        }
    }

    private void fetchMessages(long startUid, List<Long> uidsToDelete) throws ServiceException, IOException {
        List<Long> uids = this.remoteFolder.getUids(startUid, this.maxUid);
        if (uids.size() > 0) {
            this.fetchMessages(uids, uidsToDelete);
        }
    }

    private void fetchMessages(List<Long> uids, List<Long> uidsToDelete) throws ServiceException, IOException {
        this.remoteFolder.debug("Fetching %d new IMAP message(s)", uids.size());
        long lastCheckTime = System.currentTimeMillis();
        this.removeSkippedUids(uids);
        Iterator<Long> ui = uids.iterator();
        while (ui.hasNext()) {
            this.imapSync.checkIsEnabled();
            this.fetchMessages(this.nextFetchSeq(ui), uidsToDelete);
            this.ds.checkPendingMessages();
            long time = System.currentTimeMillis();
            long freq = this.ds.getSyncFrequency();
            if (this.maxUid <= 0L || freq <= 0L || time - lastCheckTime <= freq) continue;
            lastCheckTime = time;
            List<Long> newUids = this.remoteFolder.getUids(this.maxUid + 1L, 0L);
            if (newUids.isEmpty()) continue;
            this.remoteFolder.debug("Fetching %d newly arrived IMAP message(s)", newUids.size());
            Iterator<Long> nui = newUids.iterator();
            do {
                this.fetchMessages(this.nextFetchSeq(nui), uidsToDelete);
            } while (nui.hasNext());
            this.maxUid = newUids.get(0);
        }
    }

    private void removeSkippedUids(List<Long> uids) {
        Iterator<Long> it = uids.iterator();
        while (it.hasNext()) {
            long uid = it.next();
            if (!this.skipUid(uid)) continue;
            LOG.warn("Skipping fetch of uid %d due to previous errors", uid);
            it.remove();
        }
    }

    private String nextFetchSeq(Iterator<Long> uids) {
        StringBuilder sb = new StringBuilder();
        sb.append(uids.next());
        int count = FETCH_SIZE;
        while (uids.hasNext() && --count > 0) {
            sb.append(',').append(uids.next());
        }
        return sb.toString();
    }

    private void fetchMessages(String seq, final List<Long> uidsToDelete) throws ServiceException, IOException {
        final Map<Long, MessageData> flagsByUid = this.connection.uidFetch(seq, (Object)"(FLAGS INTERNALDATE)");
        this.removeDeleted(flagsByUid);
        final Set<Long> uidSet = flagsByUid.keySet();
        if (uidSet.isEmpty()) {
            return;
        }
        FetchResponseHandler handler = new FetchResponseHandler(){

            public void handleFetchResponse(MessageData md) throws Exception {
                long uid = md.getUid();
                try {
                    ImapFolderSync.this.handleFetch(md, flagsByUid, uidsToDelete);
                    ImapFolderSync.this.clearError(uid);
                }
                catch (OutOfMemoryError e) {
                    Zimbra.halt("Out of memory");
                }
                catch (Exception e) {
                    ImapFolderSync.this.syncFailed("Fetch failed for uid " + uid, e);
                    SyncErrorManager.incrementErrorCount(ImapFolderSync.this.ds, ImapFolderSync.this.remoteId(uid));
                }
                uidSet.remove(uid);
            }
        };
        LOG.debug("Fetching messages for sequence: " + seq);
        try {
            this.connection.uidFetch(ImapFolderSync.getSequence(uidSet), "BODY.PEEK[]", handler);
        }
        catch (CommandFailedException e) {
            String msg = "UID FETCH failed: " + e.toString();
            this.checkCanContinue(msg, e);
            LOG.warn((Object)msg, e);
        }
        if (uidSet.isEmpty()) {
            return;
        }
        LOG.info("Fetching remaining messages one at a time for UIDs: " + uidSet);
        for (long uid : ImapFolderSync.getOrderedUids(uidSet)) {
            try {
                LOG.info("Fetching message for uid: " + uid);
                MessageData md = this.connection.uidFetch(uid, (Object)"BODY.PEEK[]");
                handler.handleFetchResponse(md);
            }
            catch (Exception e) {
                String msg = "Error while fetching message for UID " + uid;
                this.checkCanContinue(msg, e);
                LOG.warn((Object)msg, e);
            }
        }
        if (!uidSet.isEmpty()) {
            LOG.error("Unable to fetch messages for uids: " + uidSet);
        }
    }

    private void removeDeleted(Map<Long, MessageData> mds) {
        Iterator<MessageData> it = mds.values().iterator();
        while (it.hasNext()) {
            MessageData md = it.next();
            Flags flags = md.getFlags();
            if (flags == null || !flags.isDeleted()) continue;
            this.remoteFolder.debug("Remote message with uid %d is flagged \\Deleted", md.getUid());
            it.remove();
        }
    }

    private static String getSequence(Set<Long> uidSet) {
        StringBuilder sb = new StringBuilder();
        Iterator<Long> it = ImapFolderSync.getOrderedUids(uidSet).iterator();
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append(',').append(it.next());
        }
        return sb.toString();
    }

    private static Collection<Long> getOrderedUids(Collection<Long> uidSet) {
        ArrayList<Long> uids = new ArrayList<Long>(uidSet);
        Collections.sort(uids, Collections.reverseOrder());
        return uids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFetch(MessageData md, Map<Long, MessageData> flagsByUid, List<Long> uidsToDelete) throws ServiceException, IOException {
        Message msg;
        long uid = md.getUid();
        if (uid == -1L) {
            throw new MailException("Missing UID in FETCH response");
        }
        MessageData flagsData = flagsByUid.get(uid);
        this.remoteFolder.debug("Found new IMAP message with uid %d", uid);
        Date date = flagsData.getInternalDate();
        Long receivedDate = date != null ? Long.valueOf(date.getTime()) : null;
        int zflags = SyncUtil.imapToZimbraFlags(flagsData.getFlags());
        int folderId = this.localFolder.getId();
        MessageContent mc = ImapFolderSync.getContent(md);
        try {
            ParsedMessage pm = mc.getParsedMessage(receivedDate, this.mailbox.attachmentsIndexingEnabled());
            msg = this.imapSync.addMessage(null, pm, folderId, zflags, mc.getDeliveryContext());
            Object var15_13 = null;
        }
        catch (Throwable throwable) {
            Object var15_14 = null;
            mc.cleanup();
            throw throwable;
        }
        mc.cleanup();
        if (msg != null && msg.getFolderId() == folderId) {
            this.storeImapMessage(uid, msg.getId(), zflags);
            ++this.stats.msgsAddedLocally;
        } else {
            uidsToDelete.add(uid);
        }
    }

    private static MessageContent getContent(MessageData md) throws MailException {
        Body[] sections = md.getBodySections();
        if (sections == null || sections.length != 1) {
            throw new MailException("Invalid body section FETCH response for uid " + md.getUid());
        }
        return (MessageContent)sections[0].getData();
    }

    private void deleteMessages(List<Long> uids) throws ServiceException, IOException {
        for (long uid : uids) {
            this.deleteMessage(uid);
        }
    }

    private boolean deleteMessage(long uid) throws ServiceException, IOException {
        if (this.skipUid(uid)) {
            LOG.warn("Skipping remote delete of uid %d due to previous errors", uid);
            return false;
        }
        try {
            this.remoteFolder.deleteMessage(uid);
            ++this.stats.msgsDeletedRemotely;
            this.clearError(uid);
        }
        catch (CommandFailedException e) {
            this.syncMessageFailed(uid, "Cannot delete message with uid " + uid, (Exception)e);
            return false;
        }
        try {
            this.tracker.getMessage(uid).delete();
        }
        catch (MailServiceException.NoSuchItemException noSuchItemException) {
            // empty catch block
        }
        return true;
    }

    private void moveMessages() throws IOException, ServiceException {
        Collection<DbDataSource.DataSourceItem> mappings = this.tracker.getMappings();
        List<Integer> allIds = this.mailbox.listItemIds(this.mailbox.getOperationContext(), (byte)5, this.tracker.getItemId());
        Object[] sortedIds = allIds.toArray(new Integer[allIds.size()]);
        Arrays.sort(sortedIds);
        for (DbDataSource.DataSourceItem mapping : mappings) {
            if (Arrays.binarySearch(sortedIds, (Object)mapping.itemId) >= 0) continue;
            this.moveMessage(new ImapMessage(this.ds, mapping));
        }
    }

    private boolean moveMessage(ImapMessage msgTracker) throws ServiceException, IOException {
        CopyResult cr;
        String remotePath;
        Folder folder;
        Message msg;
        if (!this.hasCopyUid()) {
            return false;
        }
        try {
            msg = this.mailbox.getMessageById(null, msgTracker.getItemId());
            folder = this.mailbox.getFolderById(null, msg.getFolderId());
        }
        catch (MailServiceException.NoSuchItemException e) {
            return false;
        }
        if (!DataSourceManager.getInstance().isSyncEnabled(this.ds, folder)) {
            return false;
        }
        int fid = folder.getId();
        ImapFolderCollection trackedFolders = this.imapSync.getTrackedFolders();
        ImapFolder folderTracker = trackedFolders.getByItemId(fid);
        if (folderTracker != null) {
            remotePath = folderTracker.getRemoteId();
        } else {
            RemoteFolder newFolder = this.createRemoteFolder(folder);
            if (newFolder == null) {
                return false;
            }
            remotePath = newFolder.getPath();
        }
        try {
            cr = this.remoteFolder.copyMessage(msgTracker.getUid(), remotePath);
        }
        catch (IOException e) {
            this.syncMessageFailed(msgTracker.getUid(), "COPY failed", (Exception)e);
            return false;
        }
        if (cr == null) {
            return false;
        }
        ++this.stats.msgsCopiedRemotely;
        if (folderTracker == null) {
            this.imapSync.createFolderTracker(fid, folder.getPath(), remotePath, cr.getUidValidity());
        } else {
            ImapFolderSync syncedFolder = this.imapSync.getSyncedFolder(fid);
            if (syncedFolder != null && syncedFolder.newMsgIds != null) {
                syncedFolder.newMsgIds.remove((Object)msg.getId());
            }
        }
        if (!this.deleteMessage(msgTracker.getUid())) {
            LOG.warn("Unable to delete message with uid " + msgTracker.getUid());
            return false;
        }
        msgTracker.delete();
        long uid = cr.getToUids()[0];
        msgTracker = new ImapMessage(this.ds, fid, msg.getId(), msgTracker.getFlags(), uid);
        msgTracker.add();
        ImapFolderSync syncedFolder = this.imapSync.getSyncedFolder(fid);
        if (syncedFolder != null && syncedFolder.syncState != null) {
            syncedFolder.syncState.updateLastUid(uid);
        } else {
            SyncState ss = this.ds.getSyncState(fid);
            if (ss != null) {
                ss.updateLastUid(uid);
                this.ds.putSyncState(fid, ss);
            }
        }
        return true;
    }

    private static int mergeFlags(int localFlags, int trackedFlags, int remoteFlags) {
        return trackedFlags & (localFlags & remoteFlags) | ~trackedFlags & (localFlags | remoteFlags);
    }

    private boolean hasCopyUid() {
        return this.hasUidPlus() || this.isYahoo();
    }

    private boolean hasUidPlus() {
        return this.connection.hasUidPlus();
    }

    private boolean isYahoo() {
        return ImapUtil.isYahoo(this.connection);
    }

    private long getUidValidity() {
        long uidValidity = this.connection.getMailbox().getUidValidity();
        return uidValidity > 0L ? uidValidity : 1L;
    }

    private boolean skipItem(int itemId) {
        return SyncErrorManager.getErrorCount(this.ds, itemId) >= 3;
    }

    private boolean skipUid(long uid) {
        return SyncErrorManager.getErrorCount(this.ds, this.remoteId(uid)) >= 3;
    }

    private String remoteId(long uid) {
        return this.getUidValidity() + ":" + uid;
    }

    private void clearError(int itemId) {
        SyncErrorManager.clearError(this.ds, itemId);
    }

    private void clearError(long uid) {
        SyncErrorManager.clearError(this.ds, this.remoteId(uid));
    }

    private void pushFailed(int itemId, String msg, Exception e) throws ServiceException {
        this.checkCanContinue(msg, e);
        LOG.error((Object)msg, e);
        this.ds.reportError(itemId, msg, e);
    }

    private void syncFailed(String msg, Exception e) throws ServiceException {
        this.checkCanContinue(msg, e);
        LOG.error((Object)msg, e);
        this.ds.reportError(-1, msg, e);
    }

    private void syncFolderFailed(int itemId, String path, String msg, Exception e) throws ServiceException {
        this.checkCanContinue(msg, e);
        int count = SyncErrorManager.incrementErrorCount(this.ds, itemId);
        if (count <= 3) {
            LOG.error((Object)msg, e);
            if (count == 3) {
                String error = String.format("Synchronization of folder '%s' disabled due to error: %s", path, msg);
                this.ds.reportError(itemId, error, e);
                try {
                    if (this.ds.isOffline()) {
                        SyncUtil.setSyncEnabled(DataSourceManager.getInstance().getMailbox(this.ds), itemId, false);
                    }
                }
                catch (MailServiceException.NoSuchItemException ex) {
                    // empty catch block
                }
                this.clearError(itemId);
            }
        }
    }

    private void syncMessageFailed(int itemId, String msg, Exception e) throws ServiceException {
        int count;
        if (!(e instanceof CommandFailedException)) {
            this.checkCanContinue(msg, e);
        }
        if ((count = SyncErrorManager.incrementErrorCount(this.ds, itemId)) <= 3) {
            LOG.error((Object)msg, e);
            if (count == 3) {
                this.ds.reportError(itemId, msg, e);
            }
        }
        this.incrementTotalErrors();
        if (e instanceof CommandFailedException && !((CommandFailedException)e).canContinue()) {
            throw ServiceException.FAILURE(msg, e);
        }
    }

    private void syncMessageFailed(long uid, String msg, Exception e) throws ServiceException {
        this.checkCanContinue(msg, e);
        int count = SyncErrorManager.incrementErrorCount(this.ds, this.remoteId(uid));
        if (count <= 3) {
            LOG.error((Object)msg, e);
            if (count == 3) {
                this.ds.reportError(-1, msg, e);
            }
        }
        this.incrementTotalErrors();
    }

    private void incrementTotalErrors() throws ServiceException {
        ++this.totalErrors;
        if (this.totalErrors > 10) {
            String error = String.format("Synchronization of folder '%s' disabled due to maximum number of per-item errors exceeded", this.localFolder.getPath());
            this.ds.reportError(this.localFolder.getId(), error, ServiceException.FAILURE(error, null));
            try {
                SyncUtil.setSyncEnabled(DataSourceManager.getInstance().getMailbox(this.ds), this.localFolder.getId(), false);
            }
            catch (MailServiceException.NoSuchItemException noSuchItemException) {
                // empty catch block
            }
        }
    }

    private void checkCanContinue(String msg, Exception e) throws ServiceException {
        if (!this.canContinue(e)) {
            LOG.error((Object)msg, e);
            if (e instanceof ServiceException) {
                throw (ServiceException)e;
            }
            throw ServiceException.FAILURE(msg, e);
        }
    }

    private boolean canContinue(Throwable e) {
        if (!this.ds.isOffline()) {
            return false;
        }
        if (e instanceof ServiceException) {
            Throwable cause = e.getCause();
            return cause == null || this.canContinue(cause);
        }
        if (e instanceof SQLException) {
            return Db.errorMatches((SQLException)e, Db.Error.DUPLICATE_ROW);
        }
        if (e instanceof CommandFailedException) {
            return ((CommandFailedException)e).canContinue();
        }
        return false;
    }

    private static class Statistics {
        int flagsUpdatedLocally;
        int flagsUpdatedRemotely;
        int msgsAddedLocally;
        int msgsAddedRemotely;
        int msgsDeletedLocally;
        int msgsDeletedRemotely;
        int msgsCopiedRemotely;

        private Statistics() {
        }
    }
}

