/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.datasource.ImapSync;
import com.zimbra.cs.mailclient.imap.CAtom;
import com.zimbra.cs.mailclient.imap.ImapConfig;
import com.zimbra.cs.mailclient.imap.ImapConnection;
import com.zimbra.cs.mailclient.imap.ImapResponse;
import com.zimbra.cs.mailclient.imap.ResponseHandler;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;

public class ImapFolderMonitor {
    private final DataSource ds;
    private final String folderName;
    private final AtomicBoolean hasNewMessages = new AtomicBoolean();
    private ImapConnection connection;
    private TimerTask task;
    private static final Timer TIMER = new Timer("ImapFolderMonitor", true);
    private static final int TIMEOUT = 1500;

    public ImapFolderMonitor(DataSource ds, String folderName) {
        this.ds = ds;
        this.folderName = folderName;
    }

    public synchronized void start() throws IOException, ServiceException {
        if (this.isRunning()) {
            return;
        }
        this.connect();
        if (!this.connection.hasCapability("IDLE")) {
            this.disconnect();
            throw ServiceException.FAILURE("Connection must support IDLE", null);
        }
        this.task = new TimerTask(){

            public void run() {
                try {
                    ImapFolderMonitor.this.restartIdle();
                }
                catch (Exception e) {
                    ImapFolderMonitor.this.stop();
                }
            }
        };
        TIMER.schedule(this.task, 0L, 1500000L);
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            this.task.cancel();
            this.disconnect();
            this.task = null;
        }
    }

    private void disconnect() {
        try {
            this.connection.stopIdle();
            this.connection.close();
            this.connection = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean isRunning() {
        return this.task != null;
    }

    public boolean checkHasNewMessagesAndReset() {
        return this.hasNewMessages.getAndSet(false);
    }

    private synchronized void restartIdle() throws IOException, ServiceException {
        if (!this.isRunning()) {
            return;
        }
        try {
            this.connection.stopIdle();
        }
        catch (IOException e) {
            this.connect();
        }
        this.connection.select(this.folderName);
        this.hasNewMessages.set(true);
        this.connection.idle(new ResponseHandler(){

            public void handleResponse(ImapResponse res) {
                if (res.getCCode() == CAtom.EXISTS) {
                    ImapFolderMonitor.this.hasNewMessages.set(true);
                }
            }
        });
    }

    private void connect() throws IOException, ServiceException {
        ImapConfig config = ImapSync.getImapConfig(this.ds);
        config.setReadTimeout(1500);
        config.setConnectTimeout(1500);
        this.connection = new ImapConnection(config);
        this.connection.login(this.ds.getDecryptedPassword());
    }
}

