/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.cs.datasource.ImapFolder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapFolderCollection
implements Iterable<ImapFolder> {
    private final Map<Integer, ImapFolder> mByItemId;
    private final Map<String, ImapFolder> mByLocalPath;
    private final Map<String, ImapFolder> mByRemotePath;

    public ImapFolderCollection() {
        this.mByItemId = new HashMap<Integer, ImapFolder>();
        this.mByLocalPath = new HashMap<String, ImapFolder>();
        this.mByRemotePath = new HashMap<String, ImapFolder>();
    }

    public ImapFolderCollection(ImapFolderCollection folders) {
        this.mByItemId = new HashMap<Integer, ImapFolder>(folders.mByItemId);
        this.mByLocalPath = new HashMap<String, ImapFolder>(folders.mByLocalPath);
        this.mByRemotePath = new HashMap<String, ImapFolder>(folders.mByRemotePath);
    }

    public void add(ImapFolder imapFolder) {
        this.mByLocalPath.put(imapFolder.getLocalPath().toLowerCase(), imapFolder);
        this.mByRemotePath.put(imapFolder.getRemoteId().toLowerCase(), imapFolder);
        this.mByItemId.put(imapFolder.getItemId(), imapFolder);
    }

    public void remove(ImapFolder imapFolder) {
        this.mByLocalPath.remove(imapFolder.getLocalPath().toLowerCase());
        this.mByRemotePath.remove(imapFolder.getRemoteId().toLowerCase());
        this.mByItemId.remove(imapFolder.getItemId());
    }

    public ImapFolder getByLocalPath(String localPath) {
        return this.mByLocalPath.get(localPath.toLowerCase());
    }

    public ImapFolder getByRemotePath(String remotePath) {
        return this.mByRemotePath.get(remotePath.toLowerCase());
    }

    public ImapFolder getByItemId(int itemId) {
        return this.mByItemId.get(itemId);
    }

    public int size() {
        return this.mByItemId.size();
    }

    @Override
    public Iterator<ImapFolder> iterator() {
        return this.mByItemId.values().iterator();
    }
}

