/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.datasource.DataSourceFolderMapping;
import com.zimbra.cs.datasource.DataSourceManager;
import com.zimbra.cs.datasource.ImapFolderCollection;
import com.zimbra.cs.datasource.ImapMessage;
import com.zimbra.cs.datasource.ImapMessageCollection;
import com.zimbra.cs.db.DbDataSource;
import com.zimbra.cs.db.DbImapFolder;
import com.zimbra.cs.db.DbImapMessage;
import com.zimbra.cs.mailbox.Mailbox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapFolder
extends DataSourceFolderMapping {
    private String localPath;
    private long uidNext = -1L;
    private Long uidValidity;
    private static final String METADATA_KEY_LOCAL_PATH = "lp";
    private static final String METADATA_KEY_UID_VALIDITY = "uv";

    public ImapFolder(DataSource ds, DbDataSource.DataSourceItem dsi) throws ServiceException {
        super(ds, dsi);
    }

    public ImapFolder(DataSource ds, int itemId) throws ServiceException {
        super(ds, itemId);
    }

    public ImapFolder(DataSource ds, String remoteId) throws ServiceException {
        super(ds, remoteId);
    }

    public ImapFolder(DataSource ds, int itemId, String remoteId, String localPath, Long uidValidity) throws ServiceException {
        super(ds, itemId, remoteId);
        this.setLocalPath(localPath);
        this.setUidValidity(uidValidity);
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public long getUidNext() {
        return this.uidNext;
    }

    public long getUidValidity() {
        return this.uidValidity;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
        this.dsi.md.put(METADATA_KEY_LOCAL_PATH, this.localPath);
    }

    public void setUidNext(long uidNext) {
        this.uidNext = uidNext;
    }

    public void setUidValidity(Long uidValidity) {
        this.uidValidity = uidValidity;
        this.dsi.md.put(METADATA_KEY_UID_VALIDITY, this.uidValidity);
    }

    @Override
    protected void parseMetaData() throws ServiceException {
        this.localPath = this.dsi.md.get(METADATA_KEY_LOCAL_PATH, "");
        this.uidValidity = this.dsi.md.getLong(METADATA_KEY_UID_VALIDITY, -1L);
    }

    public ImapMessage getMessage(int itemId) throws ServiceException {
        return new ImapMessage(this.ds, itemId);
    }

    public ImapMessage getMessage(long uid) throws ServiceException {
        return new ImapMessage(this.ds, this.getItemId(), uid);
    }

    public ImapMessageCollection getMessages() throws ServiceException {
        Collection<DbDataSource.DataSourceItem> mappings = ImapFolder.getMappingsAndFlags(this.ds, this.getItemId());
        ImapMessageCollection imc = new ImapMessageCollection();
        for (DbDataSource.DataSourceItem mapping : mappings) {
            imc.add(new ImapMessage(this.ds, mapping));
        }
        return imc;
    }

    public List<Integer> getNewMessageIds() throws ServiceException {
        Collection<DbDataSource.DataSourceItem> mappings = ImapFolder.getMappingsAndFlags(this.ds, this.getItemId());
        Mailbox mbox = DataSourceManager.getInstance().getMailbox(this.ds);
        List<Integer> allIds = mbox.listItemIds(mbox.getOperationContext(), (byte)5, this.getItemId());
        ArrayList<Integer> newIds = new ArrayList<Integer>();
        block0: for (Integer id : allIds) {
            for (DbDataSource.DataSourceItem mapping : mappings) {
                if (mapping.itemId != id) continue;
                mappings.remove(mapping);
                continue block0;
            }
            newIds.add(id);
        }
        return newIds;
    }

    public static ImapFolderCollection getFolders(DataSource ds) throws ServiceException {
        Collection<DbDataSource.DataSourceItem> mappings = ImapFolder.getMappings(ds, ds.getFolderId());
        ImapFolderCollection ifc = new ImapFolderCollection();
        if (mappings.size() == 0) {
            Mailbox mbox = DataSourceManager.getInstance().getMailbox(ds);
            ZimbraLog.datasource.info("Upgrading IMAP data for %s", ds.getName());
            DbDataSource.deleteAllMappings(ds);
            try {
                for (ImapFolder folderTracker : DbImapFolder.getImapFolders(mbox, ds)) {
                    folderTracker.add();
                    for (ImapMessage msgTracker : DbImapMessage.getImapMessages(mbox, ds, folderTracker)) {
                        msgTracker.add();
                    }
                }
            }
            catch (Exception e) {
                DbDataSource.deleteAllMappings(ds);
                throw ServiceException.FAILURE("IMAP data upgrade failed for " + ds.getName(), e);
            }
            mappings = ImapFolder.getMappings(ds, ds.getFolderId());
            DbImapFolder.deleteImapData(mbox, ds.getId());
        }
        for (DbDataSource.DataSourceItem mapping : mappings) {
            ifc.add(new ImapFolder(ds, mapping));
        }
        return ifc;
    }

    public String toString() {
        return String.format("ImapFolder: { itemId=%d, dataSourceId=%s, localPath=%s, remotePath=%s, uidValidity=%d }", this.dsi.itemId, this.ds.getId(), this.localPath, this.dsi.remoteId, this.uidValidity);
    }
}

