/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.datasource.SyncUtil;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailclient.imap.AppendResult;
import com.zimbra.cs.mailclient.imap.CAtom;
import com.zimbra.cs.mailclient.imap.Envelope;
import com.zimbra.cs.mailclient.imap.Flags;
import com.zimbra.cs.mailclient.imap.ImapConnection;
import com.zimbra.cs.mailclient.imap.ImapData;
import com.zimbra.cs.mailclient.imap.ImapRequest;
import com.zimbra.cs.mailclient.imap.Literal;
import com.zimbra.cs.mailclient.imap.Mailbox;
import com.zimbra.cs.mailclient.imap.MailboxName;
import com.zimbra.cs.mailclient.imap.MessageData;
import com.zimbra.cs.mailclient.imap.ResponseText;
import com.zimbra.cs.store.MailboxBlob;
import com.zimbra.cs.store.StoreManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapAppender {
    private final ImapConnection connection;
    private final String mailbox;
    private boolean hasAppendUid;
    private MailDateFormat mdf;

    public ImapAppender(ImapConnection connection, String mailbox) {
        this.connection = connection;
        this.mailbox = mailbox;
        this.hasAppendUid = connection.hasUidPlus();
    }

    public void setHasAppendUid(boolean hasAppendUid) {
        this.hasAppendUid = hasAppendUid;
    }

    public long appendMessage(Message msg) throws IOException, ServiceException {
        return this.append(new MessageInfo(msg));
    }

    public long appendMessage(File file, Flags flags) throws IOException, ServiceException {
        return this.append(new MessageInfo(ImapAppender.getData(file), flags));
    }

    public long appendMessage(byte[] b, Flags flags) throws IOException, ServiceException {
        return this.append(new MessageInfo(ImapAppender.getData(b), flags));
    }

    private long append(MessageInfo mi) throws IOException, ServiceException {
        long l;
        InputStream is = mi.data.getInputStream();
        Literal lit = new Literal(is, mi.data.getSize());
        try {
            l = this.hasAppendUid ? this.append(mi, lit) : this.appendSlow(mi, lit);
            Object var7_6 = null;
        }
        catch (MessagingException e) {
            try {
                throw ServiceException.FAILURE("Parsing error", e);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                is.close();
                throw throwable;
            }
        }
        is.close();
        return l;
    }

    private static Data getData(final File file) {
        return new Data(){

            public InputStream getInputStream() throws IOException {
                return new FileInputStream(file);
            }

            public int getSize() {
                return (int)file.length();
            }
        };
    }

    private long append(MessageInfo mi, Literal data) throws IOException {
        AppendResult ar;
        ImapRequest req = this.connection.newRequest(CAtom.APPEND, new MailboxName(this.mailbox));
        if (mi.flags != null) {
            req.addParam(mi.flags);
        }
        if (mi.date != null) {
            req.addParam(mi.date);
        }
        req.addParam(data);
        ResponseText rt = req.sendCheckStatus().getResponseText();
        if (rt != null && rt.getCCode() == CAtom.APPENDUID && (ar = (AppendResult)rt.getData()).getUid() > 0L) {
            return ar.getUid();
        }
        throw req.failed("APPENDUID supported but UID missing from result");
    }

    private long appendSlow(MessageInfo mi, Literal lit) throws IOException, MessagingException {
        List<Long> found;
        Mailbox mb = this.connection.getMailbox();
        if (this.mdf == null) {
            this.mdf = new MailDateFormat();
        }
        if (mb == null || !this.mailbox.equals(mb.getName())) {
            this.connection.select(this.mailbox);
        }
        long startUid = this.getUidNext();
        this.connection.append(this.mailbox, mi.flags, mi.date, lit);
        if (mi.mm.getSentDate() == null || mi.mm.getMessageID() == null) {
            return -1L;
        }
        long endUid = this.getUidNext() - 1L;
        if (startUid <= endUid && (found = this.findUids(startUid + ":" + endUid, mi)).size() == 1) {
            return found.get(0);
        }
        List<Long> uids = this.connection.uidSearch(this.getSearchParams(mi));
        Iterator<Long> it = uids.iterator();
        while (it.hasNext()) {
            List<Long> found2 = this.findUids(this.nextSeq(it, 5), mi);
            if (found2.size() <= 0) continue;
            return found2.get(0);
        }
        return -1L;
    }

    private Object[] getSearchParams(MessageInfo mi) throws MessagingException {
        ArrayList<Object> params = new ArrayList<Object>();
        String subj = mi.mm.getSubject();
        if (subj != null) {
            ImapData data = ImapData.asString(subj);
            if (data.isLiteral()) {
                params.add("CHARSET");
                params.add("UTF-8");
            }
            params.add("SUBJECT");
            params.add(data);
        }
        params.add("SENTON");
        params.add(mi.mm.getSentDate());
        return params.toArray();
    }

    private String nextSeq(Iterator<Long> it, int count) {
        assert (it.hasNext());
        StringBuilder sb = new StringBuilder();
        sb.append(it.next());
        while (--count > 0 && it.hasNext()) {
            sb.append(',').append(it.next());
        }
        return sb.toString();
    }

    private List<Long> findUids(String seq, MessageInfo mi) throws IOException, MessagingException {
        ArrayList<Long> uids = new ArrayList<Long>(1);
        Map<Long, MessageData> mds = this.connection.uidFetch(seq, (Object)"(RFC822.SIZE ENVELOPE)");
        for (MessageData md : mds.values()) {
            if (!this.matches(mi, md)) continue;
            uids.add(md.getUid());
        }
        return uids;
    }

    private boolean matches(MessageInfo mi, MessageData md) throws IOException, MessagingException {
        if ((long)mi.data.getSize() != md.getRfc822Size()) {
            return false;
        }
        Envelope env = md.getEnvelope();
        if (env == null) {
            return false;
        }
        String subj = mi.mm.getSubject();
        return mi.mm.getSentDate().equals(this.parseDate(env.getDate())) && mi.mm.getMessageID().equals(env.getMessageId()) && (subj == null || subj.equals(env.getSubject()));
    }

    private Date parseDate(String date) {
        if (date != null) {
            try {
                return this.mdf.parse(date);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    private long getUidNext() throws IOException {
        return this.connection.status(this.mailbox, "UIDNEXT").getUidNext();
    }

    private static Data getData(final byte[] b) {
        return new Data(){

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(b);
            }

            public int getSize() {
                return b.length;
            }
        };
    }

    private static interface Data {
        public InputStream getInputStream() throws IOException;

        public int getSize() throws IOException;
    }

    private static class MessageInfo {
        Data data;
        MimeMessage mm;
        Flags flags;
        Date date;

        MessageInfo(Message msg) throws ServiceException {
            final MailboxBlob mblob = msg.getBlob();
            this.data = new Data(){

                public InputStream getInputStream() throws IOException {
                    return StoreManager.getInstance().getContent(mblob);
                }

                public int getSize() throws IOException {
                    return (int)mblob.getSize();
                }
            };
            this.mm = msg.getMimeMessage(false);
            this.flags = SyncUtil.zimbraToImapFlags(msg.getFlagBitmask());
            this.date = SyncUtil.getInternalDate(msg, this.mm);
        }

        MessageInfo(Data data, Flags flags) throws ServiceException, IOException {
            this.data = data;
            InputStream is = data.getInputStream();
            try {
                block4: {
                    try {
                        this.mm = new MimeMessage(null, is);
                        this.flags = flags;
                        this.date = this.mm.getReceivedDate();
                        if (this.date != null) break block4;
                        this.date = new Date(System.currentTimeMillis());
                    }
                    catch (MessagingException e) {
                        throw ServiceException.FAILURE("Unable to parse message", e);
                    }
                }
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                is.close();
                throw throwable;
            }
            is.close();
        }
    }
}

