/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.datasource.DataSourceManager;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.ScheduledTask;

public class DataSourceTask
extends ScheduledTask {
    private static final String KEY_DATA_SOURCE_ID = "dsid";

    public DataSourceTask() {
    }

    public DataSourceTask(long mailboxId, String accountId, String dataSourceId, long intervalMillis) {
        if (StringUtil.isNullOrEmpty(accountId)) {
            throw new IllegalArgumentException("accountId cannot be null or empty");
        }
        if (StringUtil.isNullOrEmpty(dataSourceId)) {
            throw new IllegalArgumentException("dataSourceId cannot be null or empty");
        }
        this.setMailboxId(mailboxId);
        this.setProperty(KEY_DATA_SOURCE_ID, dataSourceId);
        this.setIntervalMillis(intervalMillis);
    }

    public String getName() {
        return this.getDataSourceId();
    }

    public String getDataSourceId() {
        return this.getProperty(KEY_DATA_SOURCE_ID);
    }

    public Void call() throws Exception {
        ZimbraLog.clearContext();
        ZimbraLog.addMboxToContext(this.getMailboxId());
        ZimbraLog.datasource.debug("Running scheduled import for DataSource %s", this.getDataSourceId());
        Mailbox mbox = null;
        try {
            mbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
            Account account = mbox.getAccount();
            ZimbraLog.addAccountNameToContext(account.getName());
            Provisioning prov = Provisioning.getInstance();
            DataSource ds = prov.get(account, Provisioning.DataSourceBy.id, this.getDataSourceId());
            if (ds != null) {
                ZimbraLog.addDataSourceNameToContext(ds.getName());
                if (!ds.isEnabled()) {
                    ZimbraLog.datasource.info("DataSource is disabled.  Cancelling future tasks.");
                    DataSourceManager.cancelTask(mbox, this.getDataSourceId());
                    return null;
                }
                DataSourceManager.importData(ds);
            } else {
                ZimbraLog.datasource.info("DataSource %s was deleted.  Cancelling future tasks.", this.getDataSourceId());
                DataSourceManager.cancelTask(mbox, this.getDataSourceId());
            }
        }
        catch (ServiceException e) {
            ZimbraLog.datasource.warn((Object)"Scheduled DataSource import failed.", e);
            return null;
        }
        ZimbraLog.clearContext();
        return null;
    }
}

