/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.datasource.DataSourceManager;
import com.zimbra.cs.db.DbDataSource;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.Metadata;

public class DataSourceMapping {
    protected DataSource ds;
    protected DbDataSource.DataSourceItem dsi;

    public DataSourceMapping(DataSource ds, DbDataSource.DataSourceItem dsi) throws ServiceException {
        this.ds = ds;
        this.dsi = dsi;
        this.parseMetaData();
    }

    public DataSourceMapping(DataSource ds, int itemId) throws ServiceException {
        this.ds = ds;
        this.dsi = DbDataSource.getMapping(ds, itemId);
        if (this.dsi.remoteId == null) {
            throw MailServiceException.NO_SUCH_ITEM(itemId);
        }
        this.parseMetaData();
    }

    public DataSourceMapping(DataSource ds, String remoteId) throws ServiceException {
        this.ds = ds;
        this.dsi = DbDataSource.getReverseMapping(ds, remoteId);
        if (this.dsi.itemId == 0) {
            throw MailServiceException.NO_SUCH_ITEM(remoteId);
        }
        this.parseMetaData();
    }

    public DataSourceMapping(DataSource ds, int folderId, int itemId, String remoteId) throws ServiceException {
        this.ds = ds;
        this.dsi = new DbDataSource.DataSourceItem(folderId, itemId, remoteId, new Metadata());
    }

    public DataSourceMapping(DataSource ds, int folderId, int itemId, String remoteId, int localFlags) throws ServiceException {
        this.ds = ds;
        this.dsi = new DbDataSource.DataSourceItem(folderId, itemId, remoteId, new Metadata(), localFlags);
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    public DbDataSource.DataSourceItem getDataSourceItem() {
        return this.dsi;
    }

    public int getFolderId() {
        return this.dsi.folderId;
    }

    public int getItemId() {
        return this.dsi.itemId;
    }

    public int getItemFlags() throws ServiceException {
        if (this.dsi.itemFlags == -1) {
            Message localMsg = DataSourceManager.getInstance().getMailbox(this.ds).getMessageById(null, this.dsi.itemId);
            this.dsi.itemFlags = localMsg.getFlagBitmask();
        }
        return this.dsi.itemFlags;
    }

    public String getRemoteId() {
        return this.dsi.remoteId;
    }

    public void setFolderId(int folderId) {
        this.dsi.folderId = folderId;
    }

    public void setItemId(int itemId) {
        this.dsi.itemId = itemId;
    }

    public void setItemFlags(int itemFlags) {
        this.dsi.itemFlags = itemFlags;
    }

    public void setRemoteId(String remoteId) {
        this.dsi.remoteId = remoteId;
    }

    public void add() throws ServiceException {
        DbDataSource.addMapping(this.ds, this.dsi);
    }

    public void delete() throws ServiceException {
        DbDataSource.deleteMapping(this.ds, this.dsi.itemId);
    }

    public void set() throws ServiceException {
        try {
            DbDataSource.addMapping(this.ds, this.dsi);
        }
        catch (Exception e) {
            this.delete();
            DbDataSource.addMapping(this.ds, this.dsi);
        }
    }

    public void update() throws ServiceException {
        DbDataSource.updateMapping(this.ds, this.dsi);
    }

    protected void parseMetaData() throws ServiceException {
    }
}

