/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.datasource.CalDavDataImport;
import com.zimbra.cs.datasource.DataSourceTask;
import com.zimbra.cs.datasource.ImapSync;
import com.zimbra.cs.datasource.ImportStatus;
import com.zimbra.cs.datasource.Pop3Sync;
import com.zimbra.cs.datasource.RssImport;
import com.zimbra.cs.db.DbMailbox;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.db.DbScheduledTask;
import com.zimbra.cs.extension.ExtensionUtil;
import com.zimbra.cs.gal.GalImport;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.ScheduledTaskManager;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceManager {
    private static DataSourceManager sInstance;
    private static final Map<String, Map<String, ImportStatus>> sImportStatus;
    private static final ConcurrentMap<Object, Boolean> sManagedDataSources;

    private static Object key(String accountId, String dataSourceId) {
        return new Pair<String, String>(accountId, dataSourceId);
    }

    public static void addManaged(DataSource ds) {
        sManagedDataSources.putIfAbsent(DataSourceManager.key(ds.getAccountId(), ds.getId()), true);
    }

    public static void deleteManaged(String accountId, String dataSourceId) {
        sManagedDataSources.remove(DataSourceManager.key(accountId, dataSourceId));
    }

    public static boolean isManaged(DataSource ds) {
        return sManagedDataSources.containsKey(DataSourceManager.key(ds.getAccountId(), ds.getId()));
    }

    public boolean isSyncCapable(DataSource ds, Folder folder) {
        return true;
    }

    public boolean isSyncEnabled(DataSource ds, Folder folder) {
        return true;
    }

    public static DataSourceManager getInstance() {
        if (sInstance == null) {
            String className = LC.zimbra_class_datasourcemanager.value();
            if (!StringUtil.isNullOrEmpty(className)) {
                try {
                    try {
                        sInstance = (DataSourceManager)Class.forName(className).newInstance();
                    }
                    catch (ClassNotFoundException cnfe) {
                        sInstance = (DataSourceManager)ExtensionUtil.findClass(className).newInstance();
                    }
                }
                catch (Exception e) {
                    ZimbraLog.system.error("Unable to initialize %s.", (Object)className, e);
                }
            }
            if (sInstance == null) {
                sInstance = new DataSourceManager();
                ZimbraLog.datasource.info("Initialized %s.", sInstance.getClass().getName());
            }
        }
        return sInstance;
    }

    public Mailbox getMailbox(DataSource ds) throws ServiceException {
        return MailboxManager.getInstance().getMailboxByAccount(ds.getAccount());
    }

    public DataSource.DataImport getDataImport(DataSource ds) throws ServiceException {
        switch (ds.getType()) {
            case pop3: {
                return new Pop3Sync(ds);
            }
            case imap: {
                return new ImapSync(ds);
            }
            case caldav: {
                return new CalDavDataImport(ds);
            }
            case rss: 
            case cal: {
                return new RssImport(ds);
            }
            case gal: {
                return new GalImport(ds);
            }
            case xsync: {
                try {
                    String className = LC.data_source_xsync_class.value();
                    if (className != null && className.length() > 0) {
                        Class<?> cmdClass = Class.forName(className);
                        Constructor<?> constructor = cmdClass.getConstructor(DataSource.class);
                        return (DataSource.DataImport)constructor.newInstance(ds);
                    }
                    break;
                }
                catch (Exception x) {
                    ZimbraLog.datasource.warn("Failed instantiating xsync class: %s", (Object)ds, x);
                }
            }
        }
        throw new IllegalArgumentException("Unknown data import type: " + (Object)((Object)ds.getType()));
    }

    public static String getDefaultImportClass(DataSource.Type ds) {
        switch (ds) {
            case caldav: {
                return CalDavDataImport.class.getName();
            }
            case gal: {
                return GalImport.class.getName();
            }
        }
        return null;
    }

    public static void test(DataSource ds) throws ServiceException {
        ZimbraLog.datasource.info("Testing: %s", ds);
        try {
            DataSource.DataImport di = DataSourceManager.getInstance().getDataImport(ds);
            di.test();
            ZimbraLog.datasource.info("Test succeeded: %s", ds);
        }
        catch (ServiceException x) {
            ZimbraLog.datasource.warn("Test failed: %s", (Object)ds, x);
            throw x;
        }
    }

    public static List<ImportStatus> getImportStatus(Account account) throws ServiceException {
        List<DataSource> dsList = Provisioning.getInstance().getAllDataSources(account);
        ArrayList<ImportStatus> allStatus = new ArrayList<ImportStatus>();
        for (DataSource ds : dsList) {
            allStatus.add(DataSourceManager.getImportStatus(account, ds));
        }
        return allStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImportStatus getImportStatus(Account account, DataSource ds) {
        ImportStatus importStatus;
        Map<String, Map<String, ImportStatus>> map = sImportStatus;
        synchronized (map) {
            Map<String, ImportStatus> isMap = sImportStatus.get(account.getId());
            if (isMap == null) {
                isMap = new HashMap<String, ImportStatus>();
                sImportStatus.put(account.getId(), isMap);
            }
            if ((importStatus = isMap.get(ds.getId())) == null) {
                importStatus = new ImportStatus(ds.getId());
                isMap.put(ds.getId(), importStatus);
            }
        }
        return importStatus;
    }

    public static void importData(DataSource ds) throws ServiceException {
        DataSourceManager.importData(ds, null, true);
    }

    public static void importData(DataSource fs, boolean fullSync) throws ServiceException {
        DataSourceManager.importData(fs, null, fullSync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void importData(DataSource ds, List<Integer> folderIds, boolean fullSync) throws ServiceException {
        ImportStatus importStatus;
        ImportStatus importStatus2 = importStatus = DataSourceManager.getImportStatus(ds.getAccount(), ds);
        synchronized (importStatus2) {
            if (importStatus.isRunning()) {
                ZimbraLog.datasource.info("Attempted to start import while  an import process was already running.  Ignoring the second request.");
                return;
            }
            if (DataSourceManager.getInstance().getMailbox(ds).getMailboxLock() != null) {
                ZimbraLog.datasource.info("Mailbox is in maintenance mode. Skipping import.");
                return;
            }
            importStatus.mHasRun = true;
            importStatus.mIsRunning = true;
            importStatus.mSuccess = false;
            importStatus.mError = null;
        }
        boolean success = false;
        String error = null;
        DataSourceManager.addManaged(ds);
        try {
            try {
                ZimbraLog.datasource.info("Importing data for data source '%s'", ds.getName());
                DataSourceManager.getInstance().getDataImport(ds).importData(folderIds, fullSync);
                success = true;
                DataSourceManager.resetErrorStatus(ds);
            }
            catch (ServiceException x) {
                error = DataSourceManager.generateErrorMessage(x);
                DataSourceManager.setErrorStatus(ds, error);
                throw x;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ZimbraLog.datasource.info("Import completed for data source '%s'", ds.getName());
            ImportStatus importStatus4 = importStatus;
            synchronized (importStatus4) {
                importStatus.mSuccess = success;
                importStatus.mError = error;
                importStatus.mIsRunning = false;
                throw throwable;
            }
        }
        ZimbraLog.datasource.info("Import completed for data source '%s'", ds.getName());
        ImportStatus importStatus3 = importStatus;
        synchronized (importStatus3) {
            importStatus.mSuccess = success;
            importStatus.mError = error;
            importStatus.mIsRunning = false;
            return;
        }
    }

    public static void resetErrorStatus(DataSource ds) {
        if (ds.getAttr("zimbraDataSourceFailingSince") != null || ds.getAttr("zimbraDataSourceLastError") != null) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            attrs.put("zimbraDataSourceFailingSince", null);
            attrs.put("zimbraDataSourceLastError", null);
            try {
                Provisioning.getInstance().modifyAttrs(ds, attrs);
            }
            catch (ServiceException e) {
                ZimbraLog.datasource.warn("Unable to reset error status for data source %s.", ds.getName());
            }
        }
    }

    private static void setErrorStatus(DataSource ds, String error) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDataSourceLastError", error);
        if (ds.getAttr("zimbraDataSourceFailingSince") == null) {
            attrs.put("zimbraDataSourceFailingSince", DateUtil.toGeneralizedTime(new Date()));
        }
        try {
            Provisioning.getInstance().modifyAttrs(ds, attrs);
        }
        catch (ServiceException e) {
            ZimbraLog.datasource.warn("Unable to set error status for data source %s.", ds.getName());
        }
    }

    private static String generateErrorMessage(Throwable t) {
        StringBuilder buf = new StringBuilder();
        boolean isFirst = true;
        while (t != null) {
            String msg;
            if (t.getClass().getName().startsWith("javax.mail.")) {
                msg = t.getMessage();
                if (msg == null) {
                    msg = t.toString();
                }
                return msg;
            }
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(", ");
            }
            msg = t.getMessage();
            if (msg == null) {
                msg = t.toString();
            }
            buf.append(msg);
            t = t.getCause();
        }
        return buf.toString();
    }

    static void cancelTask(Mailbox mbox, String dsId) throws ServiceException {
        ScheduledTaskManager.cancel(DataSourceTask.class.getName(), dsId, mbox.getId(), false);
        DbScheduledTask.deleteTask(DataSourceTask.class.getName(), dsId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateSchedule(String accountId, String dsId) throws ServiceException {
        if (!LC.data_source_scheduling_enabled.booleanValue()) {
            return;
        }
        ZimbraLog.datasource.debug("Updating schedule for account %s, data source %s", accountId, dsId);
        Provisioning prov = Provisioning.getInstance();
        Account account = prov.get(Provisioning.AccountBy.id, accountId);
        if (account == null) {
            ZimbraLog.datasource.info("Account %s was deleted for data source %s.  Deleting scheduled task.", accountId, dsId);
            DbScheduledTask.deleteTask(DataSourceTask.class.getName(), dsId);
            DataSourceManager.deleteManaged(accountId, dsId);
            return;
        }
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account, false);
        if (mbox == null) {
            return;
        }
        DataSource ds = prov.get(account, Provisioning.DataSourceBy.id, dsId);
        if (ds == null) {
            ZimbraLog.datasource.info("Data source %s was deleted.  Deleting scheduled task.", dsId);
            ScheduledTaskManager.cancel(DataSourceTask.class.getName(), dsId, mbox.getId(), false);
            DbScheduledTask.deleteTask(DataSourceTask.class.getName(), dsId);
            DataSourceManager.deleteManaged(accountId, dsId);
            return;
        }
        if (!ds.isEnabled()) {
            ZimbraLog.datasource.info("Data source %s is disabled.  Deleting scheduled task.", dsId);
            ScheduledTaskManager.cancel(DataSourceTask.class.getName(), dsId, mbox.getId(), false);
            DbScheduledTask.deleteTask(DataSourceTask.class.getName(), dsId);
            return;
        }
        ZimbraLog.datasource.info("Updating schedule for data source %s", ds.getName());
        Object object = DbMailbox.getSynchronizer();
        synchronized (object) {
            block12: {
                DbPool.Connection conn = null;
                try {
                    try {
                        conn = DbPool.getConnection();
                        ScheduledTaskManager.cancel(conn, DataSourceTask.class.getName(), ds.getId(), mbox.getId(), false);
                        if (ds.isScheduled()) {
                            DataSourceTask task = new DataSourceTask(mbox.getId(), accountId, dsId, ds.getPollingInterval());
                            ZimbraLog.datasource.debug("Scheduling %s", task);
                            ScheduledTaskManager.schedule(conn, task);
                        }
                        conn.commit();
                    }
                    catch (ServiceException e) {
                        ZimbraLog.datasource.warn("Unable to schedule data source %s", (Object)ds.getName(), e);
                        DbPool.quietRollback(conn);
                        Object var10_11 = null;
                        DbPool.quietClose(conn);
                        break block12;
                    }
                    Object var10_10 = null;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    DbPool.quietClose(conn);
                    throw throwable;
                }
                DbPool.quietClose(conn);
            }
            return;
        }
    }

    static {
        sImportStatus = new HashMap<String, Map<String, ImportStatus>>();
        sManagedDataSources = new ConcurrentHashMap<Object, Boolean>();
    }
}

