/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.datasource.DataSourceMapping;
import com.zimbra.cs.db.DbDataSource;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceFolderMapping
extends DataSourceMapping {
    public DataSourceFolderMapping(DataSource ds, DbDataSource.DataSourceItem dsi) throws ServiceException {
        super(ds, dsi);
    }

    public DataSourceFolderMapping(DataSource ds, int itemId) throws ServiceException {
        super(ds, itemId);
    }

    public DataSourceFolderMapping(DataSource ds, String remoteId) throws ServiceException {
        super(ds, remoteId);
    }

    public DataSourceFolderMapping(DataSource ds, int itemId, String remoteId) throws ServiceException {
        super(ds, ds.getFolderId(), itemId, remoteId);
    }

    @Override
    public void delete() throws ServiceException {
        DataSourceFolderMapping.deleteMappings(this.ds, this.dsi.itemId);
        super.delete();
    }

    public void deleteMappings() throws ServiceException {
        DataSourceFolderMapping.deleteMappings(this.ds, this.dsi.itemId);
    }

    public static void deleteMappings(DataSource ds, int itemId) throws ServiceException {
        DbDataSource.deleteAllMappingsInFolder(ds, itemId);
    }

    public Collection<DbDataSource.DataSourceItem> getMappings() throws ServiceException {
        return DataSourceFolderMapping.getMappings(this.ds, this.dsi.itemId);
    }

    public Collection<DbDataSource.DataSourceItem> getMappingsAndFlags() throws ServiceException {
        return DataSourceFolderMapping.getMappingsAndFlags(this.ds, this.dsi.itemId);
    }

    public static Collection<DbDataSource.DataSourceItem> getMappings(DataSource ds, int folderId) throws ServiceException {
        return DbDataSource.getAllMappingsInFolder(ds, folderId);
    }

    public static Collection<DbDataSource.DataSourceItem> getMappingsAndFlags(DataSource ds, int folderId) throws ServiceException {
        return DbDataSource.getAllMappingsAndFlagsInFolder(ds, folderId);
    }

    @Override
    protected void parseMetaData() throws ServiceException {
    }
}

