/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.datasource;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.datasource.MailItemImport;
import com.zimbra.cs.dav.DavElements;
import com.zimbra.cs.dav.DavException;
import com.zimbra.cs.dav.client.CalDavClient;
import com.zimbra.cs.dav.client.DavObject;
import com.zimbra.cs.dav.client.DavRequest;
import com.zimbra.cs.db.DbDataSource;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalDavDataImport
extends MailItemImport {
    private static final String METADATA_KEY_TYPE = "t";
    private static final String METADATA_TYPE_FOLDER = "f";
    private static final String METADATA_TYPE_APPOINTMENT = "a";
    private static final String METADATA_KEY_ETAG = "e";
    private static final String METADATA_KEY_CTAG = "c";
    private static final int DEFAULT_FOLDER_FLAGS = Flag.flagsToBitmask("#");
    private CalDavClient mClient;

    public CalDavDataImport(DataSource ds) throws ServiceException {
        super(ds);
    }

    @Override
    public void importData(List<Integer> folderIds, boolean fullSync) throws ServiceException {
        ArrayList<Object> folders = new ArrayList();
        try {
            this.mbox.beginTrackingSync();
            if (folderIds != null) {
                for (int fid : folderIds) {
                    folders.add(new CalendarFolder(fid));
                }
            } else {
                folders = this.syncFolders();
            }
            OperationContext octxt = new OperationContext(this.mbox);
            for (CalendarFolder calendarFolder : folders) {
                calendarFolder.folder = this.mbox.getFolderById(octxt, calendarFolder.id);
                if (calendarFolder.folder.getDefaultView() != 11) continue;
                this.sync(octxt, calendarFolder);
            }
        }
        catch (DavException e) {
            throw ServiceException.FAILURE("error importing CalDAV data", e);
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("error importing CalDAV data", e);
        }
    }

    @Override
    public void test() throws ServiceException {
        this.mClient = new CalDavClient(this.getTargetUrl());
        this.mClient.setAppName(this.getAppName());
        this.mClient.setCredential(this.getUsername(), this.getDecryptedPassword());
        this.mClient.setDebugEnabled(this.dataSource.isDebugTraceEnabled());
        try {
            this.mClient.login(this.getPrincipalUrl());
        }
        catch (Exception x) {
            throw ServiceException.FAILURE(x.getMessage(), x);
        }
    }

    protected String getUsername() {
        return this.getDataSource().getUsername();
    }

    protected String getDecryptedPassword() throws ServiceException {
        return this.getDataSource().getDecryptedPassword();
    }

    protected byte getDefaultColor() {
        return 0;
    }

    protected String getPrincipalUrl() {
        String[] attrs;
        DataSource ds = this.getDataSource();
        for (String a : attrs = ds.getMultiAttr("zimbraDataSourceAttribute")) {
            if (!a.startsWith("p:")) continue;
            return a.substring(2).replaceAll("_USERNAME_", this.getUsername());
        }
        return null;
    }

    protected String getTargetUrl() {
        DataSource ds = this.getDataSource();
        DataSource.ConnectionType ctype = ds.getConnectionType();
        StringBuilder url = new StringBuilder();
        switch (ctype) {
            case ssl: {
                url.append("https://");
                break;
            }
            default: {
                url.append("http://");
            }
        }
        url.append(ds.getHost()).append(":").append(ds.getPort());
        return url.toString();
    }

    protected String getAppName() {
        return "ZCS";
    }

    private CalDavClient getClient() throws ServiceException, IOException, DavException {
        if (this.mClient == null) {
            this.mClient = new CalDavClient(this.getTargetUrl());
            this.mClient.setAppName(this.getAppName());
            this.mClient.setCredential(this.getUsername(), this.getDecryptedPassword());
            this.mClient.setDebugEnabled(this.dataSource.isDebugTraceEnabled());
            this.mClient.login(this.getPrincipalUrl());
        }
        return this.mClient;
    }

    protected int getRootFolderId(DataSource ds) throws ServiceException {
        return ds.getFolderId();
    }

    protected HashMap<String, DbDataSource.DataSourceItem> getAllFolderMappings(DataSource ds) throws ServiceException {
        Collection<DbDataSource.DataSourceItem> allFolders = DbDataSource.getAllMappingsInFolder(ds, this.getRootFolderId(ds));
        HashMap<String, DbDataSource.DataSourceItem> folders = new HashMap<String, DbDataSource.DataSourceItem>();
        for (DbDataSource.DataSourceItem f : allFolders) {
            if (f.remoteId == null) continue;
            folders.put(f.remoteId, f);
        }
        return folders;
    }

    private ArrayList<CalendarFolder> syncFolders() throws ServiceException, IOException, DavException {
        ArrayList<CalendarFolder> ret = new ArrayList<CalendarFolder>();
        DataSource ds = this.getDataSource();
        CalDavClient client = this.getClient();
        Map<String, DavObject> calendars = client.getCalendars();
        OperationContext octxt = new OperationContext(this.mbox);
        Folder rootFolder = this.mbox.getFolderById(octxt, this.getRootFolderId(ds));
        HashMap<String, DbDataSource.DataSourceItem> allFolders = this.getAllFolderMappings(ds);
        ArrayList<Integer> deleted = new ArrayList<Integer>();
        int lastSync = (int)rootFolder.getLastSyncDate();
        Iterator<Object> i$ = this.mbox.getTombstones(lastSync).getAll().iterator();
        while (i$.hasNext()) {
            int itemId = i$.next();
            deleted.add(itemId);
        }
        for (String name : calendars.keySet()) {
            DavObject obj = calendars.get(name);
            String ctag = obj.getPropertyText(DavElements.E_GETCTAG);
            String url = obj.getHref();
            DbDataSource.DataSourceItem f = allFolders.get(url);
            if (f == null) {
                f = new DbDataSource.DataSourceItem(0, 0, url, null);
            }
            CalendarFolder cf = new CalendarFolder(f.itemId);
            ret.add(cf);
            MailItem folder = null;
            if (f.itemId != 0) {
                if (deleted.contains(f.itemId)) {
                    allFolders.remove(url);
                    DbDataSource.deleteMapping(ds, f.itemId);
                    DbDataSource.deleteAllMappingsInFolder(ds, f.itemId);
                    this.deleteRemoteFolder(url);
                    continue;
                }
                try {
                    folder = this.mbox.getFolderById(octxt, f.itemId);
                }
                catch (ServiceException se) {
                    if (se.getCode() != "mail.NO_SUCH_FOLDER") {
                        throw se;
                    }
                    f.itemId = 0;
                }
            }
            if (f.itemId == 0) {
                try {
                    folder = this.mbox.getFolderByName(octxt, rootFolder.getId(), name);
                    if (((Folder)folder).getDefaultView() != 11) {
                        name = name + " (" + this.getDataSource().getName() + ")";
                        folder = null;
                    }
                }
                catch (MailServiceException.NoSuchItemException e) {
                    // empty catch block
                }
                if (folder == null) {
                    folder = this.mbox.createFolder(octxt, name, rootFolder.getId(), (byte)11, DEFAULT_FOLDER_FLAGS, this.getDefaultColor(), null);
                }
                f.itemId = folder.getId();
                f.folderId = folder.getFolderId();
                f.md = new Metadata();
                f.md.put(METADATA_KEY_TYPE, METADATA_TYPE_FOLDER);
                if (ctag != null) {
                    f.md.put(METADATA_KEY_CTAG, ctag);
                }
                f.remoteId = url;
                cf.id = f.itemId;
                this.mbox.setSyncDate(octxt, folder.getId(), this.mbox.getLastChangeID());
                DbDataSource.addMapping(ds, f);
            } else if (f.md == null) {
                ZimbraLog.datasource.warn("syncFolders: empty metadata for item %d", f.itemId);
                f.folderId = folder.getFolderId();
                f.remoteId = url;
                f.md = new Metadata();
                f.md.put(METADATA_KEY_TYPE, METADATA_TYPE_FOLDER);
                if (ctag != null) {
                    f.md.put(METADATA_KEY_CTAG, ctag);
                }
                DbDataSource.addMapping(ds, f);
            } else if (ctag != null) {
                String oldctag = f.md.get(METADATA_KEY_CTAG, null);
                if (ctag.equals(oldctag)) {
                    cf.ctagMatched = true;
                } else {
                    f.md.put(METADATA_KEY_CTAG, ctag);
                    DbDataSource.updateMapping(ds, f);
                }
            }
            String fname = folder.getName();
            if (!fname.equals(name)) {
                ZimbraLog.datasource.warn("renaming folder %s to %s", fname, name);
                try {
                    this.mbox.rename(octxt, f.itemId, (byte)1, name, folder.getFolderId());
                }
                catch (ServiceException e) {
                    ZimbraLog.datasource.warn((Object)"folder rename failed", e);
                }
            }
            allFolders.remove(url);
        }
        if (!allFolders.isEmpty()) {
            ArrayList<Integer> fids = new ArrayList<Integer>();
            int[] fidArray = new int[allFolders.size()];
            int i = 0;
            for (DbDataSource.DataSourceItem f : allFolders.values()) {
                Folder folder = this.mbox.getFolderById(octxt, f.itemId);
                if (folder != null && folder.getDefaultView() != 11 && folder.getDefaultView() != 15) continue;
                fids.add(f.itemId);
                fidArray[i++] = f.itemId;
                DbDataSource.deleteAllMappingsInFolder(ds, f.itemId);
            }
            if (!fids.isEmpty()) {
                DbDataSource.deleteMappings(ds, fids);
                try {
                    this.mbox.delete(octxt, fidArray, (byte)1, null);
                }
                catch (ServiceException e) {
                    ZimbraLog.datasource.warn((Object)"folder delete failed", e);
                }
            }
        }
        return ret;
    }

    private void deleteRemoteFolder(String url) throws ServiceException, IOException, DavException {
        ZimbraLog.datasource.debug("deleteRemoteFolder: deleting remote folder %s", url);
        this.getClient().sendRequest(DavRequest.DELETE(url));
    }

    private boolean pushDelete(Collection<Integer> itemIds) throws ServiceException, IOException, DavException {
        DataSource ds = this.getDataSource();
        boolean deleted = false;
        ArrayList<Integer> toDelete = new ArrayList<Integer>();
        for (int itemId : itemIds) {
            try {
                this.deleteRemoteItem(DbDataSource.getMapping(ds, itemId));
                toDelete.add(itemId);
            }
            catch (Exception e) {
                ZimbraLog.datasource.warn((Object)("pushDelete: can't delete remote item for item " + itemId), e);
            }
        }
        if (toDelete.size() > 0) {
            DbDataSource.deleteMappings(ds, toDelete);
            deleted = true;
        }
        return deleted;
    }

    private void deleteRemoteItem(DbDataSource.DataSourceItem item) throws ServiceException, IOException, DavException {
        if (item.itemId <= 0 || item.md == null) {
            ZimbraLog.datasource.warn("pushDelete: empty item %d", item.itemId);
            return;
        }
        String type = item.md.get(METADATA_KEY_TYPE, null);
        if (type == null || !type.equals(METADATA_TYPE_APPOINTMENT)) {
            return;
        }
        String uri = item.remoteId;
        if (uri == null) {
            ZimbraLog.datasource.warn("pushDelete: empty uri for item %d", item.itemId);
            return;
        }
        if (METADATA_TYPE_FOLDER.equals(type)) {
            ZimbraLog.datasource.debug("pushDelete: deleting remote folder %s", uri);
            this.getClient().sendRequest(DavRequest.DELETE(uri));
        } else if (METADATA_TYPE_APPOINTMENT.equals(type)) {
            ZimbraLog.datasource.debug("pushDelete: deleting remote appointment %s", uri);
            this.getClient().sendRequest(DavRequest.DELETE(uri));
        } else {
            ZimbraLog.datasource.warn("pushDelete: unrecognized item type for %d: %s", item.itemId, type);
        }
    }

    private String createTargetUrl(MailItem mitem) throws ServiceException {
        DbDataSource.DataSourceItem folder = DbDataSource.getMapping(this.getDataSource(), mitem.getFolderId());
        String url = folder.remoteId;
        switch (mitem.getType()) {
            case 11: {
                url = url + ((CalendarItem)mitem).getUid() + ".ics";
                break;
            }
            default: {
                String name = mitem.getName();
                url = name != null ? url + name : url + mitem.getSubject();
            }
        }
        return url;
    }

    private void pushModify(MailItem mitem) throws ServiceException, IOException, DavException {
        String type;
        int itemId = mitem.getId();
        DataSource ds = this.getDataSource();
        DbDataSource.DataSourceItem item = DbDataSource.getMapping(ds, itemId);
        boolean isCreate = false;
        if (item.remoteId == null) {
            item.md = new Metadata();
            item.md.put(METADATA_KEY_TYPE, METADATA_TYPE_APPOINTMENT);
            item.remoteId = this.createTargetUrl(mitem);
            item.folderId = mitem.getFolderId();
            isCreate = true;
        }
        if (METADATA_TYPE_FOLDER.equals(type = item.md.get(METADATA_KEY_TYPE))) {
            if (mitem.getType() != 1) {
                ZimbraLog.datasource.warn("pushModify: item type doesn't match in metadata for item %d", itemId);
                return;
            }
        } else if (METADATA_TYPE_APPOINTMENT.equals(type)) {
            if (mitem.getType() != 11) {
                ZimbraLog.datasource.warn("pushModify: item type doesn't match in metadata for item %d", itemId);
                return;
            }
            ZimbraLog.datasource.debug("pushModify: sending appointment %s", item.remoteId);
            String etag = this.putAppointment((CalendarItem)mitem, item);
            if (etag == null) {
                CalDavClient.Appointment appt = this.mClient.getEtag(item.remoteId);
                etag = appt.etag;
            }
            item.md.put(METADATA_KEY_ETAG, etag);
            if (isCreate) {
                DbDataSource.addMapping(ds, item);
            } else {
                DbDataSource.updateMapping(ds, item);
            }
        } else {
            ZimbraLog.datasource.warn("pushModify: unrecognized item type for %d: %s", itemId, type);
            return;
        }
    }

    private String putAppointment(CalendarItem calItem, DbDataSource.DataSourceItem dsItem) throws ServiceException, IOException, DavException {
        StringBuilder buf = new StringBuilder();
        ArrayList<String> recipients = new ArrayList<String>();
        buf.append("BEGIN:VCALENDAR\r\n");
        buf.append("VERSION:").append("2.0").append("\r\n");
        buf.append("PRODID:").append("Zimbra-Calendar-Provider").append("\r\n");
        Iterator<ICalTimeZone> iter = calItem.getTimeZoneMap().tzIterator();
        while (iter.hasNext()) {
            ICalTimeZone tz = iter.next();
            CharArrayWriter wr = new CharArrayWriter();
            tz.newToVTimeZone().toICalendar(wr, true);
            wr.flush();
            buf.append(wr.toCharArray());
            wr.close();
        }
        boolean appleICalExdateHack = LC.calendar_apple_ical_compatible_canceled_instances.booleanValue();
        ZCalendar.ZComponent[] vcomps = Invite.toVComponents(calItem.getInvites(), true, false, appleICalExdateHack);
        if (vcomps != null) {
            CharArrayWriter wr = new CharArrayWriter();
            for (ZCalendar.ZComponent vcomp : vcomps) {
                ZCalendar.ZProperty organizer = vcomp.getProperty(ZCalendar.ICalTok.ORGANIZER);
                if (organizer != null) {
                    organizer.setValue(this.getUsername());
                }
                vcomp.toICalendar(wr, true);
            }
            wr.flush();
            buf.append(wr.toCharArray());
            wr.close();
        }
        buf.append("END:VCALENDAR\r\n");
        String etag = dsItem.md.get(METADATA_KEY_ETAG, null);
        if (recipients.isEmpty()) {
            recipients = null;
        }
        CalDavClient.Appointment appt = new CalDavClient.Appointment(dsItem.remoteId, etag, buf.toString(), recipients);
        return this.getClient().sendCalendarData(appt);
    }

    private List<RemoteItem> getRemoteItems(Folder folder) throws ServiceException, IOException, DavException {
        ZimbraLog.datasource.debug("Refresh folder %s", folder.getPath());
        DataSource ds = this.getDataSource();
        DbDataSource.DataSourceItem item = DbDataSource.getMapping(ds, folder.getId());
        if (item.md == null) {
            throw ServiceException.FAILURE("Mapping for folder " + folder.getPath() + " not found", null);
        }
        HashMap<String, DbDataSource.DataSourceItem> allItems = new HashMap<String, DbDataSource.DataSourceItem>();
        for (DbDataSource.DataSourceItem localItem : DbDataSource.getAllMappingsInFolder(this.getDataSource(), folder.getId())) {
            allItems.put(localItem.remoteId, localItem);
        }
        ArrayList<RemoteItem> ret = new ArrayList<RemoteItem>();
        CalDavClient client = this.getClient();
        Collection<CalDavClient.Appointment> appts = client.getEtags(item.remoteId);
        for (CalDavClient.Appointment a : appts) {
            ret.add(new RemoteCalendarItem(a.href, a.etag));
            allItems.remove(a.href);
        }
        ArrayList<Integer> deletedIds = new ArrayList<Integer>();
        for (DbDataSource.DataSourceItem deletedItem : allItems.values()) {
            RemoteCalendarItem rci = new RemoteCalendarItem(deletedItem.remoteId, null);
            rci.status = Status.deleted;
            rci.itemId = deletedItem.itemId;
            ret.add(rci);
            deletedIds.add(deletedItem.itemId);
            ZimbraLog.datasource.debug("deleting: %d (%s) ", deletedItem.itemId, deletedItem.remoteId);
        }
        if (!deletedIds.isEmpty()) {
            DbDataSource.deleteMappings(ds, deletedIds);
        }
        return ret;
    }

    private MailItem applyRemoteItem(RemoteItem remoteItem, Folder where) throws ServiceException, IOException {
        if (!(remoteItem instanceof RemoteCalendarItem)) {
            ZimbraLog.datasource.warn("applyRemoteItem: not a calendar item: %s", remoteItem);
            return null;
        }
        RemoteCalendarItem item = (RemoteCalendarItem)remoteItem;
        DataSource ds = this.getDataSource();
        DbDataSource.DataSourceItem dsItem = DbDataSource.getReverseMapping(ds, item.href);
        OperationContext octxt = new OperationContext(this.mbox);
        MailItem mi = null;
        boolean isStale = false;
        boolean isCreate = false;
        if (dsItem.md == null && item.status != Status.deleted) {
            dsItem.md = new Metadata();
            dsItem.md.put(METADATA_KEY_TYPE, METADATA_TYPE_APPOINTMENT);
        }
        if (dsItem.itemId == 0) {
            isStale = true;
            isCreate = true;
        } else {
            String etag = dsItem.md.get(METADATA_KEY_ETAG, null);
            try {
                mi = this.mbox.getItemById(octxt, dsItem.itemId, (byte)-1);
            }
            catch (MailServiceException.NoSuchItemException se) {
                ZimbraLog.datasource.warn("applyRemoteItem: calendar item not found: ", remoteItem);
            }
            if (item.etag == null) {
                ZimbraLog.datasource.warn("No Etag returned for item %s", item.href);
                isStale = true;
            } else if (etag == null) {
                ZimbraLog.datasource.warn("Empty etag for item %d", dsItem.itemId);
                isStale = true;
            } else {
                boolean bl = isStale = !item.etag.equals(etag);
            }
            if (mi == null) {
                isStale = true;
            }
        }
        if (item.status == Status.deleted) {
            ZimbraLog.datasource.debug("Deleting appointment %s", item.href);
            try {
                mi = this.mbox.getItemById(octxt, item.itemId, (byte)-1);
            }
            catch (MailServiceException.NoSuchItemException se) {
                mi = null;
            }
            try {
                this.mbox.delete(octxt, item.itemId, (byte)-1);
            }
            catch (ServiceException se) {
                ZimbraLog.datasource.warn("Error deleting remotely deleted item %d (%s)", item.itemId, dsItem.remoteId);
            }
        } else if (isStale) {
            ZimbraLog.datasource.debug("Updating stale appointment %s", item.href);
            Mailbox.SetCalendarItemData main = new Mailbox.SetCalendarItemData();
            Mailbox.SetCalendarItemData[] exceptions = null;
            CalDavClient client = null;
            try {
                client = this.getClient();
            }
            catch (DavException e) {
                throw ServiceException.FAILURE("error creating CalDAV client", e);
            }
            CalDavClient.Appointment appt = client.getCalendarData(new CalDavClient.Appointment(item.href, item.etag));
            if (appt.data == null) {
                ZimbraLog.datasource.warn("No appointment found at " + item.href);
                return null;
            }
            dsItem.md.put(METADATA_KEY_ETAG, appt.etag);
            try {
                ZCalendar.ZVCalendar vcalendar = ZCalendar.ZCalendarBuilder.build(appt.data);
                List<Invite> invites = Invite.createFromCalendar(this.mbox.getAccount(), null, vcalendar, true);
                if (invites.size() > 1) {
                    exceptions = new Mailbox.SetCalendarItemData[invites.size() - 1];
                }
                int pos = 0;
                boolean first = true;
                for (Invite i : invites) {
                    if (first) {
                        main.mInv = i;
                        first = false;
                        continue;
                    }
                    Mailbox.SetCalendarItemData scid = new Mailbox.SetCalendarItemData();
                    scid.mInv = i;
                    exceptions[pos++] = scid;
                }
            }
            catch (Exception e) {
                ZimbraLog.datasource.warn((Object)"Error parsing appointment ", e);
                return null;
            }
            mi = this.mbox.setCalendarItem(octxt, where.getId(), 0, 0L, main, exceptions, null, 0L);
            dsItem.itemId = mi.getId();
            dsItem.folderId = mi.getFolderId();
            if (isCreate) {
                DbDataSource.addMapping(ds, dsItem);
            } else {
                DbDataSource.updateMapping(ds, dsItem);
            }
        } else {
            ZimbraLog.datasource.debug("Appointment up to date %s", item.href);
            try {
                mi = this.mbox.getItemById(octxt, dsItem.itemId, (byte)-1);
            }
            catch (MailServiceException.NoSuchItemException se) {
                ArrayList<Integer> deletedIds = new ArrayList<Integer>();
                deletedIds.add(dsItem.itemId);
                DbDataSource.deleteMappings(ds, deletedIds);
            }
        }
        return mi;
    }

    private void sync(OperationContext octxt, CalendarFolder cf) throws ServiceException, IOException, DavException {
        int lastSync;
        Folder syncFolder = cf.folder;
        int currentSync = lastSync = (int)syncFolder.getLastSyncDate();
        boolean allDone = false;
        HashMap<Integer, Integer> modifiedFromRemote = new HashMap<Integer, Integer>();
        ArrayList<Integer> deletedFromRemote = new ArrayList<Integer>();
        while (!allDone) {
            allDone = true;
            ArrayList<Integer> deleted = new ArrayList<Integer>();
            for (int itemId : this.mbox.getTombstones(lastSync).getAll()) {
                if (deletedFromRemote.contains(itemId)) continue;
                deleted.add(itemId);
            }
            HashSet<Integer> fid = new HashSet<Integer>();
            fid.add(3);
            List<Integer> trashed = this.mbox.getModifiedItems(octxt, lastSync, (byte)-1, fid).getFirst();
            deleted.addAll(trashed);
            if (!deleted.isEmpty()) {
                allDone &= !this.pushDelete(deleted);
            }
            fid.clear();
            fid.add(syncFolder.getId());
            List<Integer> modified = this.mbox.getModifiedItems(octxt, lastSync, (byte)-1, fid).getFirst();
            for (int itemId : modified) {
                MailItem mailItem = this.mbox.getItemById(octxt, itemId, (byte)-1);
                if (modifiedFromRemote.containsKey(itemId) && ((Integer)modifiedFromRemote.get(itemId)).equals(mailItem.getModifiedSequence())) continue;
                try {
                    this.pushModify(mailItem);
                }
                catch (Exception e) {
                    ZimbraLog.datasource.info((Object)("Failed to push item " + mailItem.getId()), e);
                }
                allDone = false;
            }
            if (cf.ctagMatched) {
                currentSync = this.mbox.getLastChangeID();
                break;
            }
            List<RemoteItem> remoteItems = this.getRemoteItems(syncFolder);
            for (RemoteItem remoteItem : remoteItems) {
                MailItem localItem = this.applyRemoteItem(remoteItem, syncFolder);
                if (localItem == null) continue;
                if (remoteItem.status == Status.deleted) {
                    deletedFromRemote.add(localItem.getId());
                    continue;
                }
                modifiedFromRemote.put(localItem.getId(), localItem.getModifiedSequence());
            }
            lastSync = currentSync = this.mbox.getLastChangeID();
        }
        this.mbox.setSyncDate(octxt, syncFolder.getId(), currentSync);
    }

    private static class RemoteCalendarItem
    extends RemoteItem {
        String href;
        String etag;
        int itemId;

        public RemoteCalendarItem(String h, String e) {
            this.href = h;
            this.etag = e;
        }
    }

    private static class RemoteItem {
        Status status;

        private RemoteItem() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status {
        created,
        deleted,
        modified;

    }

    private static class CalendarFolder {
        public int id;
        public Folder folder;
        public boolean ctagMatched;

        public CalendarFolder(int fid) {
            this.id = fid;
        }
    }
}

