/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.convert;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentText {
    public static DocumentText EMPTY;
    private Map mAttrs;
    private String mContentTypes;
    private byte[] mContentBytes;
    private String mCharEncoding;

    public DocumentText(byte[] bytes, String charEncoding, Map attrs, String contentTypes) throws UnsupportedEncodingException {
        this.mAttrs = attrs;
        this.mContentTypes = contentTypes;
        if (charEncoding != null && !Charset.isSupported(charEncoding)) {
            throw new UnsupportedEncodingException("unsupported char encoding: " + charEncoding);
        }
        this.mContentBytes = bytes;
        this.mCharEncoding = charEncoding;
    }

    public Map getAttrs() {
        return this.mAttrs;
    }

    public String getContent() {
        if (this.mCharEncoding == null) {
            return new String(this.mContentBytes);
        }
        try {
            return new String(this.mContentBytes, this.mCharEncoding);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public byte[] getContentBytes() {
        return this.mContentBytes;
    }

    public String getCharEncoding() {
        return this.mCharEncoding;
    }

    public String getContentTypes() {
        return this.mContentTypes;
    }

    public List<String> getContentTypeList() {
        if (this.mContentTypes == null || "".equals(this.mContentTypes)) {
            return Collections.emptyList();
        }
        ArrayList<String> a = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.mContentTypes, ",");
        while (st.hasMoreTokens()) {
            a.add(st.nextToken().trim());
        }
        return a;
    }

    static {
        try {
            EMPTY = new DocumentText("".getBytes("UTF-8"), "UTF-8", Collections.EMPTY_MAP, "text/plain");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

