/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.convert;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentInfo {
    private InputStream mInstream;
    private String mContentType;
    private String mPart;
    private List<String> mSeqInArchive;
    private String mDigest;
    private String mFilename;
    private long mLength;

    public AttachmentInfo(InputStream in, String digest, String ct, String p, String filename, long length, List<String> seq) {
        this.mInstream = in;
        this.mDigest = digest;
        this.mContentType = ct;
        this.mPart = p;
        this.mFilename = filename;
        this.mLength = length;
        this.mSeqInArchive = new ArrayList<String>(seq.size());
        this.mSeqInArchive.addAll(seq);
    }

    public AttachmentInfo(InputStream in, String digest, String ct, String p, String filename, long length, String[] seq) {
        this(in, digest, ct, p, filename, length, Arrays.asList(seq));
    }

    public AttachmentInfo(InputStream in, String digest, String ct, String p, String filename, long length) {
        this(in, digest, ct, p, filename, length, new String[0]);
    }

    public List<String> getSeqInArchive() {
        return new ArrayList<String>(this.mSeqInArchive);
    }

    public String getPart() {
        return this.mPart;
    }

    public String getContentType() {
        return this.mContentType;
    }

    public InputStream getInputStream() {
        return this.mInstream;
    }

    public String getDigest() {
        return this.mDigest;
    }

    public String getFilePath() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.mDigest).append(File.separator);
        buf.append(this.mPart);
        for (int i = 0; i < this.mSeqInArchive.size(); ++i) {
            buf.append(File.separator);
            buf.append(this.mSeqInArchive.get(i));
        }
        buf.append(".html");
        return buf.toString();
    }

    public String getPartId() {
        return this.mDigest + "_" + this.mPart;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("AttachmentInfo: input stream=").append(this.mInstream.getClass());
        buf.append(", content type=").append(this.mContentType);
        return buf.toString();
    }

    public void resetSequences() {
        this.mSeqInArchive.clear();
    }

    public String getFilename() {
        return this.mFilename;
    }

    public long getLength() {
        return this.mLength;
    }
}

