/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.client.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.client.LmcBrowseData;
import com.zimbra.cs.client.LmcContact;
import com.zimbra.cs.client.LmcContactAttr;
import com.zimbra.cs.client.LmcConversation;
import com.zimbra.cs.client.LmcEmailAddress;
import com.zimbra.cs.client.LmcFolder;
import com.zimbra.cs.client.LmcMessage;
import com.zimbra.cs.client.LmcMimePart;
import com.zimbra.cs.client.LmcNote;
import com.zimbra.cs.client.LmcSession;
import com.zimbra.cs.client.LmcTag;
import com.zimbra.cs.client.soap.LmcAddMsgRequest;
import com.zimbra.cs.client.soap.LmcAddMsgResponse;
import com.zimbra.cs.client.soap.LmcAuthRequest;
import com.zimbra.cs.client.soap.LmcAuthResponse;
import com.zimbra.cs.client.soap.LmcBrowseRequest;
import com.zimbra.cs.client.soap.LmcBrowseResponse;
import com.zimbra.cs.client.soap.LmcChangePasswordRequest;
import com.zimbra.cs.client.soap.LmcContactActionRequest;
import com.zimbra.cs.client.soap.LmcContactActionResponse;
import com.zimbra.cs.client.soap.LmcConvActionRequest;
import com.zimbra.cs.client.soap.LmcConvActionResponse;
import com.zimbra.cs.client.soap.LmcCreateContactRequest;
import com.zimbra.cs.client.soap.LmcCreateContactResponse;
import com.zimbra.cs.client.soap.LmcCreateFolderRequest;
import com.zimbra.cs.client.soap.LmcCreateFolderResponse;
import com.zimbra.cs.client.soap.LmcCreateNoteRequest;
import com.zimbra.cs.client.soap.LmcCreateNoteResponse;
import com.zimbra.cs.client.soap.LmcCreateTagRequest;
import com.zimbra.cs.client.soap.LmcCreateTagResponse;
import com.zimbra.cs.client.soap.LmcFolderActionRequest;
import com.zimbra.cs.client.soap.LmcFolderActionResponse;
import com.zimbra.cs.client.soap.LmcGetContactsRequest;
import com.zimbra.cs.client.soap.LmcGetContactsResponse;
import com.zimbra.cs.client.soap.LmcGetConvRequest;
import com.zimbra.cs.client.soap.LmcGetConvResponse;
import com.zimbra.cs.client.soap.LmcGetFolderRequest;
import com.zimbra.cs.client.soap.LmcGetFolderResponse;
import com.zimbra.cs.client.soap.LmcGetInfoRequest;
import com.zimbra.cs.client.soap.LmcGetInfoResponse;
import com.zimbra.cs.client.soap.LmcGetMsgRequest;
import com.zimbra.cs.client.soap.LmcGetMsgResponse;
import com.zimbra.cs.client.soap.LmcGetNoteRequest;
import com.zimbra.cs.client.soap.LmcGetNoteResponse;
import com.zimbra.cs.client.soap.LmcGetPrefsRequest;
import com.zimbra.cs.client.soap.LmcGetPrefsResponse;
import com.zimbra.cs.client.soap.LmcGetTagRequest;
import com.zimbra.cs.client.soap.LmcGetTagResponse;
import com.zimbra.cs.client.soap.LmcModifyPrefsRequest;
import com.zimbra.cs.client.soap.LmcModifyPrefsResponse;
import com.zimbra.cs.client.soap.LmcMsgActionRequest;
import com.zimbra.cs.client.soap.LmcMsgActionResponse;
import com.zimbra.cs.client.soap.LmcNoteActionRequest;
import com.zimbra.cs.client.soap.LmcNoteActionResponse;
import com.zimbra.cs.client.soap.LmcPingRequest;
import com.zimbra.cs.client.soap.LmcPingResponse;
import com.zimbra.cs.client.soap.LmcSearchConvRequest;
import com.zimbra.cs.client.soap.LmcSearchConvResponse;
import com.zimbra.cs.client.soap.LmcSearchGalRequest;
import com.zimbra.cs.client.soap.LmcSearchGalResponse;
import com.zimbra.cs.client.soap.LmcSearchRequest;
import com.zimbra.cs.client.soap.LmcSearchResponse;
import com.zimbra.cs.client.soap.LmcSendMsgRequest;
import com.zimbra.cs.client.soap.LmcSendMsgResponse;
import com.zimbra.cs.client.soap.LmcSoapClientException;
import com.zimbra.cs.client.soap.LmcTagActionRequest;
import com.zimbra.cs.client.soap.LmcTagActionResponse;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Tester {
    private static String trashFolderID;
    private static String inboxFolderID;
    private static String cvsConvID;
    private static final String FOLDER_NAME_TRASH = "Trash";
    private static final String FOLDER_NAME_INBOX = "INBOX";
    private static LmcEmailAddress gEa;

    private static void recursiveDumpFolder(LmcFolder f, int depth) {
        for (int j = 0; j < depth; ++j) {
            System.out.print("\t");
        }
        System.out.println(f);
        String fName = f.getName();
        if (fName != null) {
            if (fName.equals(FOLDER_NAME_TRASH)) {
                trashFolderID = f.getFolderID();
            } else if (fName.equals(FOLDER_NAME_INBOX)) {
                inboxFolderID = f.getFolderID();
            }
        }
        LmcFolder[] subFolders = f.getSubFolders();
        for (int i = 0; subFolders != null && i < subFolders.length; ++i) {
            Tester.recursiveDumpFolder(subFolders[i], depth + 1);
        }
    }

    private static void doSearchReadDelete(LmcSession session, String serverURL) throws IOException, LmcSoapClientException, ServiceException, SoapFaultException {
        System.out.println("==== SEARCH \"CVS\" ======");
        LmcSearchRequest sReq = new LmcSearchRequest();
        sReq.setOffset("0");
        sReq.setLimit("30");
        sReq.setQuery("Subject:\"CVS COMMIT\"");
        sReq.setTypes("message");
        sReq.setSession(session);
        LmcSearchResponse sResp = (LmcSearchResponse)sReq.invoke(serverURL);
        List mList = sResp.getResults();
        LmcMessage msg2 = null;
        for (LmcMessage msg2 : mList) {
            System.out.println(msg2);
        }
        String msgID = null;
        if (mList.isEmpty()) {
            throw new LmcSoapClientException("test mailbox probably not set up properly");
        }
        msgID = msg2.getID();
        System.out.println("reading message " + msgID);
        LmcGetMsgRequest gmReq = new LmcGetMsgRequest();
        gmReq.setMsgToGet(msgID);
        gmReq.setRead("1");
        gmReq.setSession(session);
        LmcGetMsgResponse gmResp = (LmcGetMsgResponse)gmReq.invoke(serverURL);
        System.out.println("move to trash message " + msgID);
        LmcMsgActionRequest maReq = new LmcMsgActionRequest();
        maReq.setMsgList(msgID);
        maReq.setOp("move");
        maReq.setFolder(trashFolderID);
        maReq.setSession(session);
        LmcMsgActionResponse maResp = (LmcMsgActionResponse)maReq.invoke(serverURL);
        System.out.println("hard delete message " + msgID);
        maReq.setOp("delete");
        maReq.setFolder(null);
        maResp = (LmcMsgActionResponse)maReq.invoke(serverURL);
    }

    private static void doCreateDeleteFolder(LmcSession session, String serverURL) throws IOException, LmcSoapClientException, ServiceException, SoapFaultException {
        System.out.println("==== CREATE FOLDER ======");
        LmcCreateFolderRequest cfReq = new LmcCreateFolderRequest();
        cfReq.setSession(session);
        cfReq.setName("testfolder");
        cfReq.setParentID(inboxFolderID);
        LmcCreateFolderResponse cfResp = (LmcCreateFolderResponse)cfReq.invoke(serverURL);
        String newID = cfResp.getFolder().getFolderID();
        System.out.println("created new folder with ID " + newID);
        System.out.println("==== DELETE FOLDER ======");
        LmcFolderActionRequest faReq = new LmcFolderActionRequest();
        faReq.setSession(session);
        faReq.setFolderList(newID);
        faReq.setOp("delete");
        LmcFolderActionResponse faResp = (LmcFolderActionResponse)faReq.invoke(serverURL);
        System.out.println("delete folder successful");
    }

    private static void doSearchAndConvAction(LmcSession session, String serverURL) throws IOException, LmcSoapClientException, ServiceException, SoapFaultException {
        System.out.println("==== SEARCH \"CVS\" ======");
        LmcSearchRequest sReq = new LmcSearchRequest();
        sReq.setOffset("0");
        sReq.setLimit("30");
        sReq.setQuery("Subject:\"CVS COMMIT\"");
        sReq.setTypes("conversation");
        sReq.setSession(session);
        LmcSearchResponse sResp = (LmcSearchResponse)sReq.invoke(serverURL);
        LmcConversation conv2 = null;
        LmcConversation firstConv = null;
        List cList = sResp.getResults();
        for (LmcConversation conv2 : cList) {
            if (firstConv == null) {
                firstConv = conv2;
            }
            System.out.println(conv2);
        }
        if (cList.isEmpty()) {
            throw new LmcSoapClientException("test mailbox probably not set up properly");
        }
        cvsConvID = conv2.getID();
        System.out.println("move to trash conv " + cvsConvID);
        LmcConvActionRequest caReq = new LmcConvActionRequest();
        caReq.setConvList(cvsConvID);
        caReq.setOp("move");
        caReq.setFolder(trashFolderID);
        caReq.setSession(session);
        LmcConvActionResponse caResp = (LmcConvActionResponse)caReq.invoke(serverURL);
        System.out.println("move to INBOX conv " + cvsConvID);
        caReq.setConvList(cvsConvID);
        caReq.setOp("move");
        caReq.setFolder(inboxFolderID);
        caReq.setSession(session);
        caResp = (LmcConvActionResponse)caReq.invoke(serverURL);
    }

    private static void getAndDumpContacts(LmcSession session, String serverURL) throws IOException, LmcSoapClientException, ServiceException, SoapFaultException {
        System.out.println("==== GET CONTACTS ======");
        LmcGetContactsRequest gcReq = new LmcGetContactsRequest();
        gcReq.setSession(session);
        LmcGetContactsResponse gcResp = (LmcGetContactsResponse)gcReq.invoke(serverURL);
        System.out.println("====== DUMP CONTACTS ======");
        LmcContact[] contacts = gcResp.getContacts();
        for (int o = 0; contacts != null && o < contacts.length; ++o) {
            System.out.println(contacts[o]);
        }
    }

    private static void doSearchConv(LmcSession session, String serverURL) throws IOException, LmcSoapClientException, ServiceException, SoapFaultException {
        System.out.println("==== SEARCH CONV ======");
        LmcSearchConvRequest sReq = new LmcSearchConvRequest();
        sReq.setOffset("0");
        sReq.setLimit("30");
        sReq.setTypes("message");
        sReq.setQuery("CVS");
        sReq.setSession(session);
        sReq.setConvID(cvsConvID);
        LmcSearchConvResponse sResp = (LmcSearchConvResponse)sReq.invoke(serverURL);
        List mList = sResp.getResults();
        LmcMessage msg2 = null;
        for (LmcMessage msg2 : mList) {
            System.out.println(msg2);
        }
    }

    private static void doBrowse(LmcSession session, String serverURL) throws IOException, LmcSoapClientException, ServiceException, SoapFaultException {
        System.out.println("======= BROWSE BY DOMAIN ======");
        LmcBrowseRequest bReq = new LmcBrowseRequest();
        bReq.setBrowseBy("domains");
        bReq.setSession(session);
        LmcBrowseResponse bResp = (LmcBrowseResponse)bReq.invoke(serverURL);
        System.out.println("got back browse data");
        LmcBrowseData[] bd = bResp.getData();
        for (int i = 0; i < bd.length; ++i) {
            System.out.println(bd[i].getFlags() + " " + bd[i].getData());
        }
    }

    private static void doCreateDeleteContact(LmcSession session, String serverURL) throws IOException, LmcSoapClientException, ServiceException, SoapFaultException {
        System.out.println("=========== CREATING CONTACT ============");
        LmcCreateContactRequest ccReq = new LmcCreateContactRequest();
        ccReq.setSession(session);
        LmcContact c = new LmcContact();
        LmcContactAttr[] attrs = new LmcContactAttr[]{new LmcContactAttr("email", "1", null, "schumie@f1.com"), new LmcContactAttr("firstName", "2", null, "Michael"), new LmcContactAttr("lastName", "3", null, "Schumacher")};
        c.setAttrs(attrs);
        ccReq.setContact(c);
        LmcCreateContactResponse ccResp = (LmcCreateContactResponse)ccReq.invoke(serverURL);
        String newID = ccResp.getContact().getID();
        Tester.getAndDumpContacts(session, serverURL);
        System.out.println("=========== DELETING CONTACT ============");
        LmcContactActionRequest caReq = new LmcContactActionRequest();
        caReq.setSession(session);
        caReq.setOp("delete");
        caReq.setIDList(newID);
        LmcContactActionResponse caResp = (LmcContactActionResponse)caReq.invoke(serverURL);
        Tester.getAndDumpContacts(session, serverURL);
    }

    private static void doCreateDeleteTag(LmcSession session, String serverURL) throws IOException, LmcSoapClientException, ServiceException, SoapFaultException {
        System.out.println("=========== CREATING TAG ============");
        LmcCreateTagRequest ctReq = new LmcCreateTagRequest();
        ctReq.setSession(session);
        ctReq.setName("testtag3");
        ctReq.setColor("0");
        LmcCreateTagResponse ctResp = (LmcCreateTagResponse)ctReq.invoke(serverURL);
        LmcTag newTag = ctResp.getTag();
        System.out.println("created tag " + newTag.getID());
        System.out.println("=========== DELETING TAG ============");
        LmcTagActionRequest taReq = new LmcTagActionRequest();
        taReq.setSession(session);
        taReq.setOp("delete");
        taReq.setTagList(newTag.getID());
        LmcTagActionResponse taResp = (LmcTagActionResponse)taReq.invoke(serverURL);
    }

    private static void doCreateGetDeleteNote(LmcSession session, String serverURL) throws IOException, LmcSoapClientException, ServiceException, SoapFaultException {
        System.out.println("=========== CREATING NOTE ============");
        LmcCreateNoteRequest ctReq = new LmcCreateNoteRequest();
        ctReq.setSession(session);
        ctReq.setParentID(inboxFolderID);
        ctReq.setContent("this is a test note");
        ctReq.setColor("0");
        LmcCreateNoteResponse ctResp = (LmcCreateNoteResponse)ctReq.invoke(serverURL);
        LmcNote newNote = ctResp.getNote();
        String noteID = newNote.getID();
        System.out.println("created Note " + noteID);
        System.out.println("=========== GET NOTE ============");
        LmcGetNoteRequest gnReq = new LmcGetNoteRequest();
        gnReq.setSession(session);
        gnReq.setNoteToGet(noteID);
        LmcGetNoteResponse gnResp = (LmcGetNoteResponse)gnReq.invoke(serverURL);
        newNote = gnResp.getNote();
        System.out.println("created Note\n" + newNote);
        System.out.println("=========== DELETING NOTE ============");
        LmcNoteActionRequest taReq = new LmcNoteActionRequest();
        taReq.setSession(session);
        taReq.setOp("delete");
        taReq.setNoteList(noteID);
        LmcNoteActionResponse taResp = (LmcNoteActionResponse)taReq.invoke(serverURL);
        System.out.println("successfully deleted note " + taResp.getNoteList());
    }

    private static void dumpPrefs(HashMap prefMap) {
        System.out.println("===== DUMP THE PREFS ===== ");
        Set s = prefMap.entrySet();
        for (Map.Entry entry : s) {
            System.out.println("key " + (String)entry.getKey() + " value " + (String)entry.getValue());
        }
    }

    private static void doGetDumpPrefs(LmcSession session, String serverURL) throws IOException, LmcSoapClientException, ServiceException, SoapFaultException {
        System.out.println("====== GET PREFS ==========");
        String[] prefs = new String[]{"zimbraPrefMailSignatureEnabled", "zimbraPrefSaveToSent"};
        LmcGetPrefsRequest prefReq = new LmcGetPrefsRequest();
        prefReq.setSession(session);
        prefReq.setPrefsToGet(prefs);
        LmcGetPrefsResponse prefResp = (LmcGetPrefsResponse)prefReq.invoke(serverURL);
        HashMap prefMap = prefResp.getPrefsMap();
        Tester.dumpPrefs(prefMap);
    }

    private static void doModifyDumpPrefs(LmcSession session, String serverURL) throws IOException, LmcSoapClientException, ServiceException, SoapFaultException {
        System.out.println("=========== MODIFY PREFS ==========");
        HashMap<String, String> prefMods = new HashMap<String, String>();
        prefMods.put("zimbraPrefMailSignatureEnabled", "TRUE");
        prefMods.put("zimbraPrefSaveToSent", "TRUE");
        LmcModifyPrefsRequest mpReq = new LmcModifyPrefsRequest();
        mpReq.setSession(session);
        mpReq.setPrefMods(prefMods);
        LmcModifyPrefsResponse mpResp = (LmcModifyPrefsResponse)mpReq.invoke(serverURL);
        Tester.doGetDumpPrefs(session, serverURL);
    }

    private static void doChangePassword(LmcSession session, String account, String currPassword, String serverURL) throws IOException, LmcSoapClientException, ServiceException, SoapFaultException {
        System.out.println("=========== CHANGE PASSWORD ==========");
        LmcChangePasswordRequest cpReq = new LmcChangePasswordRequest();
        cpReq.setSession(session);
        cpReq.setAccount(account);
        cpReq.setOldPassword(currPassword);
        cpReq.setPassword("test1234");
        cpReq.invoke(serverURL);
        System.out.println("changing the password back");
        cpReq.setOldPassword("test1234");
        cpReq.setPassword(currPassword);
        cpReq.invoke(serverURL);
    }

    private static void doAddMsg(LmcSession session, String serverURL) throws IOException, LmcSoapClientException, ServiceException, SoapFaultException {
        System.out.println("====== ADD MSG =======");
        LmcMessage lMsg = new LmcMessage();
        lMsg.setEmailAddresses(new LmcEmailAddress[]{gEa});
        Date d = new Date();
        lMsg.setSubject("AddMsg: " + d);
        lMsg.setFolder(inboxFolderID);
        lMsg.setContent("From: kluge@example.zimbra.com\r\nTo: kluge@dogfood.example.zimbra.com\r\nSubject: AddMsg " + d + "\r\n\r\nThis is some text.");
        LmcAddMsgRequest amr = new LmcAddMsgRequest();
        amr.setMsg(lMsg);
        amr.setSession(session);
        LmcAddMsgResponse amrResp = (LmcAddMsgResponse)amr.invoke(serverURL);
        System.out.println("Add successful, resulting ID " + amrResp.getID());
    }

    private static void doGetInfo(LmcSession session, String serverURL) throws IOException, LmcSoapClientException, ServiceException, SoapFaultException {
        System.out.println("=========== GET INFO ==========");
        LmcGetInfoRequest giReq = new LmcGetInfoRequest();
        giReq.setSession(session);
        LmcGetInfoResponse giResp = (LmcGetInfoResponse)giReq.invoke(serverURL);
        System.out.println("Account name: " + giResp.getAcctName());
        System.out.println("lifetime: " + giResp.getLifetime());
        Tester.dumpPrefs(giResp.getPrefMap());
    }

    private static void doSearchGal(LmcSession session, String serverURL, String searchTarget) throws IOException, LmcSoapClientException, ServiceException, SoapFaultException {
        System.out.println("=========== SEARCH GAL ==========");
        LmcSearchGalRequest sgReq = new LmcSearchGalRequest();
        sgReq.setSession(session);
        sgReq.setName(searchTarget);
        LmcSearchGalResponse sgResp = (LmcSearchGalResponse)sgReq.invoke(serverURL);
        System.out.println("Search results ----");
        LmcContact[] contacts = sgResp.getContacts();
        for (int o = 0; contacts != null && o < contacts.length; ++o) {
            System.out.println(contacts[o]);
        }
    }

    public static void main(String[] argv) {
        CliUtil.toolSetup();
        if (argv.length != 3) {
            System.out.println("Usage: Tester <serverURL> <username> <password>");
            System.out.println("where:");
            System.out.println("<serverURL> is the full URL to the SOAP service");
            System.out.println("<username> is the name of the user to log in as");
            System.out.println("<password> is that user's password");
            System.out.println("NOTE: THIS COMMAND WILL DELETE E-MAIL!!!");
        }
        String serverURL = argv[0];
        System.out.println("connecting to " + serverURL + " as " + argv[1] + " with password " + argv[2]);
        try {
            LmcPingRequest pr = new LmcPingRequest();
            LmcPingResponse pResp = (LmcPingResponse)pr.invoke(serverURL);
            System.out.println("========= AUTHENTICATE ===========");
            LmcAuthRequest auth = new LmcAuthRequest();
            auth.setUsername(argv[1]);
            auth.setPassword(argv[2]);
            LmcAuthResponse authResp = (LmcAuthResponse)auth.invoke(serverURL);
            LmcSession session = authResp.getSession();
            Tester.doGetDumpPrefs(session, serverURL);
            System.out.println("======== GET TAGS =======");
            LmcGetTagRequest gtReq = new LmcGetTagRequest();
            gtReq.setSession(session);
            LmcGetTagResponse gtResp = (LmcGetTagResponse)gtReq.invoke(serverURL);
            System.out.println("==== DUMP TAGS ======");
            LmcTag[] tags = gtResp.getTags();
            for (int t = 0; tags != null && t < tags.length; ++t) {
                System.out.println(tags[t]);
            }
            System.out.println("==== GET FOLDERS ======");
            LmcGetFolderRequest gfReq = new LmcGetFolderRequest();
            gfReq.setSession(session);
            LmcGetFolderResponse gfResp = (LmcGetFolderResponse)gfReq.invoke(serverURL);
            System.out.println("====== DUMP FOLDERS ======");
            LmcFolder folder = gfResp.getRootFolder();
            Tester.recursiveDumpFolder(folder, 0);
            System.out.println("==== SEARCH in:inbox ======");
            LmcSearchRequest sReq = new LmcSearchRequest();
            sReq.setOffset("0");
            sReq.setLimit("30");
            sReq.setQuery("in:inbox");
            sReq.setSession(session);
            sReq.setTypes("conversation");
            LmcSearchResponse sResp = (LmcSearchResponse)sReq.invoke(serverURL);
            System.out.println("====== DUMP SEARCH ======");
            System.out.println("offset=\"" + sResp.getOffset() + "\" more=\"" + sResp.getMore() + "\"");
            LmcConversation conv2 = null;
            LmcConversation firstConv = null;
            List cList = sResp.getResults();
            for (LmcConversation conv2 : cList) {
                if (firstConv == null) {
                    firstConv = conv2;
                }
                System.out.println(conv2);
            }
            Tester.getAndDumpContacts(session, serverURL);
            System.out.println("===== GET CONVERSATION =====");
            LmcGetConvRequest gconvReq = new LmcGetConvRequest();
            gconvReq.setConvToGet(firstConv.getID());
            gconvReq.setSession(session);
            String[] msgDetail = new String[]{firstConv.getMessages()[0].getID()};
            gconvReq.setMsgsToGet(msgDetail);
            LmcGetConvResponse gconvResp = (LmcGetConvResponse)gconvReq.invoke(serverURL);
            System.out.println("===== DUMP CONVERSATION ===== ");
            System.out.println(gconvResp.getConv());
            System.out.println("===== GET MESSAGE ===== ");
            LmcGetMsgRequest gmReq = new LmcGetMsgRequest();
            gmReq.setRead("1");
            gmReq.setMsgToGet(msgDetail[0]);
            gmReq.setSession(session);
            LmcGetMsgResponse gmResp = (LmcGetMsgResponse)gmReq.invoke(serverURL);
            System.out.println("===== DUMP MESSAGE ===== ");
            System.out.println(gmResp.getMsg());
            System.out.println("===== SEND MESSAGE ===== ");
            LmcMessage lMsg = new LmcMessage();
            lMsg.setEmailAddresses(new LmcEmailAddress[]{gEa});
            lMsg.setSubject("msg from the test program");
            LmcMimePart smrMp = new LmcMimePart();
            smrMp.setContentType("text/plain");
            smrMp.setContent("there is some fresh coffee somewhere");
            lMsg.addMimePart(smrMp);
            LmcSendMsgRequest smr = new LmcSendMsgRequest();
            smr.setMsg(lMsg);
            smr.setSession(session);
            String aid = smr.postAttachment("http://dogfood.example.zimbra.com/service/upload", session, new File("c:/temp/ops.txt"), ".example.zimbra.com", 5000);
            System.out.println("got back attachment id " + aid);
            lMsg.setAttachmentIDs(new String[]{aid});
            LmcSendMsgResponse smrResp = (LmcSendMsgResponse)smr.invoke(serverURL);
            System.out.println("==== DUMP SEND MSG RESPONSE ====");
            System.out.println("Send successful, resulting ID " + smrResp.getID());
            Tester.doSearchReadDelete(session, serverURL);
            Tester.doSearchAndConvAction(session, serverURL);
            Tester.doCreateDeleteFolder(session, serverURL);
            Tester.doCreateDeleteContact(session, serverURL);
            Tester.doCreateDeleteTag(session, serverURL);
            Tester.doModifyDumpPrefs(session, serverURL);
            Tester.doCreateGetDeleteNote(session, serverURL);
            Tester.doChangePassword(session, argv[1], argv[2], serverURL);
            Tester.doGetInfo(session, serverURL);
            Tester.doSearchGal(session, serverURL, "Kevin");
            Tester.doSearchGal(session, serverURL, "Satish");
            Tester.doSearchConv(session, serverURL);
            Tester.doBrowse(session, serverURL);
            Tester.doAddMsg(session, serverURL);
        }
        catch (SoapFaultException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (LmcSoapClientException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    static {
        gEa = new LmcEmailAddress();
        gEa.setType("t");
        gEa.setContent("kluge@yahoo.com");
        gEa.setEmailAddress("kluge@yahoo.com");
    }
}

