/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.client.soap;

import EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.client.LmcSession;
import com.zimbra.cs.client.LmcTag;
import com.zimbra.cs.client.soap.LmcAuthRequest;
import com.zimbra.cs.client.soap.LmcAuthResponse;
import com.zimbra.cs.client.soap.LmcGetTagRequest;
import com.zimbra.cs.client.soap.LmcGetTagResponse;
import com.zimbra.cs.client.soap.LmcSoapClientException;
import java.io.IOException;

public class TestAuth
implements Runnable {
    private static Log mLog = LogFactory.getLog(TestAuth.class);
    private String mUrl;
    private String mAcct;
    private String mPasswd;
    private int mIteration;

    private static void usage() {
        System.err.println("Usage: java " + TestAuth.class.getName() + " iterations threads loacct hiacct domain url");
        System.exit(1);
    }

    public static void main(String[] argv) {
        CliUtil.toolSetup();
        if (argv.length != 6) {
            TestAuth.usage();
        }
        int iterations = 0;
        int threads = 0;
        int loAcctNum = 0;
        int hiAcctNum = 0;
        String domain = null;
        String url = null;
        try {
            iterations = Integer.valueOf(argv[0]);
            threads = Integer.valueOf(argv[1]);
            loAcctNum = Integer.valueOf(argv[2]);
            hiAcctNum = Integer.valueOf(argv[3]);
            domain = argv[4];
            url = argv[5];
        }
        catch (NumberFormatException nfe) {
            TestAuth.usage();
        }
        PooledExecutor executor = new PooledExecutor(new BoundedLinkedQueue(), threads);
        executor.setMinimumPoolSize(threads);
        executor.waitWhenBlocked();
        for (int iter = 0; iter < iterations; ++iter) {
            for (int acct = loAcctNum; acct <= hiAcctNum; ++acct) {
                String user = "load" + acct + "@" + domain;
                try {
                    executor.execute(new TestAuth(iter, url, user, "test123"));
                    continue;
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        }
        executor.shutdownAfterProcessingCurrentlyQueuedTasks();
    }

    TestAuth(int iter, String url, String acct, String passwd) {
        this.mIteration = iter;
        this.mUrl = url;
        this.mAcct = acct;
        this.mPasswd = passwd;
    }

    public void run() {
        long start = System.currentTimeMillis();
        String tags = this.doAuth(this.mUrl, this.mAcct, this.mPasswd);
        long elapsed = System.currentTimeMillis() - start;
        System.err.println(this.mIteration + " " + Thread.currentThread().getName() + " " + this.mAcct + " " + tags);
    }

    private String doAuth(String url, String account, String password) {
        try {
            LmcAuthRequest auth = new LmcAuthRequest();
            auth.setUsername(account);
            auth.setPassword(password);
            LmcAuthResponse authResp = (LmcAuthResponse)auth.invoke(url);
            LmcSession session = authResp.getSession();
            LmcGetTagRequest gtReq = new LmcGetTagRequest();
            gtReq.setSession(session);
            LmcGetTagResponse gtResp = (LmcGetTagResponse)gtReq.invoke(url);
            LmcTag[] tags = gtResp.getTags();
            StringBuffer sb = new StringBuffer();
            for (int t = 0; tags != null && t < tags.length; ++t) {
                sb.append(tags[t]).append(" ");
            }
            return sb.toString();
        }
        catch (SoapFaultException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (LmcSoapClientException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return null;
    }
}

