/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.client.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.DomUtil;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.client.soap.LmcSoapRequest;
import com.zimbra.cs.client.soap.LmcSoapResponse;
import com.zimbra.cs.client.soap.LmcTagActionResponse;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LmcTagActionRequest
extends LmcSoapRequest {
    private String mIDList;
    private String mOp;
    private String mColor;
    private String mName;

    public void setTagList(String idList) {
        this.mIDList = idList;
    }

    public void setOp(String op) {
        this.mOp = op;
    }

    public void setName(String t) {
        this.mName = t;
    }

    public void setColor(String c) {
        this.mColor = c;
    }

    public String getTagList() {
        return this.mIDList;
    }

    public String getOp() {
        return this.mOp;
    }

    public String getColor() {
        return this.mColor;
    }

    public String getName() {
        return this.mName;
    }

    protected Element getRequestXML() {
        Element request = DocumentHelper.createElement(MailConstants.TAG_ACTION_REQUEST);
        Element a = DomUtil.add(request, "action", "");
        DomUtil.addAttr(a, "op", this.mOp);
        DomUtil.addAttr(a, "id", this.mIDList);
        DomUtil.addAttr(a, "name", this.mName);
        DomUtil.addAttr(a, "color", this.mColor);
        return request;
    }

    protected LmcSoapResponse parseResponseXML(Element responseXML) throws ServiceException {
        LmcTagActionResponse response = new LmcTagActionResponse();
        Element a = DomUtil.get(responseXML, "action");
        response.setOp(DomUtil.getAttr(a, "op"));
        response.setTagList(DomUtil.getAttr(a, "id"));
        return response;
    }
}

