/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.client.soap;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.DomUtil;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.soap.SoapHttpTransport;
import com.zimbra.common.soap.SoapParseException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.client.LmcContact;
import com.zimbra.cs.client.LmcContactAttr;
import com.zimbra.cs.client.LmcConversation;
import com.zimbra.cs.client.LmcDocument;
import com.zimbra.cs.client.LmcEmailAddress;
import com.zimbra.cs.client.LmcFolder;
import com.zimbra.cs.client.LmcMessage;
import com.zimbra.cs.client.LmcMimePart;
import com.zimbra.cs.client.LmcNote;
import com.zimbra.cs.client.LmcSession;
import com.zimbra.cs.client.LmcTag;
import com.zimbra.cs.client.LmcWiki;
import com.zimbra.cs.client.soap.LmcSoapClientException;
import com.zimbra.cs.client.soap.LmcSoapResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.dom4j.Element;

public abstract class LmcSoapRequest {
    private static Log sLog = LogFactory.getLog(LmcSoapRequest.class);
    private static boolean sDumpXML = false;
    private static int sRetryCount = -1;
    private static int sTimeoutMillis = -1;
    protected LmcSession mSession;
    protected String mRequestedAccountId;

    public static synchronized void setDumpXML(boolean b) {
        sDumpXML = b;
    }

    public static synchronized void setRetryCount(int n) {
        sRetryCount = n;
    }

    public static synchronized void setTimeout(int millis) {
        sTimeoutMillis = millis;
    }

    public LmcSession getSession() {
        return this.mSession;
    }

    public void setSession(LmcSession l) {
        this.mSession = l;
    }

    public String getRequestedAccountId() {
        return this.mRequestedAccountId;
    }

    public void setRequestedAccountId(String id) {
        this.mRequestedAccountId = id;
    }

    protected abstract Element getRequestXML() throws LmcSoapClientException;

    protected abstract LmcSoapResponse parseResponseXML(Element var1) throws SoapParseException, ServiceException, LmcSoapClientException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LmcSoapResponse invoke(String targetURL) throws LmcSoapClientException, IOException, SoapFaultException, ServiceException, SoapParseException {
        LmcSoapResponse result = null;
        SoapHttpTransport trans = null;
        try {
            String newSessionID;
            trans = new SoapHttpTransport(targetURL);
            trans.setTimeout(sTimeoutMillis);
            trans.setRetryCount(sRetryCount);
            trans.setUserAgent("lmc", null);
            String curSessionID = null;
            if (this.mSession != null) {
                ZAuthToken zat = this.mSession.getAuthToken();
                trans.setAuthToken(zat);
                curSessionID = this.mSession.getSessionID();
                trans.setSessionId(curSessionID);
            }
            Element requestXML = this.getRequestXML();
            if (sDumpXML) {
                sLog.info("Request:" + DomUtil.toString(requestXML, true));
            }
            com.zimbra.common.soap.Element requestElt = com.zimbra.common.soap.Element.convertDOM(requestXML);
            Element responseXML = this.mRequestedAccountId == null ? trans.invoke(requestElt).toXML() : trans.invoke(requestElt, false, true, this.mRequestedAccountId).toXML();
            if (sDumpXML) {
                sLog.info("Response:" + DomUtil.toString(responseXML, true) + "\n");
            }
            if ((newSessionID = trans.getSessionId()) != null && this.mSession != null) {
                if (curSessionID == null) {
                    this.mSession.setSessionID(newSessionID);
                } else if (!curSessionID.equals(newSessionID)) {
                    this.mSession.setSessionID(newSessionID);
                }
            }
            result = this.parseResponseXML(responseXML);
            Object var10_9 = null;
            if (trans != null) {
                trans.shutdown();
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (trans != null) {
                trans.shutdown();
            }
            throw throwable;
        }
        return result;
    }

    protected LmcContact[] parseContactArray(Element parentElem) throws ServiceException {
        ArrayList<LmcContact> contactArray = new ArrayList<LmcContact>();
        Iterator ait = parentElem.elementIterator("cn");
        while (ait.hasNext()) {
            Element a = (Element)ait.next();
            contactArray.add(this.parseContact(a));
        }
        if (contactArray.isEmpty()) {
            return null;
        }
        LmcContact[] contacts = new LmcContact[contactArray.size()];
        return contactArray.toArray(contacts);
    }

    protected static void addAttrNotNull(Element elem, String attrName, String attrValue) {
        if (attrValue != null) {
            DomUtil.addAttr(elem, attrName, attrValue);
        }
    }

    protected void addContactAttr(Element parent, LmcContactAttr attr) {
        String attrValue = attr.getAttrData();
        Element newAttr = DomUtil.add(parent, "a", attrValue == null ? "" : attrValue);
        DomUtil.addAttr(newAttr, "n", attr.getAttrName());
    }

    protected LmcConversation parseConversation(Element conv) throws LmcSoapClientException, ServiceException {
        LmcConversation result = new LmcConversation();
        result.setID(conv.attributeValue("id"));
        result.setTags(conv.attributeValue("t"));
        String numMsgs = conv.attributeValue("n");
        if (numMsgs != null) {
            result.setNumMessages(Integer.parseInt(numMsgs));
        }
        result.setDate(conv.attributeValue("d"));
        result.setFlags(conv.attributeValue("f"));
        result.setFolder(conv.attributeValue("l"));
        ArrayList<LmcEmailAddress> emailAddrs = new ArrayList<LmcEmailAddress>();
        ArrayList<LmcMessage> msgs = new ArrayList<LmcMessage>();
        Iterator it = conv.elementIterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            String elementType = e.getQName().getName();
            if (elementType.equals("fr")) {
                result.setFragment(e.getText());
                continue;
            }
            if (elementType.equals("e")) {
                LmcEmailAddress ea = this.parseEmailAddress(e);
                emailAddrs.add(ea);
                continue;
            }
            if (elementType.equals("su")) {
                result.setSubject(e.getText());
                continue;
            }
            if (elementType.equals("m")) {
                LmcMessage m = this.parseMessage(e);
                msgs.add(m);
                continue;
            }
            throw new LmcSoapClientException("unknown element " + elementType + " within conversation");
        }
        if (!emailAddrs.isEmpty()) {
            LmcEmailAddress[] a = new LmcEmailAddress[emailAddrs.size()];
            result.setParticipants(emailAddrs.toArray(a));
        }
        if (!msgs.isEmpty()) {
            LmcMessage[] m = new LmcMessage[msgs.size()];
            result.setMessages(msgs.toArray(m));
        }
        return result;
    }

    protected LmcContactAttr parseContactAttr(Element cna) throws ServiceException {
        String attrName = DomUtil.getAttr(cna, "n");
        String attrID = cna.attributeValue("id");
        String ref = cna.attributeValue("ref");
        String attrData = cna.getText();
        LmcContactAttr lca = new LmcContactAttr(attrName, attrID, ref, attrData);
        return lca;
    }

    protected LmcContact parseContact(Element cn) throws ServiceException {
        LmcContact result = new LmcContact();
        result.setID(DomUtil.getAttr(cn, "id"));
        result.setTags(cn.attributeValue("t"));
        result.setFlags(cn.attributeValue("f"));
        result.setFolder(cn.attributeValue("l"));
        ArrayList<LmcContactAttr> cnAttrs = new ArrayList<LmcContactAttr>();
        Iterator ait = cn.elementIterator("a");
        while (ait.hasNext()) {
            Element cnAttrElem = (Element)ait.next();
            cnAttrs.add(this.parseContactAttr(cnAttrElem));
        }
        if (!cnAttrs.isEmpty()) {
            LmcContactAttr[] cnAttrArray = new LmcContactAttr[cnAttrs.size()];
            result.setAttrs(cnAttrs.toArray(cnAttrArray));
        }
        return result;
    }

    protected LmcMessage parseMessage(Element msg) throws ServiceException, LmcSoapClientException {
        LmcMessage result = new LmcMessage();
        result.setID(DomUtil.getAttr(msg, "id"));
        result.setFlags(msg.attributeValue("f"));
        String size = msg.attributeValue("s");
        if (size != null) {
            result.setSize(Integer.parseInt(size));
        }
        result.setContentMatched(msg.attributeValue("cm"));
        result.setDate(msg.attributeValue("d"));
        result.setConvID(msg.attributeValue("cid"));
        result.setFolder(msg.attributeValue("l"));
        result.setOriginalID(msg.attributeValue("origid"));
        ArrayList<LmcEmailAddress> emailAddrs = new ArrayList<LmcEmailAddress>();
        Iterator it = msg.elementIterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            String elementType = e.getQName().getName();
            if (elementType.equals("fr")) {
                result.setFragment(e.getText());
                continue;
            }
            if (elementType.equals("e")) {
                LmcEmailAddress ea = this.parseEmailAddress(e);
                emailAddrs.add(ea);
                continue;
            }
            if (elementType.equals("su")) {
                result.setSubject(e.getText());
                continue;
            }
            if (elementType.equals("mp")) {
                LmcMimePart mp = this.parseMimePart(e);
                result.addMimePart(mp);
                continue;
            }
            if (elementType.equals("mid")) {
                result.setMsgIDHeader(e.getText());
                continue;
            }
            if (elementType.equals("inv")) continue;
            throw new LmcSoapClientException("unknown element " + elementType + " within message");
        }
        if (!emailAddrs.isEmpty()) {
            LmcEmailAddress[] a = new LmcEmailAddress[emailAddrs.size()];
            result.setEmailAddresses(emailAddrs.toArray(a));
        }
        return result;
    }

    protected LmcMimePart parseMimePart(Element mp) throws LmcSoapClientException, ServiceException {
        LmcMimePart result = new LmcMimePart();
        result.setPartName(DomUtil.getAttr(mp, "part"));
        result.setIsBody(mp.attributeValue("body"));
        result.setSize(mp.attributeValue("s"));
        result.setMessageID(mp.attributeValue("mid"));
        result.setConvID(mp.attributeValue("cid"));
        result.setContentType(mp.attributeValue("ct"));
        result.setContentTypeName(mp.attributeValue("name"));
        result.setContentDisp(mp.attributeValue("cd"));
        result.setContentDispFilename(mp.attributeValue("filename"));
        result.setContentDesc(mp.attributeValue("cde"));
        ArrayList<LmcMimePart> subMimeParts = new ArrayList<LmcMimePart>();
        Iterator it = mp.elementIterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            String elementType = e.getQName().getName();
            if (elementType.equals("content")) {
                this.addContent(result, e);
                continue;
            }
            if (elementType.equals("mp")) {
                LmcMimePart nextPart = this.parseMimePart(e);
                subMimeParts.add(nextPart);
                continue;
            }
            throw new LmcSoapClientException("unexpected element " + elementType);
        }
        if (!subMimeParts.isEmpty()) {
            LmcMimePart[] mpArr = new LmcMimePart[subMimeParts.size()];
            result.setSubParts(subMimeParts.toArray(mpArr));
        }
        return result;
    }

    protected void addContent(LmcMimePart mp, Element c) {
        mp.setContentEncoding(c.attributeValue("cte"));
        mp.setContent(c.getText());
    }

    protected LmcEmailAddress parseEmailAddress(Element ea) {
        LmcEmailAddress result = new LmcEmailAddress();
        result.setType(ea.attributeValue("t"));
        result.setEmailID(ea.attributeValue("id"));
        result.setReferencedID(ea.attributeValue("ref"));
        result.setPersonalName(ea.attributeValue("p"));
        result.setEmailAddress(ea.attributeValue("a"));
        result.setDisplayName(ea.attributeValue("d"));
        result.setContent(ea.getText());
        return result;
    }

    protected LmcFolder parseFolder(Element f) throws ServiceException {
        LmcFolder response = new LmcFolder();
        response.setFolderID(DomUtil.getAttr(f, "id"));
        response.setName(f.attributeValue("name"));
        response.setParentID(f.attributeValue("l"));
        response.setNumUnread(f.attributeValue("u"));
        response.setView(f.attributeValue("view"));
        ArrayList<LmcFolder> subFolders = new ArrayList<LmcFolder>();
        Iterator ait = f.elementIterator("folder");
        while (ait.hasNext()) {
            Element sub = (Element)ait.next();
            subFolders.add(this.parseFolder(sub));
        }
        if (!subFolders.isEmpty()) {
            LmcFolder[] fs = new LmcFolder[subFolders.size()];
            response.setSubFolders(subFolders.toArray(fs));
        }
        return response;
    }

    protected void addPrefToMultiMap(HashMap prefMap, Element e) throws ServiceException {
        String name = DomUtil.getAttr(e, "name");
        String value = e.getText();
        StringUtil.addToMultiMap(prefMap, name, value);
    }

    protected LmcNote parseNote(Element n) throws ServiceException {
        LmcNote result = new LmcNote();
        result.setID(DomUtil.getAttr(n, "id"));
        result.setTags(n.attributeValue("t"));
        result.setDate(DomUtil.getAttr(n, "d"));
        result.setFolder(DomUtil.getAttr(n, "l"));
        result.setPosition(DomUtil.getAttr(n, "pos"));
        result.setColor(DomUtil.getAttr(n, "color"));
        Element c = DomUtil.get(n, "content");
        result.setContent(c.getText());
        return result;
    }

    protected LmcTag parseTag(Element t) throws ServiceException {
        String name = DomUtil.getAttr(t, "name");
        String id = DomUtil.getAttr(t, "id");
        String color = DomUtil.getAttr(t, "color");
        long unreadCount = DomUtil.getAttrLong(t, "u", -1L);
        LmcTag newTag = unreadCount == -1L ? new LmcTag(id, name, color) : new LmcTag(id, name, color, unreadCount);
        return newTag;
    }

    protected LmcDocument parseDocument(Element doc) {
        LmcDocument result = this.parseDocumentCommon(doc, new LmcDocument());
        return result;
    }

    protected LmcWiki parseWiki(Element wiki) {
        LmcWiki result = new LmcWiki();
        this.parseDocumentCommon(wiki, result);
        result.setWikiWord(wiki.attributeValue("name"));
        try {
            Element c = DomUtil.get(wiki, "body");
            result.setContents(c.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private LmcDocument parseDocumentCommon(Element doc, LmcDocument result) {
        result.setID(doc.attributeValue("id"));
        result.setName(doc.attributeValue("name"));
        result.setContentType(doc.attributeValue("ct"));
        result.setFolder(doc.attributeValue("l"));
        result.setRev(doc.attributeValue("ver"));
        result.setLastModifiedDate(doc.attributeValue("d"));
        result.setLastEditor(doc.attributeValue("leb"));
        result.setRestUrl(doc.attributeValue("rest"));
        result.setCreator(doc.attributeValue("cr"));
        result.setCreateDate(doc.attributeValue("cd"));
        Iterator it = doc.elementIterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            String elementType = e.getQName().getName();
            if (!elementType.equals("fr")) continue;
            result.setFragment(e.getText());
        }
        return result;
    }

    protected void addMsg(Element e, LmcMessage msg, String inReplyTo, String fwdMsgID, String[] fwdPartNumbers) {
        String[] attachmentIDs;
        LmcMimePart mp;
        Element m = DomUtil.add(e, "m", "");
        LmcSoapRequest.addAttrNotNull(m, "origid", msg.getOriginalID());
        LmcSoapRequest.addAttrNotNull(m, "l", msg.getFolder());
        LmcSoapRequest.addAttrNotNull(m, "tag", msg.getTag());
        LmcEmailAddress[] addrs = msg.getEmailAddresses();
        for (int i = 0; addrs != null && i < addrs.length; ++i) {
            this.addEmailAddress(m, addrs[i]);
        }
        DomUtil.add(m, "su", msg.getSubject());
        String content = msg.getContent();
        if (content != null) {
            DomUtil.add(m, "content", content);
        }
        if (inReplyTo != null) {
            DomUtil.add(m, "irt", inReplyTo);
        }
        if ((mp = msg.getMimePart(0)) != null) {
            this.addMimePart(m, mp);
        }
        if ((attachmentIDs = msg.getAttachmentIDs()) != null) {
            for (int i = 0; i < attachmentIDs.length; ++i) {
                Element aid = DomUtil.add(m, "attach", "");
                LmcSoapRequest.addAttrNotNull(aid, "aid", attachmentIDs[i]);
            }
        }
        if (fwdPartNumbers != null) {
            Element attach = DomUtil.add(m, "attach", "");
            for (int i = 0; i < fwdPartNumbers.length; ++i) {
                Element part = DomUtil.add(attach, "mp", "");
                DomUtil.addAttr(part, "mid", fwdMsgID);
                DomUtil.addAttr(part, "part", fwdPartNumbers[i]);
            }
        }
    }

    protected void addMimePart(Element m, LmcMimePart mp) {
        Element mpElem = DomUtil.add(m, "mp", "");
        LmcSoapRequest.addAttrNotNull(mpElem, "part", mp.getPartName());
        LmcSoapRequest.addAttrNotNull(mpElem, "body", mp.getIsBody());
        LmcSoapRequest.addAttrNotNull(mpElem, "s", mp.getSize());
        LmcSoapRequest.addAttrNotNull(mpElem, "mid", mp.getMessageID());
        LmcSoapRequest.addAttrNotNull(mpElem, "cid", mp.getConvID());
        LmcSoapRequest.addAttrNotNull(mpElem, "ct", mp.getContentType());
        LmcSoapRequest.addAttrNotNull(mpElem, "name", mp.getContentTypeName());
        LmcSoapRequest.addAttrNotNull(mpElem, "cd", mp.getContentDisp());
        LmcSoapRequest.addAttrNotNull(mpElem, "filename", mp.getContentDispFilename());
        String content = mp.getContent();
        if (content != null) {
            Element cElem = DomUtil.add(mpElem, "content", content);
            LmcSoapRequest.addAttrNotNull(cElem, "cte", mp.getContentEncoding());
        }
        LmcMimePart[] subParts = mp.getSubParts();
        for (int i = 0; subParts != null && i < subParts.length; ++i) {
            this.addMimePart(mpElem, subParts[i]);
        }
    }

    protected void addEmailAddress(Element m, LmcEmailAddress addr) {
        String content = addr.getContent();
        Element e = DomUtil.add(m, "e", content == null ? "" : content);
        LmcSoapRequest.addAttrNotNull(e, "t", addr.getType());
        LmcSoapRequest.addAttrNotNull(e, "a", addr.getEmailAddress());
        LmcSoapRequest.addAttrNotNull(e, "p", addr.getPersonalName());
    }
}

