/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.client.soap;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.DomUtil;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.ZimbraHttpConnectionManager;
import com.zimbra.cs.client.LmcMessage;
import com.zimbra.cs.client.LmcSession;
import com.zimbra.cs.client.soap.LmcSendMsgResponse;
import com.zimbra.cs.client.soap.LmcSoapClientException;
import com.zimbra.cs.client.soap.LmcSoapRequest;
import com.zimbra.cs.client.soap.LmcSoapResponse;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LmcSendMsgRequest
extends LmcSoapRequest {
    private LmcMessage mMsg;
    private String mInReplyTo;
    private String mFwdMsgID;
    private String[] mFwdPartNumbers;

    public void setMsg(LmcMessage m) {
        this.mMsg = m;
    }

    public LmcMessage getMsg() {
        return this.mMsg;
    }

    public void setReplyInfo(String inReplyTo) {
        this.mInReplyTo = inReplyTo;
    }

    public void setFwdInfo(String inReplyTo, String fwdMsgID, String[] fwdPartNumbers) {
        this.mInReplyTo = inReplyTo;
        this.mFwdMsgID = fwdMsgID;
        this.mFwdPartNumbers = fwdPartNumbers;
    }

    protected Element getRequestXML() {
        Element request = DocumentHelper.createElement(MailConstants.SEND_MSG_REQUEST);
        this.addMsg(request, this.mMsg, this.mInReplyTo, this.mFwdMsgID, this.mFwdPartNumbers);
        return request;
    }

    protected LmcSoapResponse parseResponseXML(Element responseXML) throws ServiceException {
        Element m = DomUtil.get(responseXML, "m");
        LmcSendMsgResponse response = new LmcSendMsgResponse();
        response.setID(m.attributeValue("id"));
        return response;
    }

    public String postAttachment(String uploadURL, LmcSession session, File f, String domain, int msTimeout) throws LmcSoapClientException, IOException {
        String aid = null;
        if (session == null) {
            System.err.println(System.currentTimeMillis() + " " + Thread.currentThread() + " LmcSendMsgRequest.postAttachment session=null");
        }
        HttpClient client = ZimbraHttpConnectionManager.getInternalHttpConnMgr().newHttpClient();
        PostMethod post = new PostMethod(uploadURL);
        ZAuthToken zat = session.getAuthToken();
        Map<String, String> cookieMap = zat.cookieMap(false);
        if (cookieMap != null) {
            HttpState initialState = new HttpState();
            for (Map.Entry<String, String> ck : cookieMap.entrySet()) {
                Cookie cookie = new Cookie(domain, ck.getKey(), ck.getValue(), "/", -1, false);
                initialState.addCookie(cookie);
            }
            client.setState(initialState);
            client.getParams().setCookiePolicy("compatibility");
        }
        post.getParams().setSoTimeout(msTimeout);
        int statusCode = -1;
        try {
            try {
                int firstQuote;
                int lastQuote;
                String response;
                String contentType = URLConnection.getFileNameMap().getContentTypeFor(f.getName());
                Part[] parts = new Part[]{new FilePart(f.getName(), f, contentType, "UTF-8")};
                post.setRequestEntity(new MultipartRequestEntity(parts, post.getParams()));
                statusCode = client.executeMethod(post);
                if (statusCode == 200) {
                    response = post.getResponseBodyAsString();
                    lastQuote = response.lastIndexOf("'");
                    firstQuote = response.indexOf("','") + 3;
                    if (lastQuote == -1 || firstQuote == -1) {
                        throw new LmcSoapClientException("Attachment post failed, unexpected response: " + response);
                    }
                } else {
                    throw new LmcSoapClientException("Attachment post failed, status=" + statusCode);
                }
                aid = response.substring(firstQuote, lastQuote);
                Object var18_19 = null;
            }
            catch (IOException e) {
                System.err.println("Attachment post failed");
                e.printStackTrace();
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            post.releaseConnection();
            throw throwable;
        }
        post.releaseConnection();
        return aid;
    }
}

