/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.client.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.DomUtil;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.client.LmcConversation;
import com.zimbra.cs.client.soap.LmcSearchResponse;
import com.zimbra.cs.client.soap.LmcSoapClientException;
import com.zimbra.cs.client.soap.LmcSoapRequest;
import com.zimbra.cs.client.soap.LmcSoapResponse;
import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class LmcSearchRequest
extends LmcSoapRequest {
    private String mLimit;
    private String mOffset;
    private String mTypes;
    private String mSortBy;
    private String mQuery;

    public void setLimit(String l) {
        this.mLimit = l;
    }

    public void setOffset(String o) {
        this.mOffset = o;
    }

    public void setTypes(String t) {
        this.mTypes = t;
    }

    public void setSortBy(String s) {
        this.mSortBy = s;
    }

    public void setQuery(String q) {
        this.mQuery = q;
    }

    public String getLimit() {
        return this.mLimit;
    }

    public String getOffset() {
        return this.mOffset;
    }

    public String getTypes() {
        return this.mTypes;
    }

    public String getSortBy() {
        return this.mSortBy;
    }

    public String getQuery() {
        return this.mQuery;
    }

    protected Element createQuery(QName elemName) {
        Element request = DocumentHelper.createElement(elemName);
        LmcSearchRequest.addAttrNotNull(request, "limit", this.mLimit);
        LmcSearchRequest.addAttrNotNull(request, "offset", this.mOffset);
        LmcSearchRequest.addAttrNotNull(request, "types", this.mTypes);
        LmcSearchRequest.addAttrNotNull(request, "sortBy", this.mSortBy);
        DomUtil.add(request, "query", this.mQuery);
        return request;
    }

    protected Element getRequestXML() {
        return this.createQuery(MailConstants.SEARCH_REQUEST);
    }

    protected void parseResponse(LmcSearchResponse response, Element responseXML) throws ServiceException, LmcSoapClientException {
        response.setOffset(DomUtil.getAttr(responseXML, "offset"));
        response.setMore(DomUtil.getAttr(responseXML, "more"));
        ArrayList<LmcConversation> mailItems = new ArrayList<LmcConversation>();
        Iterator it = responseXML.elementIterator();
        while (it.hasNext()) {
            Object o;
            Element e = (Element)it.next();
            String elementType = e.getQName().getName();
            if (elementType.equals("c")) {
                o = this.parseConversation(e);
            } else if (elementType.equals("m")) {
                o = this.parseMessage(e);
            } else if (elementType.equals("mp")) {
                o = this.parseMimePart(e);
            } else if (elementType.equals("cn")) {
                o = this.parseContact(e);
            } else if (elementType.equals("note")) {
                o = this.parseNote(e);
            } else if (elementType.equals("doc")) {
                o = this.parseDocument(e);
            } else if (elementType.equals("w")) {
                o = this.parseWiki(e);
            } else {
                throw new LmcSoapClientException("Unexpected element type " + elementType);
            }
            mailItems.add((LmcConversation)o);
        }
        response.setResults(mailItems);
    }

    protected LmcSoapResponse parseResponseXML(Element responseXML) throws ServiceException, LmcSoapClientException {
        LmcSearchResponse response = new LmcSearchResponse();
        this.parseResponse(response, responseXML);
        return response;
    }
}

