/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.client.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.DomUtil;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.client.LmcDocument;
import com.zimbra.cs.client.soap.LmcSaveDocumentResponse;
import com.zimbra.cs.client.soap.LmcSendMsgRequest;
import com.zimbra.cs.client.soap.LmcSoapRequest;
import com.zimbra.cs.client.soap.LmcSoapResponse;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LmcSaveDocumentRequest
extends LmcSendMsgRequest {
    private LmcDocument mDoc;

    public void setDocument(LmcDocument doc) {
        this.mDoc = doc;
    }

    public LmcDocument getDocument() {
        return this.mDoc;
    }

    protected Element getRequestXML() {
        Element request = DocumentHelper.createElement(MailConstants.SAVE_DOCUMENT_REQUEST);
        Element doc = DomUtil.add(request, "doc", "");
        LmcSoapRequest.addAttrNotNull(doc, "name", this.mDoc.getName());
        LmcSoapRequest.addAttrNotNull(doc, "ct", this.mDoc.getContentType());
        LmcSoapRequest.addAttrNotNull(doc, "l", this.mDoc.getFolder());
        Element upload = DomUtil.add(doc, "upload", "");
        LmcSoapRequest.addAttrNotNull(upload, "id", this.mDoc.getAttachmentId());
        return request;
    }

    protected LmcSoapResponse parseResponseXML(Element responseXML) throws ServiceException {
        LmcSaveDocumentResponse response = new LmcSaveDocumentResponse();
        LmcDocument doc = this.parseDocument(DomUtil.get(responseXML, "doc"));
        response.setDocument(doc);
        return response;
    }
}

