/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.client.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.DomUtil;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.client.soap.LmcNoteActionResponse;
import com.zimbra.cs.client.soap.LmcSoapRequest;
import com.zimbra.cs.client.soap.LmcSoapResponse;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LmcNoteActionRequest
extends LmcSoapRequest {
    private String mIDList;
    private String mOp;
    private String mTargetFolder;
    private String mColor;
    private String mTag;

    public void setNoteList(String idList) {
        this.mIDList = idList;
    }

    public void setOp(String op) {
        this.mOp = op;
    }

    public void setTag(String t) {
        this.mTag = t;
    }

    public void setTargetFolder(String f) {
        this.mTargetFolder = f;
    }

    public void setColor(String c) {
        this.mColor = c;
    }

    public String getNoteList() {
        return this.mIDList;
    }

    public String getOp() {
        return this.mOp;
    }

    public String getTargetFolder() {
        return this.mTargetFolder;
    }

    public String getColor() {
        return this.mColor;
    }

    public String getTag() {
        return this.mTag;
    }

    protected Element getRequestXML() {
        Element request = DocumentHelper.createElement(MailConstants.NOTE_ACTION_REQUEST);
        Element a = DomUtil.add(request, "action", "");
        DomUtil.addAttr(a, "id", this.mIDList);
        DomUtil.addAttr(a, "op", this.mOp);
        DomUtil.addAttr(a, "tag", this.mTag);
        DomUtil.addAttr(a, "l", this.mTargetFolder);
        DomUtil.addAttr(a, "color", this.mColor);
        return request;
    }

    protected LmcSoapResponse parseResponseXML(Element responseXML) throws ServiceException {
        LmcNoteActionResponse response = new LmcNoteActionResponse();
        Element a = DomUtil.get(responseXML, "action");
        response.setNoteList(DomUtil.getAttr(a, "id"));
        response.setOp(DomUtil.getAttr(a, "op"));
        return response;
    }
}

