/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.client.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.DomUtil;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.client.soap.LmcMsgActionResponse;
import com.zimbra.cs.client.soap.LmcSoapRequest;
import com.zimbra.cs.client.soap.LmcSoapResponse;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LmcMsgActionRequest
extends LmcSoapRequest {
    private String mIDList;
    private String mOp;
    private String mTag;
    private String mFolder;

    public void setMsgList(String idList) {
        this.mIDList = idList;
    }

    public void setOp(String op) {
        this.mOp = op;
    }

    public void setTag(String t) {
        this.mTag = t;
    }

    public void setFolder(String f) {
        this.mFolder = f;
    }

    public String getMsgList() {
        return this.mIDList;
    }

    public String getOp() {
        return this.mOp;
    }

    public String getTag() {
        return this.mTag;
    }

    public String getFolder() {
        return this.mFolder;
    }

    protected Element getRequestXML() {
        Element request = DocumentHelper.createElement(MailConstants.MSG_ACTION_REQUEST);
        Element a = DomUtil.add(request, "action", "");
        DomUtil.addAttr(a, "id", this.mIDList);
        DomUtil.addAttr(a, "op", this.mOp);
        DomUtil.addAttr(a, "tag", this.mTag);
        DomUtil.addAttr(a, "l", this.mFolder);
        return request;
    }

    protected LmcSoapResponse parseResponseXML(Element responseXML) throws ServiceException {
        LmcMsgActionResponse response = new LmcMsgActionResponse();
        Element a = DomUtil.get(responseXML, "action");
        response.setMsgList(DomUtil.getAttr(a, "id"));
        response.setOp(DomUtil.getAttr(a, "op"));
        return response;
    }
}

