/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.client.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.DomUtil;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapParseException;
import com.zimbra.cs.client.LmcWiki;
import com.zimbra.cs.client.soap.LmcGetWikiResponse;
import com.zimbra.cs.client.soap.LmcSoapClientException;
import com.zimbra.cs.client.soap.LmcSoapRequest;
import com.zimbra.cs.client.soap.LmcSoapResponse;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LmcGetWikiRequest
extends LmcSoapRequest {
    private String mName;
    private String mId;
    private String mFolder;
    private String mTraverse;
    private LmcWiki mWiki;

    public void setName(String name) {
        this.mName = name;
    }

    public void setId(String id) {
        this.mId = id;
    }

    public void setFolder(String f) {
        this.mFolder = f;
    }

    public void setTraverse(String t) {
        this.mTraverse = t;
    }

    public void setWiki(LmcWiki wiki) {
        this.mWiki = wiki;
    }

    public LmcWiki getWiki() {
        return this.mWiki;
    }

    protected Element getRequestXML() throws LmcSoapClientException {
        Element request = DocumentHelper.createElement(MailConstants.GET_WIKI_REQUEST);
        Element w = DomUtil.add(request, "w", "");
        if (this.mName != null) {
            LmcSoapRequest.addAttrNotNull(w, "name", this.mName);
        } else if (this.mId != null) {
            LmcSoapRequest.addAttrNotNull(w, "id", this.mId);
        } else {
            return request;
        }
        LmcSoapRequest.addAttrNotNull(w, "l", this.mFolder);
        LmcSoapRequest.addAttrNotNull(w, "tr", this.mTraverse);
        return request;
    }

    protected LmcSoapResponse parseResponseXML(Element responseXML) throws SoapParseException, ServiceException, LmcSoapClientException {
        LmcGetWikiResponse response = new LmcGetWikiResponse();
        LmcWiki wiki = this.parseWiki(DomUtil.get(responseXML, "w"));
        response.setWiki(wiki);
        return response;
    }
}

