/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.client.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.DomUtil;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.client.LmcConversation;
import com.zimbra.cs.client.soap.LmcGetConvResponse;
import com.zimbra.cs.client.soap.LmcSoapClientException;
import com.zimbra.cs.client.soap.LmcSoapRequest;
import com.zimbra.cs.client.soap.LmcSoapResponse;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LmcGetConvRequest
extends LmcSoapRequest {
    private String mConvID;
    private String[] mMsgsToGet;

    public void setConvToGet(String f) {
        this.mConvID = f;
    }

    public void setMsgsToGet(String[] m) {
        this.mMsgsToGet = m;
    }

    public String getConvToGet() {
        return this.mConvID;
    }

    public String[] getMsgsToGet() {
        return this.mMsgsToGet;
    }

    protected Element getRequestXML() {
        Element request = DocumentHelper.createElement(MailConstants.GET_CONV_REQUEST);
        Element convElement = DomUtil.add(request, "c", "");
        DomUtil.addAttr(convElement, "id", this.mConvID);
        if (this.mMsgsToGet != null) {
            for (int i = 0; i < this.mMsgsToGet.length; ++i) {
                Element m = DomUtil.add(convElement, "m", "");
                DomUtil.addAttr(m, "id", this.mMsgsToGet[i]);
            }
        }
        return request;
    }

    protected LmcSoapResponse parseResponseXML(Element responseXML) throws ServiceException, LmcSoapClientException {
        LmcConversation c = this.parseConversation(DomUtil.get(responseXML, "c"));
        LmcGetConvResponse response = new LmcGetConvResponse();
        response.setConv(c);
        return response;
    }
}

