/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.client.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.DomUtil;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.client.soap.LmcFolderActionResponse;
import com.zimbra.cs.client.soap.LmcSoapRequest;
import com.zimbra.cs.client.soap.LmcSoapResponse;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LmcFolderActionRequest
extends LmcSoapRequest {
    private String mIDList;
    private String mOp;
    private String mTargetFolder;
    private String mName;
    private String mPerm;
    private String mGrantee;
    private String mD;

    public void setFolderList(String idList) {
        this.mIDList = idList;
    }

    public void setOp(String op) {
        this.mOp = op;
    }

    public void setName(String t) {
        this.mName = t;
    }

    public void setTargetFolder(String f) {
        this.mTargetFolder = f;
    }

    public void setGrant(String perm, String grantee, String d) {
        this.mPerm = perm;
        this.mGrantee = grantee;
        this.mD = d;
    }

    public String getFolderList() {
        return this.mIDList;
    }

    public String getOp() {
        return this.mOp;
    }

    public String getTargetFolder() {
        return this.mTargetFolder;
    }

    public String getName() {
        return this.mName;
    }

    protected Element getRequestXML() {
        Element request = DocumentHelper.createElement(MailConstants.FOLDER_ACTION_REQUEST);
        Element a = DomUtil.add(request, "action", "");
        if (this.mIDList != null) {
            DomUtil.addAttr(a, "id", this.mIDList);
        }
        if (this.mOp != null) {
            DomUtil.addAttr(a, "op", this.mOp);
            if (this.mOp.equals("grant") || this.mOp.equals("!grant")) {
                Element grant = DomUtil.add(a, "grant", "");
                if (this.mPerm != null) {
                    DomUtil.addAttr(grant, "perm", this.mPerm);
                }
                if (this.mGrantee != null) {
                    DomUtil.addAttr(grant, "gt", this.mGrantee);
                }
                if (this.mD != null) {
                    DomUtil.addAttr(grant, "d", this.mD);
                }
            }
        }
        if (this.mName != null) {
            DomUtil.addAttr(a, "name", this.mName);
        }
        if (this.mTargetFolder != null) {
            DomUtil.addAttr(a, "l", this.mTargetFolder);
        }
        return request;
    }

    protected LmcSoapResponse parseResponseXML(Element responseXML) throws ServiceException {
        LmcFolderActionResponse response = new LmcFolderActionResponse();
        Element a = DomUtil.get(responseXML, "action");
        response.setFolderList(DomUtil.getAttr(a, "id"));
        response.setOp(DomUtil.getAttr(a, "op"));
        return response;
    }
}

