/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.client.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.DomUtil;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.client.LmcFolder;
import com.zimbra.cs.client.soap.LmcCreateFolderResponse;
import com.zimbra.cs.client.soap.LmcSoapRequest;
import com.zimbra.cs.client.soap.LmcSoapResponse;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LmcCreateFolderRequest
extends LmcSoapRequest {
    private String mName;
    private String mParentID;
    private String mView;

    public void setParentID(String id) {
        this.mParentID = id;
    }

    public void setName(String n) {
        this.mName = n;
    }

    public void setView(String n) {
        this.mView = n;
    }

    public String getParentID() {
        return this.mParentID;
    }

    public String getName() {
        return this.mName;
    }

    public String getView() {
        return this.mView;
    }

    protected Element getRequestXML() {
        Element request = DocumentHelper.createElement(MailConstants.CREATE_FOLDER_REQUEST);
        Element f = DomUtil.add(request, "folder", "");
        DomUtil.addAttr(f, "name", this.mName);
        DomUtil.addAttr(f, "l", this.mParentID);
        if (this.mView != null) {
            DomUtil.addAttr(f, "view", this.mView);
        }
        return request;
    }

    protected LmcSoapResponse parseResponseXML(Element responseXML) throws ServiceException {
        Element folderElem = DomUtil.get(responseXML, "folder");
        LmcFolder f = this.parseFolder(folderElem);
        LmcCreateFolderResponse response = new LmcCreateFolderResponse();
        response.setFolder(f);
        return response;
    }
}

