/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.client.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.DomUtil;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapParseException;
import com.zimbra.cs.client.LmcContact;
import com.zimbra.cs.client.LmcContactAttr;
import com.zimbra.cs.client.soap.LmcCreateContactResponse;
import com.zimbra.cs.client.soap.LmcSoapClientException;
import com.zimbra.cs.client.soap.LmcSoapRequest;
import com.zimbra.cs.client.soap.LmcSoapResponse;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LmcCreateContactRequest
extends LmcSoapRequest {
    private LmcContact mContact;

    public void setContact(LmcContact c) {
        this.mContact = c;
    }

    public LmcContact getContact() {
        return this.mContact;
    }

    protected Element getRequestXML() throws LmcSoapClientException {
        Element request = DocumentHelper.createElement(MailConstants.CREATE_CONTACT_REQUEST);
        Element newCN = DomUtil.add(request, "cn", "");
        LmcSoapRequest.addAttrNotNull(newCN, "l", this.mContact.getFolder());
        LmcSoapRequest.addAttrNotNull(newCN, "t", this.mContact.getTags());
        LmcContactAttr[] attrs = this.mContact.getAttrs();
        for (int i = 0; attrs != null && i < attrs.length; ++i) {
            this.addContactAttr(newCN, attrs[i]);
        }
        return request;
    }

    protected LmcSoapResponse parseResponseXML(Element responseXML) throws SoapParseException, ServiceException, LmcSoapClientException {
        LmcCreateContactResponse response = new LmcCreateContactResponse();
        LmcContact c = this.parseContact(DomUtil.get(responseXML, "cn"));
        response.setContact(c);
        return response;
    }
}

