/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.client.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.DomUtil;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.client.soap.LmcConvActionResponse;
import com.zimbra.cs.client.soap.LmcSoapRequest;
import com.zimbra.cs.client.soap.LmcSoapResponse;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LmcConvActionRequest
extends LmcSoapRequest {
    private String mIDList;
    private String mOp;
    private String mTag;
    private String mFolder;
    private String mPosition;
    private String mContent;

    public void setConvList(String idList) {
        this.mIDList = idList;
    }

    public void setOp(String op) {
        this.mOp = op;
    }

    public void setTag(String t) {
        this.mTag = t;
    }

    public void setFolder(String f) {
        this.mFolder = f;
    }

    public void setPosition(String p) {
        this.mPosition = p;
    }

    public void setContent(String c) {
        this.mContent = c;
    }

    public String getConvList() {
        return this.mIDList;
    }

    public String getOp() {
        return this.mOp;
    }

    public String getTag() {
        return this.mTag;
    }

    public String getFolder() {
        return this.mFolder;
    }

    public String getContent() {
        return this.mContent;
    }

    public String getPosition() {
        return this.mPosition;
    }

    protected Element getRequestXML() {
        Element request = DocumentHelper.createElement(MailConstants.CONV_ACTION_REQUEST);
        Element a = DomUtil.add(request, "action", "");
        DomUtil.addAttr(a, "id", this.mIDList);
        DomUtil.addAttr(a, "op", this.mOp);
        DomUtil.addAttr(a, "tag", this.mTag);
        DomUtil.addAttr(a, "l", this.mFolder);
        if (this.mContent != null) {
            DomUtil.add(a, "content", this.mContent);
        }
        return request;
    }

    protected LmcSoapResponse parseResponseXML(Element responseXML) throws ServiceException {
        LmcConvActionResponse response = new LmcConvActionResponse();
        Element a = DomUtil.get(responseXML, "action");
        response.setConvList(DomUtil.getAttr(a, "id"));
        response.setOp(DomUtil.getAttr(a, "op"));
        return response;
    }
}

