/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.client.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.DomUtil;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.client.soap.LmcCheckSpellingResponse;
import com.zimbra.cs.client.soap.LmcSoapRequest;
import com.zimbra.cs.client.soap.LmcSoapResponse;
import java.util.Iterator;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LmcCheckSpellingRequest
extends LmcSoapRequest {
    private String mText;

    public LmcCheckSpellingRequest(String text) {
        this.mText = text;
    }

    public String getText() {
        return this.mText;
    }

    protected Element getRequestXML() {
        Element request = DocumentHelper.createElement(MailConstants.CHECK_SPELLING_REQUEST);
        request.addText(this.mText);
        return request;
    }

    protected LmcSoapResponse parseResponseXML(Element responseXML) throws ServiceException {
        boolean isAvailable = DomUtil.getAttrBoolean(responseXML, "available");
        LmcCheckSpellingResponse response = new LmcCheckSpellingResponse(isAvailable);
        Iterator i = responseXML.elementIterator();
        while (i.hasNext()) {
            Element misspelled = (Element)i.next();
            String word = DomUtil.getAttr(misspelled, "word");
            String suggestions = DomUtil.getAttr(misspelled, "suggestions");
            response.addMisspelled(word, suggestions.split(","));
        }
        return response;
    }
}

