/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.client.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.DomUtil;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapParseException;
import com.zimbra.cs.client.LmcBrowseData;
import com.zimbra.cs.client.soap.LmcBrowseResponse;
import com.zimbra.cs.client.soap.LmcSoapClientException;
import com.zimbra.cs.client.soap.LmcSoapRequest;
import com.zimbra.cs.client.soap.LmcSoapResponse;
import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LmcBrowseRequest
extends LmcSoapRequest {
    private String mBrowseBy;

    public void setBrowseBy(String b) {
        this.mBrowseBy = b;
    }

    public String getBrowseBy() {
        return this.mBrowseBy;
    }

    protected Element getRequestXML() throws LmcSoapClientException {
        Element request = DocumentHelper.createElement(MailConstants.BROWSE_REQUEST);
        DomUtil.addAttr(request, "browseBy", this.mBrowseBy);
        return request;
    }

    protected LmcBrowseData parseBrowseData(Element bdElem) {
        LmcBrowseData bd = new LmcBrowseData();
        bd.setFlags(bdElem.attributeValue("h"));
        bd.setData(bdElem.getText());
        return bd;
    }

    protected LmcSoapResponse parseResponseXML(Element parentElem) throws SoapParseException, ServiceException, LmcSoapClientException {
        LmcBrowseResponse response = new LmcBrowseResponse();
        ArrayList<LmcBrowseData> bdArray = new ArrayList<LmcBrowseData>();
        Iterator ait = parentElem.elementIterator("bd");
        while (ait.hasNext()) {
            Element a = (Element)ait.next();
            bdArray.add(this.parseBrowseData(a));
        }
        if (!bdArray.isEmpty()) {
            LmcBrowseData[] bds = new LmcBrowseData[bdArray.size()];
            response.setData(bdArray.toArray(bds));
        }
        return response;
    }
}

