/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.client.soap;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.DomUtil;
import com.zimbra.cs.client.LmcSession;
import com.zimbra.cs.client.soap.LmcAuthResponse;
import com.zimbra.cs.client.soap.LmcSoapRequest;
import com.zimbra.cs.client.soap.LmcSoapResponse;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LmcAuthRequest
extends LmcSoapRequest {
    private String mUsername;
    private String mPassword;

    public void setUsername(String u) {
        this.mUsername = u;
    }

    public void setPassword(String p) {
        this.mPassword = p;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public String getPassword() {
        return this.mPassword;
    }

    protected Element getRequestXML() {
        Element request = DocumentHelper.createElement(AccountConstants.AUTH_REQUEST);
        Element a = DomUtil.add(request, "account", this.mUsername);
        DomUtil.addAttr(a, "by", "name");
        DomUtil.add(request, "password", this.mPassword);
        return request;
    }

    protected LmcSoapResponse parseResponseXML(Element responseXML) throws ServiceException {
        String authToken = DomUtil.getString(responseXML, "authToken");
        ZAuthToken zat = new ZAuthToken(null, authToken, null);
        String sessionId = DomUtil.getString(responseXML, "session", null);
        LmcAuthResponse responseObj = new LmcAuthResponse();
        LmcSession sess = new LmcSession(zat, sessionId);
        responseObj.setSession(sess);
        return responseObj;
    }
}

