/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.client;

public class LmcTag {
    private String mName;
    private String mColor;
    private String mID;
    private long mUnreadCount;
    private boolean isUnreadCountValid;

    public LmcTag(String id, String name, String color, long unreadCount) {
        this.mID = id;
        this.mName = name;
        this.mColor = color;
        if (unreadCount == -1L) {
            this.isUnreadCountValid = false;
        } else {
            this.isUnreadCountValid = true;
            this.mUnreadCount = unreadCount;
        }
    }

    public LmcTag(String id, String name, String color) {
        this(id, name, color, -1L);
    }

    public LmcTag() {
    }

    public void setID(String i) {
        this.mID = i;
    }

    public void setName(String n) {
        this.mName = n;
    }

    public void setColor(String c) {
        this.mColor = c;
    }

    public void setUnreadCount(int n) {
        this.mUnreadCount = n;
        this.isUnreadCountValid = true;
    }

    public String getID() {
        return this.mID;
    }

    public String getName() {
        return this.mName;
    }

    public String getColor() {
        return this.mColor;
    }

    public long getUnreadCount() throws IllegalStateException {
        if (!this.isUnreadCountValid) {
            throw new IllegalStateException("Unread count not valid");
        }
        return this.mUnreadCount;
    }

    public String toString() {
        return "Name=\"" + this.mName + " \"id=\"" + this.mID + "\" color=\"" + this.mColor + "\" unreadCount=\"" + this.mUnreadCount + "\"";
    }
}

