/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.client;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.util.ZimbraHttpConnectionManager;
import com.zimbra.cs.client.LmcEmailAddress;
import com.zimbra.cs.client.LmcMimePart;
import com.zimbra.cs.client.LmcSession;
import com.zimbra.cs.client.soap.LmcSoapClientException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.GetMethod;

public class LmcMessage {
    private String mID;
    private String mMsgIDHeader;
    private String mFlags;
    private long mSize;
    private String mDate;
    private String mConvID;
    private String mScore;
    private String mSubject;
    private String mFragment;
    private String mOriginalID;
    private String mFolder;
    private LmcEmailAddress[] mEmailAddrs;
    private ArrayList<LmcMimePart> mMimeParts = new ArrayList();
    private String mContentMatched;
    private String mTag;
    private String mContent;
    private String[] mAttachmentIDs;
    private boolean mIsUnread = false;

    public void setFolder(String f) {
        this.mFolder = f;
    }

    public void setID(String i) {
        this.mID = i;
    }

    public void setMsgIDHeader(String h) {
        this.mMsgIDHeader = h;
    }

    public void setFlags(String f) {
        this.mFlags = f;
        this.mIsUnread = this.mFlags != null && this.mFlags.indexOf("u") >= 0;
    }

    public void setSize(long s) {
        this.mSize = s;
    }

    public void setDate(String d) {
        this.mDate = d;
    }

    public void setConvID(String cid) {
        this.mConvID = cid;
    }

    public void setScore(String s) {
        this.mScore = s;
    }

    public void setOriginalID(String o) {
        this.mOriginalID = o;
    }

    public void setEmailAddresses(LmcEmailAddress[] e) {
        this.mEmailAddrs = e;
    }

    public void addMimePart(LmcMimePart m) {
        this.mMimeParts.add(m);
    }

    public void clearMimeParts() {
        this.mMimeParts.clear();
    }

    public void setContentMatched(String c) {
        this.mContentMatched = c;
    }

    public void setFragment(String f) {
        this.mFragment = f;
    }

    public void setSubject(String s) {
        this.mSubject = s;
    }

    public void setTag(String t) {
        this.mTag = t;
    }

    public void setContent(String c) {
        this.mContent = c;
    }

    public void setAttachmentIDs(String[] ids) {
        this.mAttachmentIDs = ids;
    }

    public String getSubject() {
        return this.mSubject;
    }

    public String getFragment() {
        return this.mFragment;
    }

    public String getFolder() {
        return this.mFolder;
    }

    public String getID() {
        return this.mID;
    }

    public String getMsgIDHeader() {
        return this.mMsgIDHeader;
    }

    public String getFlags() {
        return this.mFlags;
    }

    public long getSize() {
        return this.mSize;
    }

    public String getDate() {
        return this.mDate;
    }

    public String getConvID() {
        return this.mConvID;
    }

    public String getScore() {
        return this.mScore;
    }

    public String getOriginalID() {
        return this.mOriginalID;
    }

    public String getContentMatched() {
        return this.mContentMatched;
    }

    public LmcEmailAddress[] getEmailAddresses() {
        return this.mEmailAddrs;
    }

    public LmcEmailAddress getFromAddress() {
        for (int i = 0; i < this.mEmailAddrs.length; ++i) {
            if (!this.mEmailAddrs[i].getType().equals("f")) continue;
            return this.mEmailAddrs[i];
        }
        return null;
    }

    public int getNumMimeParts() {
        return this.mMimeParts.size();
    }

    public LmcMimePart getMimePart(int i) {
        return this.mMimeParts.get(i);
    }

    public String getTag() {
        return this.mTag;
    }

    public String getContent() {
        return this.mContent;
    }

    public String[] getAttachmentIDs() {
        return this.mAttachmentIDs;
    }

    public String toString() {
        String s = "Msg ID=\"" + this.mID + "\" folder=\"" + this.mFolder + "\" flags=\"" + this.mFlags + "\" size=\"" + this.mSize + "\" date=\"" + this.mDate + "\" convID=\"" + this.mConvID + "\" score=\"" + this.mScore + "\" origID=\"" + this.mOriginalID + "\" conMatched=\"" + this.mContentMatched + "\" fragment=\"" + this.mFragment + "\" subject=\"" + this.mSubject + "\" tag=\"" + this.mTag + "\"";
        s = s + "\n\t" + (this.mEmailAddrs == null ? 0 : this.mEmailAddrs.length) + " email addresses";
        s = s + "\n\t" + this.mMimeParts.size();
        return s;
    }

    public byte[] downloadAttachment(String partNo, String baseURL, LmcSession session, String cookieDomain, int msTimeout) throws LmcSoapClientException, IOException {
        int statusCode;
        GetMethod get;
        block8: {
            if (session == null) {
                System.err.println(System.currentTimeMillis() + " " + Thread.currentThread() + " LmcMessage.downloadAttachment session=null");
            }
            HttpClient client = ZimbraHttpConnectionManager.getInternalHttpConnMgr().newHttpClient();
            String url = baseURL + "?id=" + this.getID() + "&part=" + partNo;
            get = new GetMethod(url);
            ZAuthToken zat = session.getAuthToken();
            Map<String, String> cookieMap = zat.cookieMap(false);
            if (cookieMap != null) {
                HttpState initialState = new HttpState();
                for (Map.Entry<String, String> ck : cookieMap.entrySet()) {
                    Cookie cookie = new Cookie(cookieDomain, ck.getKey(), ck.getValue(), "/", -1, false);
                    initialState.addCookie(cookie);
                }
                client.setState(initialState);
                client.getParams().setCookiePolicy("compatibility");
            }
            get.getParams().setSoTimeout(msTimeout);
            statusCode = -1;
            statusCode = client.executeMethod(get);
            if (statusCode != 200) break block8;
            Object i$ = get.getResponseBody();
            Object var16_17 = null;
            get.releaseConnection();
            return i$;
        }
        try {
            try {
                throw new LmcSoapClientException("Attachment download failed, status=" + statusCode);
            }
            catch (IOException e) {
                System.err.println("Attachment download failed");
                e.printStackTrace();
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            get.releaseConnection();
            throw throwable;
        }
    }

    public boolean isUnread() {
        return this.mIsUnread;
    }
}

